/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation.rollup;

import crazydev.iccube.cluster.master.facts.M_ClusterTupleAggregator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import java.io.Serializable;
import java.util.List;

public abstract class OlapScalarEntityRollupProcessor {
    protected OlapScalarEntityRollupProcessor() {
    }

    public OlapScalarEntity evalTuple(GFContext context, GFFactsEvalTuple evalTuple) {
        OlapMeasureMember measure = evalTuple.getMeasure();
        OlapHierarchy rollupHierarchy = this.getRollupHierarchy(context, measure);
        int rollupMemberPos = evalTuple.getMemberPos(rollupHierarchy);
        if (rollupMemberPos != -1) {
            OlapMember rollupMember = evalTuple.getMember(rollupMemberPos);
            OlapScalarEntity value = this.evalTupleForRollupMember(context, evalTuple, rollupMemberPos, rollupMember);
            return value;
        }
        List<OlapMember> others = context.getSliceSubselectDefinedMembers(rollupHierarchy);
        OlapMember rollupMember = OlapMember.getCommonRoot(others);
        if (rollupMember == null && (rollupMember = rollupHierarchy.getNullableDefaultMember(context.getMemberFilter())) == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        GFFactsEvalTuple rollupTuple = evalTuple.addRollupMember(context, rollupMember);
        OlapScalarEntity value = this.evalTupleForRollupMember(context, rollupTuple, rollupTuple.getMemberCount() - 1, rollupMember);
        return value;
    }

    protected abstract OlapScalarEntity evalTupleForRollupMember(GFContext var1, GFFactsEvalTuple var2, int var3, OlapMember var4);

    protected OlapScalarEntity doEvalTuple(GFContext context, GFFactsEvalTuple evalTuple) {
        OlapScalarEntity val = M_ClusterTupleAggregator.aggregateTuple(context, evalTuple);
        return val;
    }

    public boolean isDefault() {
        return false;
    }

    private OlapHierarchy getRollupHierarchy(IOlapEvaluationExceptionContext context, OlapMeasureMember measure) {
        OlapHierarchy hierarchy = measure.getRollupHierarchy();
        if (hierarchy == null) {
            OlapNameContext nameContext = context.getNameContext();
            throw new OlapEvaluationException(context, OlapErrorCode.MISSING_ROLLUP_HIERARCHY, new Serializable[]{measure.getName(nameContext), measure.getHierarchyAggregationType()});
        }
        return hierarchy;
    }
}

