/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation.multicolumn;

import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.scalar.OlapCellMeasureVectorScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;

public class OlapFactMultiColumnAggregator
extends OlapScalarEntityFactColumn.Aggregator {
    private final OlapScalarEntityFactColumn.Aggregator[] aggregators;
    private final OlapException[] errors;

    public OlapFactMultiColumnAggregator(OlapScalarEntityFactColumn.Aggregator[] aggregators) {
        this.aggregators = aggregators;
        this.errors = new OlapException[aggregators.length];
    }

    public OlapScalarEntityFactColumn.Aggregator getAggregator(int idx) {
        return this.aggregators[idx];
    }

    public void setError(int idx, OlapException error) {
        this.errors[idx] = error;
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        OlapScalarEntity[] values = new OlapScalarEntity[this.aggregators.length];
        for (int ii = 0; ii < this.aggregators.length; ++ii) {
            OlapScalarEntityFactColumn.Aggregator aggregator = this.aggregators[ii];
            OlapScalarEntity value = aggregator.asScalarEntity();
            OlapException error = this.errors[ii];
            values[ii] = error == null ? value : null;
        }
        OlapCellMeasureVectorScalarEntity entities = new OlapCellMeasureVectorScalarEntity(values, this.errors);
        return entities;
    }

    @Override
    public void aggregateFactPage(N_FactPage page) {
        for (OlapScalarEntityFactColumn.Aggregator aggregator : this.aggregators) {
            aggregator.aggregateFactPage(page);
        }
    }
}

