/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation;

import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapAvgChildrenRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapCloseNoEmptyRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapCloseRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapDefaultRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapOpenNoEmptyRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapOpenRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapScalarEntityRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapSumChildrenRollupProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.rollup.OlapUnaryOperatorProcessor;
import java.util.Arrays;

public abstract class OlapFactsRollupSolver {
    private static final OlapScalarEntityRollupProcessor[] rollupProcessors = new OlapScalarEntityRollupProcessor[OlapAggregationType.values().length];

    private OlapFactsRollupSolver() {
    }

    public static OlapScalarEntity evalTuple(GFContext context, GFFactsEvalTuple evalTuple) {
        OlapMeasureMember measure = evalTuple.getMeasure();
        OlapAggregationType aggregationType = measure.getHierarchyAggregationType();
        OlapScalarEntityRollupProcessor rollupProcessor = rollupProcessors[aggregationType.ordinal()];
        if (measure.isMeasureVector() && !rollupProcessor.isDefault()) {
            throw new RuntimeException("internal error: inconsistent multi-column evaluation");
        }
        OlapScalarEntity res = rollupProcessor.evalTuple(context, evalTuple);
        return res;
    }

    public static boolean isAggregationForMeasureVectorSupported(OlapAggregationType aggregation) {
        if (!aggregation.isAggregationForMeasureVectorSupported()) {
            return false;
        }
        OlapScalarEntityRollupProcessor processor = rollupProcessors[aggregation.ordinal()];
        return processor.isDefault();
    }

    public static boolean isDefaultRollupProcessor(OlapMeasureMember measure) {
        return OlapFactsRollupSolver.isDefaultRollupProcessor(measure.getHierarchyAggregationType());
    }

    public static boolean isDefaultRollupProcessor(OlapAggregationType aggregationType) {
        OlapScalarEntityRollupProcessor rollupProcessor = rollupProcessors[aggregationType.ordinal()];
        return rollupProcessor.isDefault();
    }

    static {
        Arrays.fill(rollupProcessors, new OlapDefaultRollupProcessor());
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.AVG_CHILDREN.ordinal()] = new OlapAvgChildrenRollupProcessor();
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.SUM_CHILDREN.ordinal()] = new OlapSumChildrenRollupProcessor();
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.OPEN.ordinal()] = new OlapOpenRollupProcessor();
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.CLOSE.ordinal()] = new OlapCloseRollupProcessor();
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.OPEN_NO_EMPTY.ordinal()] = new OlapOpenNoEmptyRollupProcessor();
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.CLOSE_NO_EMPTY.ordinal()] = new OlapCloseNoEmptyRollupProcessor();
        OlapFactsRollupSolver.rollupProcessors[OlapAggregationType.UNARY_OPERATOR.ordinal()] = new OlapUnaryOperatorProcessor();
    }
}

