/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.facts.aggregation;

import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsAggregationProcessor;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsBufferingCallback;
import crazydev.iccube.olap.eval.facts.aggregation.multicolumn.OlapFactMultiColumnAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import java.util.Objects;

public class OlapFactsMultiColumnAggregationProcessor
extends OlapFactsAggregationProcessor {
    private final OlapFactMultiColumnAggregator aggregator;
    private final OlapScalarEntityFactColumn[] columns;
    private final OlapFactsBufferingCallback buffer;

    public OlapFactsMultiColumnAggregationProcessor(OlapScalarEntityFactColumn.Aggregator aggregator, OlapScalarEntityFactColumn[] columns) {
        this.aggregator = (OlapFactMultiColumnAggregator)aggregator;
        this.columns = columns;
        this.buffer = new MultiColumnBufferingCallback(this);
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        return this.aggregator.asScalarEntity();
    }

    @Override
    public boolean neverStops() {
        return true;
    }

    @Override
    public boolean onRange(int startRowId, int endRowId) {
        this.buffer.onRange(startRowId, endRowId);
        return true;
    }

    @Override
    public boolean onPoint(int point) {
        this.buffer.onPoint(point);
        return true;
    }

    @Override
    public boolean onApplied() {
        this.buffer.onApplied();
        return true;
    }

    @Override
    public void processingPartitionedFactPage(N_FactPage factPage) {
        this.aggregator.aggregateFactPage(factPage);
    }

    class MultiColumnBufferingCallback
    extends OlapFactsBufferingCallback {
        final /* synthetic */ OlapFactsMultiColumnAggregationProcessor this$0;

        MultiColumnBufferingCallback(OlapFactsMultiColumnAggregationProcessor this$0) {
            OlapFactsMultiColumnAggregationProcessor olapFactsMultiColumnAggregationProcessor = this$0;
            Objects.requireNonNull(olapFactsMultiColumnAggregationProcessor);
            this.this$0 = olapFactsMultiColumnAggregationProcessor;
        }

        @Override
        protected void doOnRange(int startRowId, int endRowId) {
            for (int cc = 0; cc < this.this$0.columns.length; ++cc) {
                OlapScalarEntityFactColumn column = this.this$0.columns[cc];
                if (column == null) continue;
                try {
                    column.aggregateRange(this.this$0.aggregator.getAggregator(cc), startRowId, endRowId);
                    continue;
                }
                catch (OlapException error) {
                    this.this$0.aggregator.setError(cc, error);
                }
            }
        }

        @Override
        protected void doOnPoints(int[] rowIds, int len) {
            for (int cc = 0; cc < this.this$0.columns.length; ++cc) {
                OlapScalarEntityFactColumn column = this.this$0.columns[cc];
                if (column == null) continue;
                try {
                    column.aggregatePoints(this.this$0.aggregator.getAggregator(cc), rowIds, len);
                    continue;
                }
                catch (OlapException error) {
                    this.this$0.aggregator.setError(cc, error);
                }
            }
        }

        @Override
        protected void doOnPoint(int rowId) {
            for (int cc = 0; cc < this.this$0.columns.length; ++cc) {
                OlapScalarEntityFactColumn column = this.this$0.columns[cc];
                if (column == null) continue;
                try {
                    column.aggregatePoint(this.this$0.aggregator.getAggregator(cc), rowId);
                    continue;
                }
                catch (OlapException error) {
                    this.this$0.aggregator.setError(cc, error);
                }
            }
        }
    }
}

