/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.extra;

import crazydev.iccube.common.executor.IOlapThreadPoolExecutorTaskFactory;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorServiceListenerAdapter;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorConfiguration;
import crazydev.iccube.olap.eval.exception.OlapMdxEvaluationCancelled;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.executor.OlapMdxExtraThreadPoolExecutorService;
import crazydev.iccube.olap.executor.OlapMdxThreadPoolExecutorService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class OlapMdxExtraExecutor {
    public static final AtomicInteger UID_GENERATOR = new AtomicInteger();
    private final int uid = UID_GENERATOR.incrementAndGet();
    private final OlapMdxExecutorConfiguration configuration;
    @Nullable
    private final OlapMdxThreadPoolExecutorService service;
    private final int queueSize;

    public OlapMdxExtraExecutor(OlapMdxExecutorConfiguration configuration) {
        this.configuration = configuration;
        int threadCount = configuration.getThreadCount();
        this.service = threadCount > 0 ? new OlapMdxExtraThreadPoolExecutorService(threadCount) : null;
        this.queueSize = configuration.getQueueSize();
    }

    public int getUid() {
        return this.uid;
    }

    public static int getCurrentUid() {
        return UID_GENERATOR.get();
    }

    public OlapMdxExecutorConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isActivated() {
        return this.service != null;
    }

    public void shutdownNow() {
        OlapLoggers.GENERAL.info((Object)"[MDX-EXTRA] shutdown requested");
        if (this.service != null) {
            this.service.shutdownNow();
        }
        OlapLoggers.GENERAL.info((Object)"[MDX-EXTRA] bye");
    }

    public void execute(OlapMdxStatementExecutionContext sContext, IOlapThreadPoolExecutorTaskFactory tasks) throws OlapMdxEvaluationCancelled {
        if (this.service == null) {
            throw new RuntimeException("internal error: inconsistent usage of MDX extra. processor");
        }
        this.service.processTasks(sContext, this.queueSize, tasks, new OlapThreadPoolExecutorServiceListenerAdapter(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void onNextTaskException(RuntimeException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)"MDX extra. unexpected task generation exception", (Throwable)ex);
            }
        });
        if (sContext.isCancelling()) {
            throw new OlapMdxEvaluationCancelled();
        }
    }
}

