/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.configuration.component.properties.OlapLambdaProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.executors.lambda.GFSetEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class GFGeneralLambdaTupleEvaluator
extends GFLambdaTupleEvaluator {
    public static int TEST_SET_MIN_SIZE = -1;
    @Nullable
    private final OlapTuple miniTupleI;
    @Nullable
    private final Map<OlapTuple, GFSetEvaluator> evaluators;
    private List<OlapMemberOrigin> iTupleOrigins;

    public GFGeneralLambdaTupleEvaluator(OlapProperties properties, GFTupleEvaluator other, GFApplyLambdaNode lambdaNode, double fastEstimatedSize) {
        super(other, lambdaNode);
        this.miniTupleI = other instanceof GFMiniTupleEvaluator ? ((GFMiniTupleEvaluator)other).peekMiniTuple() : null;
        OlapLambdaProcessingMode mode = properties.getMdxEvalLambdaProcessingMode();
        if (!mode.has(OlapLambdaProcessingMode.SET_CALC)) {
            this.evaluators = null;
        } else {
            int minSize = properties.getMdxEvalSetCalculatorMinSize();
            if (TEST_SET_MIN_SIZE != -1) {
                minSize = TEST_SET_MIN_SIZE;
            }
            this.evaluators = fastEstimatedSize == -1.0 || fastEstimatedSize >= (double)minSize ? new HashMap<OlapTuple, GFSetEvaluator>() : null;
        }
    }

    @Override
    public boolean isAcceptingParallelLambdaProcessing() {
        return false;
    }

    @Override
    @Nullable
    public GFTupleEvaluationFrame pushEvaluatedTuple(GFContext context, OlapTuple iTuple) {
        if (this.iTupleOrigins == null || this.iTupleOrigins.size() != iTuple.getMemberCount()) {
            int mCount = iTuple.getMemberCount();
            this.iTupleOrigins = new ArrayList<OlapMemberOrigin>(mCount);
            for (int ii = 0; ii < mCount; ++ii) {
                this.iTupleOrigins.add(OlapMemberOrigin.I_TUPLE);
            }
        }
        return context.pushEvaluatedTuple(this.iTupleOrigins, iTuple);
    }

    @Override
    public OlapScalarEntity getValue(GFContext context, OlapTuple lambdaTuple, boolean noEmptyEvaluation) {
        throw new RuntimeException("internal error: inconsistent lambda evaluation (#getValue) [" + this.lambdaNode.getFunctionName() + "] " + String.valueOf(lambdaTuple));
    }

    @Override
    public OlapScalarEntity getFactsValue(GFContext context, OlapTuple miniTuple, boolean noEmptyEvaluation) {
        OlapScalarEntity res = this.doGetFactsValue(context, miniTuple, noEmptyEvaluation);
        return res;
    }

    @Override
    protected OlapScalarEntity getFactsValueFromParent(GFContext context, OlapTuple miniTuple, boolean noEmptyEvaluation) {
        OlapTuple miniTuple_ = this.miniCompleteIntoParent(context, miniTuple);
        OlapScalarEntity res = this.other.getFactsValue(context, miniTuple_, noEmptyEvaluation);
        return res;
    }

    @Override
    protected OlapScalarEntity getCalcValueFromParent(GFContext context, OlapTuple miniTuple, Supplier<OlapScalarEntity> supplier) {
        OlapTuple miniTuple_ = this.miniCompleteIntoParent(context, miniTuple);
        OlapScalarEntity res = this.other.getCalcValue(context, miniTuple_, supplier);
        return res;
    }

    private OlapTuple miniCompleteIntoParent(GFContext context, OlapTuple miniTuple) {
        int ii;
        OlapTupleDimensionality miniTupleD;
        if (this.miniTupleI == null) {
            return miniTuple;
        }
        OlapTupleDimensionality miniTupleID = this.miniTupleI.getTupleDimensionality();
        if (miniTupleID.isIn(miniTupleD = miniTuple.getTupleDimensionality())) {
            return miniTuple;
        }
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        int miniTupleS = miniTuple.getMemberCount();
        for (ii = 0; ii < miniTupleS; ++ii) {
            OlapMember member = miniTuple.getMember(ii);
            members.add(member);
        }
        int miniTupleIS = this.miniTupleI.getMemberCount();
        for (ii = 0; ii < miniTupleIS; ++ii) {
            OlapHierarchy hierarchyI;
            OlapMember memberI = this.miniTupleI.getMember(ii);
            if (memberI.isCalculated() || miniTupleD.isIn(hierarchyI = memberI.getHierarchy())) continue;
            members.add(memberI);
        }
        OlapTuple miniTuple_ = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, context.getTupleDimensionalityCache(), null, members);
        return miniTuple_;
    }

    protected OlapScalarEntity doGetFactsValue(GFContext context, OlapTuple lambdaTuple, boolean noEmptyEvaluation) {
        if (this.evaluators != null) {
            OlapScalarEntity res = this.doGetFactsValueWithSetEvaluators(context, lambdaTuple, noEmptyEvaluation);
            return res;
        }
        OlapScalarEntity res = this.doGetFactsValueWithoutSetEvaluators(context, lambdaTuple, noEmptyEvaluation);
        return res;
    }

    protected OlapScalarEntity doGetFactsValueWithSetEvaluators(GFContext context, OlapTuple lambdaTuple, boolean noEmptyEvaluation) {
        GFSetEvaluator evaluator = this.evaluators.computeIfAbsent(lambdaTuple, key -> {
            GFSetEvaluator evaluator_ = context.createSetEvaluator(this, lambdaTuple, this.iTuple, noEmptyEvaluation);
            return evaluator_;
        });
        OlapScalarEntity res = evaluator.getValue(this.iTuple);
        return res;
    }

    protected OlapScalarEntity doGetFactsValueWithoutSetEvaluators(GFContext context, OlapTuple lambdaTuple, boolean noEmptyEvaluation) {
        OlapTuple tuple = context.completeLambdaTupleWithIteratedTuple(lambdaTuple, this.iTuple);
        OlapScalarEntity res = this.computeFactsTuple(context, tuple, noEmptyEvaluation);
        return res;
    }

    @Override
    public void onFinally(GFContext context) {
        if (this.evaluators != null) {
            for (GFSetEvaluator evaluator : this.evaluators.values()) {
                evaluator.onFinally();
            }
        }
        super.onFinally(context);
    }
}

