/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator;

import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.scalar.OlapCellMeasureVectorScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheKey;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFCalcMemberEvalNode;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFCalcMemberEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.Serializable;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class GFAbstractTupleEvaluator<EVALUATOR extends GFTupleEvaluator>
extends GFTupleEvaluator<EVALUATOR> {
    public GFAbstractTupleEvaluator(@Nullable EVALUATOR other) {
        super(other);
    }

    @Override
    public OlapScalarEntity getValue(GFContext context, OlapTuple tuple, boolean noEmptyEvaluation) {
        OlapScalarEntity res = this.computeFactsTupleOrCalcMember(context, false, tuple, noEmptyEvaluation);
        return res;
    }

    @Override
    public OlapScalarEntity getFactsValue(GFContext context, OlapTuple miniTuple, boolean noEmptyEvaluation) {
        OlapScalarEntity res = this.computeFactsTuple(context, miniTuple, noEmptyEvaluation);
        return res;
    }

    @Override
    public OlapScalarEntity computeFactsTuple(GFContext context, OlapTuple tuple, boolean noEmptyEvaluation) {
        context.assertWithTupleEvaluation();
        if (tuple.isKO()) {
            return OlapEmptyEntity.INSTANCE;
        }
        GFEvalTuple evalTuple = context.setupEvalTuple(noEmptyEvaluation, false, tuple);
        if (evalTuple.isFilteredOut()) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapCalculatedMember calcMember = evalTuple.getHighestPriorityMember();
        if (calcMember != null) {
            throw new RuntimeException("internal error: unexpected calculated member [" + ONames.uname4Log(calcMember) + "] when evaluating the tuple [" + String.valueOf(tuple) + "]");
        }
        OlapScalarEntity res = this.doComputeFactsTuple(context, (GFFactsEvalTuple)evalTuple);
        return res;
    }

    @Override
    public OlapScalarEntity getValueForNonEmpty(GFContext context, OlapTuple tuple) {
        OlapScalarEntity value = this.getValue(context, tuple, true);
        return !value.isMdxNull() ? OlapNumericEntity.ONE_AS_LONG : OlapEmptyEntity.INSTANCE;
    }

    protected OlapScalarEntity computeFactsTupleOrCalcMember(GFContext context, boolean fromAxis, OlapTuple tuple, boolean noEmptyEvaluation) {
        context.assertWithTupleEvaluation();
        if (tuple.isKO()) {
            return OlapEmptyEntity.INSTANCE;
        }
        GFEvalTuple evalTuple = context.setupEvalTuple(noEmptyEvaluation, fromAxis, tuple);
        if (evalTuple.isFilteredOut()) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (evalTuple.getHighestPriorityMember() != null) {
            OlapScalarEntity res = this.doComputeCalcMemberTuple(context, (GFCalcMemberEvalTuple)evalTuple);
            return res;
        }
        OlapScalarEntity res = this.doComputeFactsTuple(context, (GFFactsEvalTuple)evalTuple);
        return res;
    }

    protected OlapScalarEntity doComputeCalcMemberTuple(GFContext context, GFCalcMemberEvalTuple evalTuple) {
        OlapScalarEntity res = evalTuple.isMeasureVector() ? this.doComputeCalcMemberTupleWithMeasureVector(context, evalTuple) : this.computeCalcTuple(context, evalTuple);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapScalarEntity doComputeCalcMemberTupleWithMeasureVector(GFContext context, GFCalcMemberEvalTuple evalTuple) {
        GFCalcMemberEvalTuple[] unrolledEvalTuples = evalTuple.unrollForMeasureVector(context);
        OlapScalarEntity[] entities = new OlapScalarEntity[unrolledEvalTuples.length];
        for (int ii = 0; ii < unrolledEvalTuples.length; ++ii) {
            GFCalcMemberEvalTuple unrolledEvalTuple = unrolledEvalTuples[ii];
            context.pushCellMeasureVectorPos(ii);
            try {
                OlapScalarEntity res;
                entities[ii] = res = this.computeCalcTuple(context, unrolledEvalTuple);
                continue;
            }
            finally {
                context.popCellMeasureVectorPos();
            }
        }
        return new OlapCellMeasureVectorScalarEntity(entities);
    }

    @Override
    public OlapScalarEntity computeCalcTuple(GFContext context, GFCalcMemberEvalTuple evalTuple) {
        OlapCalculatedMember calcMember = evalTuple.getHighestPriorityMember();
        if (calcMember == null) {
            throw new RuntimeException("internal error: inconsistent calc. member evaluation [" + String.valueOf(evalTuple) + "]");
        }
        OlapScalarEntity value = GFCalcMemberEvalNode.evaluate(context, this, evalTuple);
        return value;
    }

    private OlapScalarEntity doComputeFactsTuple(GFContext context, GFFactsEvalTuple evalTuple) {
        OlapScalarEntity res = evalTuple.isCacheEnabled() ? this.computeFactsTuple(context, evalTuple, () -> this.computeFactsTupleFromFacts(context, evalTuple)) : this.computeFactsTupleFromFacts(context, evalTuple);
        context.setupContextForMeasure(evalTuple);
        return res;
    }

    @Override
    public OlapScalarEntity computeCalcTupleFromStatementCache(GFContext context, GFCalcTupleCacheKey tupleKey, Supplier<OlapScalarEntity> supplier) {
        if (this.cells != null) {
            OlapScalarEntity value = this.cells.computeCalcTupleFromStatementCache(context, tupleKey, supplier);
            return value;
        }
        OlapScalarEntity value = supplier.get();
        return value;
    }

    @Override
    public OlapScalarEntity computeFactsTuple(GFContext context, GFFactsEvalTuple evalTuple, Supplier<OlapScalarEntity> supplier) {
        OlapScalarEntity res = supplier.get();
        return res;
    }

    private OlapScalarEntity computeFactsTupleFromFacts(GFContext context, GFFactsEvalTuple evalTuple) {
        OlapMdxStatementExecutionContext sContext;
        OlapResSlicer slicer;
        OlapMeasureMember measure;
        OlapAggregationType atype;
        GFEvalTupleVisibility visibility = evalTuple.getVisibility();
        if ((visibility == GFEvalTupleVisibility.DYNAMIC || visibility == GFEvalTupleVisibility.DYNAMIC_SLICER) && (atype = (measure = evalTuple.getMeasure()).getHierarchyAggregationType()).isRollupHierarchyRequired() && !atype.isMultiTupleSupported() && (slicer = (sContext = context.getStatementExecutionContext()).getSlicer()) != null && slicer.isSet()) {
            throw new OlapEvaluationException(context, OlapErrorCode.SLICER_AGGREGATE_TYPE_NOT_SUPPORTED, new Serializable[]{atype.getFriendlyName()});
        }
        OlapScalarEntity val = context.computeFactsTupleFromFacts(evalTuple);
        return val;
    }
}

