/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tuple;

import crazydev.iccube.cluster.shared.schema.S_FactMemberDefIndices;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapRegularTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleBuilder;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.lambda.IOlapLambdaProcessingEnabled;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFFactsEvalTuple
extends GFEvalTuple
implements S_FactTupleDef,
IOlapLambdaProcessingEnabled<GFFactsEvalTuple> {
    private final OlapMemberOrigin measureOrigin;
    private final OlapMeasureMember measure;
    private final int hash;

    public GFFactsEvalTuple(GFEvalTupleBuilder builderDEBUG, GFEvalTupleVisibility visibility, OlapMemberOrigin rawTupleOrigin, OlapMemberOrigin[] rawTupleOrigins, OlapTuple rawTuple, OlapMemberOrigin measureOrigin, OlapMeasureMember measure, OlapTupleDimensionality allMembersDimensionality, List<OlapMemberOrigin> allMembersOrigins, List<OlapMember> allMembers, @Nullable OlapTupleDimensionality overwrittenHierarchies, @Nullable List<S_RequestSubCubeRef> subCubes, @Nullable S_VisualTotalsDef visualTotals) {
        super(builderDEBUG, visibility, rawTupleOrigin, rawTupleOrigins, rawTuple, allMembersDimensionality, allMembersOrigins, allMembers, overwrittenHierarchies, subCubes, visualTotals);
        if (measure == null) {
            throw new RuntimeException("internal error: inconsistent tuple " + String.valueOf(rawTuple) + "evaluation");
        }
        this.measureOrigin = measureOrigin;
        this.measure = measure;
        this.hash = this.hashCode_();
    }

    @Override
    public GFFactsEvalTuple forkForParallelLambdaProcessing() {
        return this;
    }

    @Override
    public boolean isInvalid() {
        return this.rawTuple.isInvalid();
    }

    public OlapTupleDimensionality getTupleDimensionality() {
        return this.allMembersDimensionality;
    }

    @Override
    public S_TupleDimensionality getClusterTupleDimensionality() {
        return this.allMembersDimensionality;
    }

    @Override
    public void forEach(S_FactMemberDefIndices indices) {
        int size = this.allMembers.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapMember member = (OlapMember)this.allMembers.get(ii);
            member.forEach(indices);
        }
    }

    @Override
    public boolean isMeasure() {
        return false;
    }

    @Override
    public boolean isCacheEnabled() {
        return !this.isMeasureVector();
    }

    public boolean isMeasureVector() {
        return this.measure.isMeasureVector();
    }

    public OlapMeasureMember getMeasure() {
        return this.measure;
    }

    @Override
    protected OlapTupleDimensionality createDimensionality(OlapMemberOrigin origin) {
        int count = this.countMember(origin);
        if (count == 0) {
            return OlapTupleDimensionalityFactory.createForBlankTuple();
        }
        int size = this.allMembersOrigins.size();
        if (count == 1) {
            for (int ii = 0; ii < size; ++ii) {
                if (origin != this.allMembersOrigins.get(ii)) continue;
                OlapMember member = (OlapMember)this.allMembers.get(ii);
                return member.getTupleDimensionality();
            }
            if (origin == this.measureOrigin) {
                return this.measure.getTupleDimensionality();
            }
            throw new RuntimeException("internal error: inconsistent dimensionality setup");
        }
        OlapBitSet set = new OlapBitSet();
        for (int ii = 0; ii < size; ++ii) {
            if (origin != this.allMembersOrigins.get(ii)) continue;
            OlapMember member = (OlapMember)this.allMembers.get(ii);
            set.set(member.getTupleDimensionalityIndex());
        }
        if (origin == this.measureOrigin) {
            set.set(this.measure.getTupleDimensionalityIndex());
        }
        return new OlapTupleDimensionality(set);
    }

    @Override
    protected int countMember(OlapMemberOrigin origin) {
        int count = 0;
        int size = this.allMembersOrigins.size();
        for (int ii = 0; ii < size; ++ii) {
            if (this.allMembersOrigins.get(ii) != origin) continue;
            ++count;
        }
        if (this.measureOrigin == origin) {
            ++count;
        }
        return count;
    }

    public void touchCategories() {
        int count = this.allMembers.size();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember member = (OlapMember)this.allMembers.get(ii);
            member.touch();
        }
    }

    @Override
    public int getMemberCount() {
        return this.allMembers.size();
    }

    @Override
    public OlapMember getMember(int idx) {
        return (OlapMember)this.allMembers.get(idx);
    }

    public GFFactsEvalTuple addRollupMember(GFContext context, OlapMember member) {
        if (member.isMeasure()) {
            throw new RuntimeException("internal error: inconsistent measures rollup support [" + ONames.uname4Log(member) + "]");
        }
        ArrayList<OlapMemberOrigin> allMembersOriginsN = new ArrayList<OlapMemberOrigin>(this.allMembersOrigins);
        ArrayList<OlapMember> allMembersN = new ArrayList<OlapMember>(this.allMembers);
        allMembersOriginsN.add(OlapMemberOrigin.ROLLUP);
        allMembersN.add(member);
        OlapTupleDimensionalityCache cache = context.getTupleDimensionalityCache();
        OlapTupleDimensionality allMembersDimensionalityN = cache.getOrCreateUnion(this.allMembersDimensionality, member.getTupleDimensionality());
        return new GFFactsEvalTuple(this.builderDEBUG, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple, this.measureOrigin, this.measure, allMembersDimensionalityN, allMembersOriginsN, allMembersN, this.overwrittenHierarchies, this.subCubes, this.visualTotals);
    }

    public GFFactsEvalTuple replaceMemberForRollup(int index, OlapMember member) {
        OlapHierarchy hierarchy2;
        if (member.isMeasure()) {
            throw new RuntimeException("internal error: inconsistent measures rollup support [" + ONames.uname4Log(member) + "]");
        }
        ArrayList<OlapMemberOrigin> allMembersOriginsN = new ArrayList<OlapMemberOrigin>(this.allMembersOrigins);
        ArrayList<OlapMember> allMembersN = new ArrayList<OlapMember>(this.allMembers);
        OlapHierarchy hierarchy1 = member.getHierarchy();
        if (hierarchy1 != (hierarchy2 = ((OlapMember)this.allMembers.get(index)).getHierarchy())) {
            throw new RuntimeException("internal error: inconsistent rollup usage [" + index + "][" + member.getNameX() + "][" + hierarchy1.getNameX() + "][" + hierarchy2.getNameX() + "]");
        }
        allMembersOriginsN.set(index, OlapMemberOrigin.ROLLUP);
        allMembersN.set(index, member);
        return new GFFactsEvalTuple(this.builderDEBUG, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple, this.measureOrigin, this.measure, this.allMembersDimensionality, allMembersOriginsN, allMembersN, this.overwrittenHierarchies, this.subCubes, this.visualTotals);
    }

    public GFFactsEvalTuple replaceMemberForSetEvaluation(OlapMember member, OlapMember allMemberForFacts) {
        if (member.equals(allMemberForFacts)) {
            return this;
        }
        if (member.isMeasure()) {
            throw new RuntimeException("internal error: inconsistent set-evaluation support [" + ONames.uname4Log(member) + "]");
        }
        int pos = this.getMemberPos(member);
        if (pos == -1) {
            return this;
        }
        ArrayList<OlapMember> allMembersN = new ArrayList<OlapMember>(this.allMembers);
        allMembersN.set(pos, allMemberForFacts);
        return new GFFactsEvalTuple(this.builderDEBUG, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple, this.measureOrigin, this.measure, this.allMembersDimensionality, this.allMembersOrigins, allMembersN, this.overwrittenHierarchies, this.subCubes, this.visualTotals);
    }

    public GFFactsEvalTuple replaceIteratedTupleForSetEvaluation(GFContext context, OlapTuple lambdaTuple, OlapTuple iTuple) {
        int ii;
        ArrayList<OlapMember> allMembersN = new ArrayList<OlapMember>();
        OlapTuple lambdaTupleI = context.completeLambdaTupleWithIteratedTuple(lambdaTuple, iTuple);
        for (ii = 0; ii < lambdaTupleI.getMemberCount(); ++ii) {
            allMembersN.add(lambdaTupleI.getMember(ii));
        }
        for (ii = 0; ii < this.allMembers.size(); ++ii) {
            OlapMember tMember = (OlapMember)this.allMembers.get(ii);
            OlapHierarchy tHierarchy = tMember.getHierarchy();
            if (lambdaTupleI.getTupleDimensionality().isIn(tHierarchy)) continue;
            allMembersN.add(tMember);
        }
        return new GFFactsEvalTuple(this.builderDEBUG, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, this.rawTuple, this.measureOrigin, this.measure, this.allMembersDimensionality, this.allMembersOrigins, allMembersN, this.overwrittenHierarchies, this.subCubes, this.visualTotals);
    }

    public String asStringForDebugger(OlapNameContext nameContext) {
        return OlapRegularTuple.toMdxString(this.allMembers, nameContext, true, 512);
    }

    public String asStringForDrillthrough(OlapNameContext nameContext) {
        return OlapRegularTuple.toMdxString(this.allMembers, nameContext, true, 512);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GFFactsEvalTuple evalTuple = (GFFactsEvalTuple)o;
        if (this.visibility != evalTuple.visibility) {
            return false;
        }
        if (!this.measure.equals(evalTuple.measure)) {
            return false;
        }
        if (!this.allMembersDimensionality.equals(evalTuple.allMembersDimensionality)) {
            return false;
        }
        if (!this.allMembersOrigins.equals(evalTuple.allMembersOrigins)) {
            return false;
        }
        if (!this.allMembers.equals(evalTuple.allMembers)) {
            return false;
        }
        if (this.overwrittenHierarchies != null ? !this.overwrittenHierarchies.equals(evalTuple.overwrittenHierarchies) : evalTuple.overwrittenHierarchies != null) {
            return false;
        }
        if (this.subCubes != null ? !this.subCubes.equals(evalTuple.subCubes) : evalTuple.subCubes != null) {
            return false;
        }
        return this.visualTotals != null ? this.visualTotals.equals(evalTuple.visualTotals) : evalTuple.visualTotals == null;
    }

    private int hashCode_() {
        int result = this.visibility.hashCode();
        result = 31 * result + this.measure.hashCode();
        result = 31 * result + this.allMembersDimensionality.hashCode();
        result = 31 * result + this.allMembersOrigins.hashCode();
        result = 31 * result + this.allMembers.hashCode();
        result = 31 * result + (this.overwrittenHierarchies != null ? this.overwrittenHierarchies.hashCode() : 0);
        result = 31 * result + (this.subCubes != null ? this.subCubes.hashCode() : 0);
        result = 31 * result + (this.visualTotals != null ? this.visualTotals.hashCode() : 0);
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    protected void toStringX(StringBuilder sb) {
        sb.append(",").append(ONames.name4Log(this.measure));
    }
}

