/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tuple;

import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleBuilder;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GFEvalTuple {
    protected final GFEvalTupleBuilder builderDEBUG;
    protected final GFEvalTupleVisibility visibility;
    protected final OlapMemberOrigin rawTupleOrigin;
    protected final OlapMemberOrigin[] rawTupleOrigins;
    protected final OlapTuple rawTuple;
    protected final OlapTupleDimensionality allMembersDimensionality;
    protected final List<OlapMemberOrigin> allMembersOrigins;
    protected final List<OlapMember> allMembers;
    @Nullable
    protected final OlapTupleDimensionality overwrittenHierarchies;
    @Nullable
    protected final List<S_RequestSubCubeRef> subCubes;
    @Nullable
    protected final S_VisualTotalsDef visualTotals;
    @Nullable
    protected OlapTupleDimensionality axisDimensionality;

    public GFEvalTuple(GFEvalTupleBuilder builderDEBUG, GFEvalTupleVisibility visibility, OlapMemberOrigin rawTupleOrigin, OlapMemberOrigin[] rawTupleOrigins, OlapTuple rawTuple, OlapTupleDimensionality allMembersDimensionality, List<OlapMemberOrigin> allMembersOrigins, List<OlapMember> allMembers, @Nullable OlapTupleDimensionality overwrittenHierarchies, @Nullable List<S_RequestSubCubeRef> subCubes, @Nullable S_VisualTotalsDef visualTotals) {
        this.builderDEBUG = builderDEBUG;
        this.visibility = visibility;
        this.rawTupleOrigin = rawTupleOrigin;
        this.rawTupleOrigins = rawTupleOrigins;
        this.rawTuple = rawTuple;
        this.allMembersDimensionality = allMembersDimensionality;
        this.allMembersOrigins = allMembersOrigins;
        this.allMembers = allMembers;
        this.overwrittenHierarchies = overwrittenHierarchies;
        this.subCubes = subCubes;
        this.visualTotals = visualTotals;
    }

    public abstract boolean isCacheEnabled();

    public boolean isFilteredOut() {
        return false;
    }

    public boolean isFromAxis() {
        return this.rawTupleOrigin == OlapMemberOrigin.AXIS;
    }

    public OlapTupleDimensionality getAllMembersDimensionality() {
        return this.allMembersDimensionality;
    }

    public List<OlapMember> getAllMembers() {
        return this.allMembers;
    }

    public OlapTupleDimensionality getAxisTupleDimensionality() {
        if (this.axisDimensionality == null) {
            this.axisDimensionality = this.createDimensionality(OlapMemberOrigin.AXIS);
        }
        return this.axisDimensionality;
    }

    protected OlapTupleDimensionality createDimensionality(OlapMemberOrigin origin) {
        int count = this.countMember(origin);
        if (count == 0) {
            return OlapTupleDimensionalityFactory.createForBlankTuple();
        }
        int size = this.allMembersOrigins.size();
        if (count == 1) {
            for (int ii = 0; ii < size; ++ii) {
                if (origin != this.allMembersOrigins.get(ii)) continue;
                OlapMember member = this.allMembers.get(ii);
                return member.getTupleDimensionality();
            }
            throw new RuntimeException("internal error: inconsistent dimensionality setup");
        }
        OlapBitSet set = new OlapBitSet();
        for (int ii = 0; ii < size; ++ii) {
            if (origin != this.allMembersOrigins.get(ii)) continue;
            OlapMember member = this.allMembers.get(ii);
            set.set(member.getTupleDimensionalityIndex());
        }
        return new OlapTupleDimensionality(set);
    }

    protected int countMember(OlapMemberOrigin origin) {
        int count = 0;
        int size = this.allMembersOrigins.size();
        for (int ii = 0; ii < size; ++ii) {
            if (this.allMembersOrigins.get(ii) != origin) continue;
            ++count;
        }
        return count;
    }

    public GFEvalTupleVisibility getVisibility() {
        return this.visibility;
    }

    public OlapTuple getRawTuple() {
        return this.rawTuple;
    }

    public int getMemberCount() {
        return this.allMembers.size();
    }

    public OlapMember getMember(int pos) {
        return this.allMembers.get(pos);
    }

    public OlapMemberOrigin getMemberOrigin(int pos) {
        return this.allMembersOrigins.get(pos);
    }

    @Nullable
    public OlapCalculatedMember getHighestPriorityMember() {
        return null;
    }

    @Nullable
    public OlapTupleDimensionality getOverwrittenHierarchies() {
        return this.overwrittenHierarchies;
    }

    @Nullable
    public List<S_RequestSubCubeRef> getSubCubes() {
        return this.subCubes;
    }

    @Nullable
    public S_VisualTotalsDef getVisualTotals() {
        return this.visualTotals;
    }

    public int getMemberPos(OlapHierarchy hierarchy) {
        int size = this.allMembers.size();
        for (int idx = 0; idx < size; ++idx) {
            OlapMember member = this.allMembers.get(idx);
            if (!member.getHierarchy().equals(hierarchy)) continue;
            return idx;
        }
        return -1;
    }

    public int getMemberPos(OlapMember member) {
        int size = this.allMembers.size();
        for (int idx = 0; idx < size; ++idx) {
            OlapMember member_ = this.allMembers.get(idx);
            if (!member.equals(member_)) continue;
            return idx;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int membersCount = this.allMembers.size();
        for (int idx = 0; idx < membersCount; ++idx) {
            OlapMember member = this.allMembers.get(idx);
            if (sb.length() > 1) {
                sb.append(",");
            }
            if (member.isAll()) {
                sb.append(member.getHierarchy().getNameX());
                sb.append(".");
            }
            sb.append(member.getNameX());
        }
        this.toStringX(sb);
        sb.append(")");
        return sb.toString();
    }

    protected void toStringX(StringBuilder sb) {
    }

    public List<OlapMember> getContextMembers(@Nullable OlapMemberFilter filter, OlapHierarchy hierarchy) {
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        ArrayList<OlapMemberOrigin> origins = new ArrayList<OlapMemberOrigin>();
        boolean hasSlicer = false;
        boolean hasAxis = false;
        for (int i = 0; i < this.allMembers.size(); ++i) {
            OlapMember member = this.allMembers.get(i);
            OlapMemberOrigin memberOrigin = this.allMembersOrigins.get(i);
            List<OlapMember> members_ = member.getMembersList(hierarchy);
            for (OlapMember member_ : members_) {
                if (filter != null && !filter.isAccepting(member_)) continue;
                members.add(member_);
                origins.add(memberOrigin);
                hasAxis |= memberOrigin == OlapMemberOrigin.AXIS;
                hasSlicer |= memberOrigin == OlapMemberOrigin.SUBSELECT;
            }
        }
        if (hasAxis && hasSlicer) {
            return this.filterOut(members, origins);
        }
        return members;
    }

    @NotNull
    private List<OlapMember> filterOut(List<OlapMember> members, List<OlapMemberOrigin> origins) {
        ArrayList<Object> axis = new ArrayList<Object>();
        ArrayList<Object> subSelect = new ArrayList<Object>();
        for (int i = 0; i < members.size(); ++i) {
            OlapMember member = members.get(i);
            OlapMemberOrigin origin = origins.get(i);
            if (origin == OlapMemberOrigin.AXIS) {
                axis.add(member);
                continue;
            }
            if (origin != OlapMemberOrigin.SUBSELECT) continue;
            subSelect.add(member);
        }
        HashSet subselectMembersToKeep = new HashSet();
        for (Object axisMember : axis) {
            subSelect.stream().filter(((OlapMember)axisMember)::isAncestor).forEach(subselectMembersToKeep::add);
        }
        HashSet axisMembersToRemove = new HashSet();
        for (OlapMember slicerMember : subselectMembersToKeep) {
            axis.stream().filter(t -> t.isAncestor(slicerMember)).forEach(axisMembersToRemove::add);
        }
        if (axisMembersToRemove.isEmpty() && subselectMembersToKeep.size() == axis.size()) {
            return members;
        }
        ArrayList<OlapMember> nmembers = new ArrayList<OlapMember>();
        for (int i = 0; i < members.size(); ++i) {
            OlapMember member = members.get(i);
            OlapMemberOrigin origin = origins.get(i);
            if (origin == OlapMemberOrigin.AXIS && axisMembersToRemove.contains(member) || origin == OlapMemberOrigin.SUBSELECT && !subselectMembersToKeep.contains(member)) continue;
            nmembers.add(member);
        }
        return nmembers;
    }
}

