/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.tuple;

import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleBuilder;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class GFCalcMemberEvalTuple
extends GFEvalTuple {
    @Nullable
    protected final OlapMeasureMember measure;
    private final OlapMemberOrigin highestPriorityMemberOrigin;
    private final OlapCalculatedMember highestPriorityMember;
    private int hash;

    public GFCalcMemberEvalTuple(GFEvalTupleBuilder builderDEBUG, GFEvalTupleVisibility visibility, OlapMemberOrigin rawTupleOrigin, OlapMemberOrigin[] rawTupleOrigins, OlapTuple rawTuple, OlapMemberOrigin highestPriorityMemberOrigin, OlapCalculatedMember highestPriorityMember, @Nullable OlapMeasureMember measure, OlapTupleDimensionality allMembersDimensionality, List<OlapMemberOrigin> allMembersOrigins, List<OlapMember> allMembers, @Nullable OlapTupleDimensionality overwrittenHierarchies, @Nullable List<S_RequestSubCubeRef> subCubes, @Nullable S_VisualTotalsDef visualTotals) {
        super(builderDEBUG, visibility, rawTupleOrigin, rawTupleOrigins, rawTuple, allMembersDimensionality, allMembersOrigins, allMembers, overwrittenHierarchies, subCubes, visualTotals);
        this.highestPriorityMemberOrigin = highestPriorityMemberOrigin;
        this.highestPriorityMember = highestPriorityMember;
        this.measure = measure;
    }

    @Override
    public boolean isCacheEnabled() {
        return !this.isMeasureVector();
    }

    public boolean isMeasureVector() {
        return this.measure != null && this.measure.isMeasureVector();
    }

    @Override
    @Nullable
    public OlapCalculatedMember getHighestPriorityMember() {
        return this.highestPriorityMember;
    }

    public GFCalcMemberEvalTuple[] unrollForMeasureVector(GFContext context) {
        if (!this.isMeasureVector()) {
            return new GFCalcMemberEvalTuple[]{this};
        }
        int rawTupleMeasurePos = -1;
        int count = this.rawTuple.getMemberCount();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember member = this.rawTuple.getMember(ii);
            if (!(member instanceof OlapMeasureMember)) continue;
            rawTupleMeasurePos = ii;
            break;
        }
        if (rawTupleMeasurePos == -1) {
            throw new RuntimeException("internal error: inconsistent measure-vector calc. member [" + String.valueOf(this.rawTuple) + "]");
        }
        int allMembersMeasurePos = -1;
        int count2 = this.allMembers.size();
        for (int ii = 0; ii < count2; ++ii) {
            OlapMember member = (OlapMember)this.allMembers.get(ii);
            if (!(member instanceof OlapMeasureMember)) continue;
            allMembersMeasurePos = ii;
            break;
        }
        OlapTuple[] unrolledRawTuples = this.rawTuple.unroll(context);
        GFCalcMemberEvalTuple[] unrolled = new GFCalcMemberEvalTuple[unrolledRawTuples.length];
        for (int ii = 0; ii < unrolled.length; ++ii) {
            OlapTuple unrolledRawTuple = unrolledRawTuples[ii];
            OlapMeasureMember unrolledMeasure = (OlapMeasureMember)unrolledRawTuple.getMember(rawTupleMeasurePos);
            List<OlapMember> unrolledAllMembers = this.replaceAllMembers(allMembersMeasurePos, unrolledMeasure);
            unrolled[ii] = new GFCalcMemberEvalTuple(this.builderDEBUG, this.visibility, this.rawTupleOrigin, this.rawTupleOrigins, unrolledRawTuple, this.highestPriorityMemberOrigin, this.highestPriorityMember, unrolledMeasure, this.allMembersDimensionality, this.allMembersOrigins, unrolledAllMembers, this.overwrittenHierarchies, this.subCubes, this.visualTotals);
        }
        return unrolled;
    }

    private List<OlapMember> replaceAllMembers(int pos, OlapMember member) {
        if (pos == -1) {
            return this.allMembers;
        }
        ArrayList<OlapMember> allMembersN = new ArrayList<OlapMember>();
        int size = this.allMembers.size();
        for (int ii = 0; ii < size; ++ii) {
            if (ii == pos) {
                allMembersN.add(member);
                continue;
            }
            allMembersN.add((OlapMember)this.allMembers.get(ii));
        }
        return allMembersN;
    }

    public List<OlapMemberOrigin> completeTupleOrigins_(GFContext context) {
        return this.allMembersOrigins;
    }

    public OlapTuple completeTuple_(GFContext context) {
        OlapTuple tuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, context.getTupleDimensionalityCache(), null, null, this.allMembers);
        return tuple;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GFCalcMemberEvalTuple evalTuple = (GFCalcMemberEvalTuple)o;
        if (this.visibility != evalTuple.visibility) {
            return false;
        }
        if (this.highestPriorityMemberOrigin != evalTuple.highestPriorityMemberOrigin) {
            return false;
        }
        if (!this.highestPriorityMember.equals(evalTuple.highestPriorityMember)) {
            return false;
        }
        if (this.measure != null ? !this.measure.equals(evalTuple.measure) : evalTuple.measure != null) {
            return false;
        }
        if (!this.allMembersDimensionality.equals(evalTuple.allMembersDimensionality)) {
            return false;
        }
        if (!this.allMembersOrigins.equals(evalTuple.allMembersOrigins)) {
            return false;
        }
        if (!this.allMembers.equals(evalTuple.allMembers)) {
            return false;
        }
        if (this.overwrittenHierarchies != null ? !this.overwrittenHierarchies.equals(evalTuple.overwrittenHierarchies) : evalTuple.overwrittenHierarchies != null) {
            return false;
        }
        if (this.subCubes != null ? !this.subCubes.equals(evalTuple.subCubes) : evalTuple.subCubes != null) {
            return false;
        }
        return this.visualTotals != null ? this.visualTotals.equals(evalTuple.visualTotals) : evalTuple.visualTotals == null;
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = this.visibility.hashCode();
            result = 31 * result + (this.highestPriorityMemberOrigin != null ? this.highestPriorityMemberOrigin.hashCode() : 0);
            result = 31 * result + (this.highestPriorityMember != null ? this.highestPriorityMember.hashCode() : 0);
            result = 31 * result + (this.measure != null ? this.measure.hashCode() : 0);
            result = 31 * result + this.allMembersDimensionality.hashCode();
            result = 31 * result + this.allMembersOrigins.hashCode();
            result = 31 * result + this.allMembers.hashCode();
            result = 31 * result + (this.overwrittenHierarchies != null ? this.overwrittenHierarchies.hashCode() : 0);
            result = 31 * result + (this.subCubes != null ? this.subCubes.hashCode() : 0);
            this.hash = result = 31 * result + (this.visualTotals != null ? this.visualTotals.hashCode() : 0);
        }
        return result;
    }

    public void forEachCalcOrMeasureOnOrder(Predicate<OlapMember> visitor) {
        if (this.highestPriorityMember != null && !visitor.test(this.highestPriorityMember)) {
            return;
        }
        List other = this.allMembers.stream().filter(m -> m.isCalculated() || m.isMeasure() && !OlapMember.equal(m, this.highestPriorityMember)).sorted((o1, o2) -> {
            if (o1.isCalculated() && !o2.isCalculated()) {
                return 1;
            }
            if (!o1.isCalculated() && o2.isCalculated()) {
                return -1;
            }
            if (!o1.isCalculated() && !o2.isCalculated()) {
                return 0;
            }
            OlapCalculatedMember oc1 = (OlapCalculatedMember)o1;
            OlapCalculatedMember oc2 = (OlapCalculatedMember)o2;
            OlapCalculatedMember priorityMember = OlapCalculatedMember.highestPriorityMember(null, oc1, oc2);
            return OlapMember.equal(priorityMember, oc1) ? 1 : -1;
        }).collect(Collectors.toList());
        for (OlapMember olapMember : other) {
            if (visitor.test(olapMember)) continue;
            return;
        }
    }
}

