/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.operator.unary.OlapUnaryOperator;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFUnaryOperatorNode
extends GFNode {
    private final OlapInstr instr;
    private final OlapUnaryOperator operator;
    private final GFNode operand;

    public GFUnaryOperatorNode(boolean markedForValueEvaluation, OlapInstr instr, OlapUnaryOperator operator, GFNode operand) {
        super(markedForValueEvaluation);
        this.instr = instr;
        this.operator = operator;
        this.operand = operand;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return this.operator.nonEmptyBehavior(context, this.operand);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.operand.getTupleDimensionality();
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.operand.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity value = this.operand.execute(context, evaluator);
        OlapEntity res = this.operator.execute(context, evaluator, value);
        return res;
    }

    @Override
    public String toStringForDebugger() {
        return this.operator.getName().mdx();
    }
}

