/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallbackFactory;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.io.Serializable;
import java.util.function.Consumer;

public class GFTopLikeApplyLambdaNode
extends GFApplyLambdaNode {
    private final int limitArgNb;
    private final GFNode limit;

    public GFTopLikeApplyLambdaNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFApplyLambdaCallbackFactory callbackFactory, GFNode lambda, int setArgNb, GFNode set, int limitArgNb, GFNode limit) {
        super(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args, callbackFactory, lambda, setArgNb, set, -1);
        this.limitArgNb = limitArgNb;
        this.limit = limit;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.limit.forEachNode(consumer);
    }

    public int getEvaluatedCount(GFContext context, GFFunctionArgs args) {
        OlapNumericEntity val = args.toNumeric(context, this.limitArgNb);
        int count = val.intValue();
        if (count < 0) {
            return (Integer)args.onFunctionError(context, this.limitArgNb, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"count", Integer.valueOf(count), ">= 0"});
        }
        return count;
    }

    public double getEvaluatedSum(GFContext context, GFFunctionArgs args) {
        OlapNumericEntity val = args.toNumeric(context, this.limitArgNb);
        double sum = val.doubleValue();
        if (sum < 0.0) {
            return (Double)args.onFunctionError(context, this.limitArgNb, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"sum", Double.valueOf(sum), ">= 0"});
        }
        return sum;
    }

    public double getEvaluatedPercent(GFContext context, GFFunctionArgs args) {
        OlapNumericEntity val = args.toNumeric(context, this.limitArgNb);
        double percent = val.doubleValue();
        if (percent < 0.0) {
            return (Double)args.onFunctionError(context, 1, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"percent", Double.valueOf(percent), "[0..1]"});
        }
        return percent;
    }
}

