/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFStaticCategoryMemberEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFStaticSetEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFScalarTypeErrorHandler;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStatementTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticCategoryTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticSetTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.io.Serializable;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public abstract class GFNode {
    protected final boolean markedForValueEvaluation;

    protected GFNode(boolean markedForValueEvaluation) {
        this.markedForValueEvaluation = markedForValueEvaluation;
    }

    public GFTupleEvaluator getTupleEvaluator(GFContext context) {
        OlapMdxStatementExecutionContext sContext = context.getStatementExecutionContext();
        GFStatementTupleEvaluator statementEvaluator = sContext.getTupleEvaluator();
        if (context instanceof GFStaticSetEvalContext) {
            GFStaticTupleEvaluator staticEvaluator = statementEvaluator.getStaticEvaluator();
            GFStaticSetTupleEvaluator setEvaluator = new GFStaticSetTupleEvaluator(staticEvaluator);
            return setEvaluator;
        }
        if (context instanceof GFStaticCategoryMemberEvalContext) {
            GFStaticTupleEvaluator staticEvaluator = statementEvaluator.getStaticEvaluator();
            GFStaticCategoryTupleEvaluator categoryEvaluator = new GFStaticCategoryTupleEvaluator(staticEvaluator);
            return categoryEvaluator;
        }
        return statementEvaluator;
    }

    public abstract OlapInstrLocationRange getLocationRange();

    public abstract String getMdxForDrillthrough();

    public boolean isMarkedForValueEvaluation() {
        return this.markedForValueEvaluation;
    }

    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehavior.one();
    }

    public boolean isConstrainedEnabled() {
        return true;
    }

    public boolean isMissingArg() {
        return false;
    }

    @Nullable(value="if the dimensionality cannot be determined")
    public abstract @Nullable(value="if the dimensionality cannot be determined") OlapTupleDimensionality getTupleDimensionality();

    public void forEachNode(Consumer<GFNode> consumer) {
        consumer.accept(this);
    }

    public final OlapScalarEntity executeToScalar(GFContext context, GFTupleEvaluator cache, @Nullable GFScalarTypeErrorHandler typeErrorHandler) {
        OlapInstrExecListener listener = context.getInstrExecListener();
        if (listener != null && context.isInstrExecListening()) {
            return this.doExecuteToScalarAndListen(context, cache, typeErrorHandler, listener);
        }
        return this.doExecuteToScalar(context, cache, typeErrorHandler);
    }

    private OlapScalarEntity doExecuteToScalarAndListen(GFContext context, GFTupleEvaluator cache, @Nullable GFScalarTypeErrorHandler typeErrorHandler, OlapInstrExecListener listener) {
        listener.beginNodeExecute(context.isOnDemand(), this);
        try {
            OlapScalarEntity entity = this.doExecuteToScalar(context, cache, typeErrorHandler);
            listener.endNodeExecute(this, entity);
            return entity;
        }
        catch (RuntimeException ex) {
            listener.endNodeExecuteOnError(this, ex);
            throw ex;
        }
    }

    private OlapScalarEntity doExecuteToScalar(GFContext context, GFTupleEvaluator cache, @Nullable GFScalarTypeErrorHandler typeErrorHandler) {
        OlapEntity res = this.doExecute(context, cache);
        if (res.isMdxNull()) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (res instanceof OlapScalarEntity) {
            return (OlapScalarEntity)res;
        }
        if (res.isToValueApplicable(context, cache)) {
            OlapScalarEntity scalar = res.toValue(context, cache);
            return scalar;
        }
        if (typeErrorHandler == null) {
            return (OlapScalarEntity)this.onTypeMismatchError(context, "scalar", res.getFriendlyTypeName());
        }
        return typeErrorHandler.onTypeError(context, res);
    }

    public final OlapEntity execute(GFContext context, GFTupleEvaluator evaluator) {
        OlapInstrExecListener listener = context.getInstrExecListener();
        if (listener != null && context.isInstrExecListening()) {
            return this.doExecuteAndListen(context, evaluator, listener);
        }
        return this.doExecute(context, evaluator);
    }

    private OlapEntity doExecuteAndListen(GFContext context, GFTupleEvaluator evaluator, OlapInstrExecListener listener) {
        listener.beginNodeExecute(context.isOnDemand(), this);
        try {
            OlapEntity entity = this.doExecute(context, evaluator);
            listener.endNodeExecute(this, entity);
            return entity;
        }
        catch (RuntimeException ex) {
            listener.endNodeExecuteOnError(this, ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapEntity doExecute(GFContext context, GFTupleEvaluator evaluator) {
        GFNode prev = context.pushCurrentNode(this);
        try {
            if (context.isConstrained() && this.isConstrainedEnabled()) {
                OlapEntity olapEntity = (OlapEntity)context.onConstrainedViolation();
                return olapEntity;
            }
            context.assertNotCancelling("node-eval");
            OlapEntity res = this.evaluate(context, evaluator);
            if (this.markedForValueEvaluation && !(res instanceof OlapScalarEntity)) {
                OlapScalarEntity value;
                if (res.isMdxNull()) {
                    OlapEmptyEntity olapEmptyEntity = OlapEmptyEntity.INSTANCE;
                    return olapEmptyEntity;
                }
                OlapScalarEntity olapScalarEntity = value = context.toValue(evaluator, res);
                return olapScalarEntity;
            }
            OlapEntity olapEntity = res;
            return olapEntity;
        }
        finally {
            context.popCurrentNode(prev);
        }
    }

    protected abstract OlapEntity evaluate(GFContext var1, GFTupleEvaluator var2);

    public <T> T onExecutionError(IOlapEvaluationExceptionContext context, OlapErrorCode errorCode, Serializable ... params) {
        throw new OlapEvaluationException(context, errorCode, params);
    }

    public <T> T onTypeMismatchError(IOlapEvaluationExceptionContext context, String expectedType, String actualType) {
        throw new OlapEvaluationException(context, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{expectedType, actualType});
    }

    public <T> T onCalcMemberTypeMismatchError(IOlapEvaluationExceptionContext context, OlapCalculatedMember calcMember, OlapEntity entity) {
        throw new OlapEvaluationException(context, OlapErrorCode.CALC_MEMBER_TYPE_MISMATCH, new Serializable[]{calcMember.getUniqueName(context.getNameContext()), entity.getFriendlyTypeName()});
    }

    public <T> T onFunctionArgTypeMismatchError(IOlapEvaluationExceptionContext context, String argName, String expectedType, String actualType) {
        return this.onFunctionArgTypeMismatchError(context, argName, expectedType, actualType, "");
    }

    public <T> T onFunctionArgTypeMismatchError(IOlapEvaluationExceptionContext context, String argName, String expectedType, String actualType, String extra) {
        throw new OlapEvaluationException(context, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{argName, expectedType, actualType, extra});
    }

    public String toStringForDebugger() {
        return this.getClass().getSimpleName();
    }

    public boolean isCrossjoin() {
        return false;
    }
}

