/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallbackFactory;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIterator;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.loggers.OlapLoggers;
import org.jetbrains.annotations.Nullable;

public class GFIteratorApplyLambdaNode
extends GFNode {
    private final OlapFilterProcessingMode mode;
    private final GFApplyLambdaCallbackFactory callbackFactory;
    private final boolean nonEmptyFunction;
    protected final OlapFunctionCallInstr functionCallInstr;
    protected final OlapInstr[] functionCallArgInstrs;
    protected final OlapFunction function;
    protected final GFNode[] args;
    protected final GFNode setN;
    @Nullable
    protected final GFNode lambdaN;
    @Nullable
    private final OlapTupleDimensionality setTupleDimensionality;
    private final int limitFromContext;

    public GFIteratorApplyLambdaNode(OlapFilterProcessingMode mode, GFApplyLambdaCallbackFactory callbackFactory, boolean nonEmptyFunction, boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args, GFNode setN, @Nullable GFNode lambdaN, int limitFromContext) {
        super(markedForValueEvaluation);
        this.mode = mode;
        this.callbackFactory = callbackFactory;
        this.nonEmptyFunction = nonEmptyFunction;
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.args = args;
        this.setN = setN;
        this.lambdaN = lambdaN;
        this.setTupleDimensionality = setN.getTupleDimensionality();
        this.limitFromContext = limitFromContext;
    }

    @Override
    public String toStringForDebugger() {
        return this.functionCallInstr.toStringForDebugger();
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.functionCallInstr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.functionCallInstr.getMdxForDrillthrough();
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.setTupleDimensionality;
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        GFContext contextForked = context.forkForParallelLambdaProcessing();
        GFTupleEvaluationFrame ref = contextForked.pushMiniTupleAsEvaluatedTuple();
        GFFunctionArgs funArgs = new GFFunctionArgs(evaluator, this.functionCallInstr, this.functionCallArgInstrs, this.function, this.args);
        OlapTupleSet<? extends OlapTuple> set = funArgs.toSet(contextForked, 0, true);
        if (set == null) {
            return OlapSetFactory.empty();
        }
        long setFastEstimatedSize = set.fastEstimatedSize();
        int limitFromArgs = funArgs.size() == 3 ? funArgs.toNumeric(contextForked, 2).intValue() : -1;
        int limit = OlapNonScalarEntityFunction.actualLimit(this.limitFromContext, limitFromArgs);
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] %s() actual limit (iterator-evaluation) : %d [context:%d] [args:%d]".formatted(this.function.getName(), limit, this.limitFromContext, limitFromArgs));
        OlapInstrExecListener debugger = contextForked.getInstrExecListener();
        if (debugger != null) {
            debugger.onIterableNode(this);
        }
        GFIterator filtered = new GFIterator(contextForked, evaluator, this, this.mode, this.callbackFactory, this.nonEmptyFunction, this.markedForValueEvaluation, this.functionCallInstr, this.functionCallArgInstrs, this.function, this.args, this.setN, this.lambdaN, funArgs, set, set.getIterator(false), setFastEstimatedSize, limit);
        return OlapSetFactory.instance(filtered);
    }
}

