/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFConditionalNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFIifNode
extends GFConditionalNode {
    private final OlapInstr instr;
    private final GFNode condition;
    private final GFNode then;
    private final GFNode otherwise;

    public GFIifNode(boolean markedForValueEvaluation, OlapInstr instr, GFNode condition, GFNode then, GFNode otherwise) {
        super(markedForValueEvaluation);
        this.instr = instr;
        this.condition = condition;
        this.then = then;
        this.otherwise = otherwise;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.iif(context, this.condition, this.then, this.otherwise);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        OlapTupleDimensionality thenD = this.then.getTupleDimensionality();
        OlapTupleDimensionality otherwiseD = this.otherwise.getTupleDimensionality();
        if (thenD == null || otherwiseD == null) {
            return null;
        }
        if (thenD.equals(otherwiseD)) {
            return thenD;
        }
        return null;
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.condition.forEachNode(consumer);
        this.then.forEachNode(consumer);
        this.otherwise.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        boolean value = this.evalCondition(context, evaluator, this.condition);
        if (value) {
            OlapEntity res = this.then.execute(context, evaluator);
            return res;
        }
        OlapEntity res = this.otherwise.execute(context, evaluator);
        return res;
    }

    @Override
    public String toStringForDebugger() {
        return "IIF";
    }
}

