/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.lambda.OlapFunctionEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class GFFunctionIdentifierNode
extends GFNode {
    private final OlapFunctionIdentifierInstr instr;
    private final String name;

    public GFFunctionIdentifierNode(boolean markedForValueEvaluation, OlapFunctionIdentifierInstr instr, String name) {
        super(false);
        this.instr = instr;
        this.name = name;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return OlapTupleDimensionalityFactory.createForNullEntity();
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapFunction function = context.lookupFunction(this.name);
        if (function == null) {
            return (OlapEntity)this.onExecutionError(context, OlapErrorCode.MDX_FUNCTION_UNRESOLVED, new Serializable[]{this.name});
        }
        return new OlapFunctionEntity(function);
    }

    @Override
    public String toStringForDebugger() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

