/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFSetNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainTupleFilter;
import crazydev.iccube.olap.eval.set.OlapExistingSetInstr;
import java.io.Serializable;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFExistingSetNode
extends GFSetNode {
    private final GFNode set;

    public GFExistingSetNode(boolean markedForValueEvaluation, OlapExistingSetInstr instr, GFNode set) {
        super(markedForValueEvaluation, instr);
        this.set = set;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.set.getTupleDimensionality();
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.set.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity entity = this.set.execute(context, evaluator);
        if (entity.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        if (!entity.isToSetApplicable(context.getPrepareContext())) {
            throw new OlapEvaluationException(context, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"set", entity.getFriendlyTypeName()});
        }
        OlapTupleSet<? extends OlapTuple> asSet = entity.toSet(context.getPrepareContext());
        OlapChainTupleFilter filter = context.createChainTupleFilterForExisting();
        if (filter == null) {
            return asSet;
        }
        OlapIterator<OlapTuple> filtered = OlapIteratorFactory.filter(asSet.getIterator(false), filter.asOlapTupleIteratorFilter());
        return OlapSetFactory.instance(filtered);
    }

    @Override
    public String toStringForDebugger() {
        return "existing {...}";
    }
}

