/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFMathFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import org.jetbrains.annotations.Nullable;

public class GFDivideFunctionCallNode
extends GFMathFunctionCallNode {
    protected final GFNode numerator;
    protected final GFNode denominator;
    @Nullable
    protected final GFNode alternateResult;

    public GFDivideFunctionCallNode(boolean markedForValueEvaluation, OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, GFNode[] args) {
        super(markedForValueEvaluation, functionCallInstr, functionCallArgInstrs, function, args);
        this.numerator = args[0];
        this.denominator = args[1];
        this.alternateResult = args.length == 3 ? args[2] : null;
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.divide(context, this.numerator, this.denominator, this.alternateResult);
    }

    @Override
    protected OlapEntity doEvalX(GFContext context, GFTupleEvaluator cache) {
        OlapScalarEntity denominatorValue = this.toValue(context, cache, this.denominator, 1, true);
        if (denominatorValue.isMdxNull() || GFDivideFunctionCallNode.isZeroValue(denominatorValue)) {
            if (this.alternateResult == null) {
                return this.asEmpty();
            }
            return this.toValue(context, cache, this.alternateResult, 2, false);
        }
        OlapScalarEntity numeratorValue = this.toValue(context, cache, this.numerator, 0, true);
        OlapScalarEntity res = OlapScalarOperators.divide(numeratorValue, denominatorValue);
        return res;
    }

    private OlapScalarEntity toValue(GFContext context, GFTupleEvaluator cache, GFNode instr, int argNb, boolean forceNumeric) {
        OlapEntity entity = instr.execute(context, cache);
        if (entity.isMdxNull()) {
            return this.asEmpty();
        }
        if (entity.isToValueApplicable(context, cache)) {
            OlapScalarEntity scalar = entity.toValue(context, cache);
            if (!forceNumeric || scalar instanceof OlapNumericEntity) {
                return scalar;
            }
        }
        return (OlapScalarEntity)this.onFunctionArgTypeMismatchError(context.getPrepareContext(), String.valueOf(argNb), "scalar", entity.getFriendlyTypeName(), "in DIVIDE function");
    }

    private static boolean isZeroValue(OlapScalarEntity<?> denominatorValue) {
        Object value = denominatorValue.asJavaNativeValue(Double.class);
        return value instanceof Double && (Double)value == 0.0;
    }
}

