/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFBinaryOperatorNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.operator.binary.OlapBinaryOperator;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarMissingOperatorException;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;

public class GFBinaryOperatorAndNode
extends GFBinaryOperatorNode {
    public GFBinaryOperatorAndNode(boolean markedForValueEvaluation, OlapInstr instr, OlapBinaryOperator operator, GFNode left, GFNode right) {
        super(markedForValueEvaluation, instr, operator, left, right);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        OlapEntity leftV = this.left.execute(context, evaluator);
        if (leftV.isMdxNull()) {
            return OlapBooleanEntity.FALSE;
        }
        if (!leftV.isToValueApplicable(context, evaluator)) {
            return this.operator.onOperatorSyntaxError(context, leftV, null);
        }
        OlapScalarEntity leftS = leftV.toValue(context, evaluator);
        if (leftS instanceof OlapStringEntity) {
            return this.operator.onOperatorSyntaxError(context, leftV, null);
        }
        try {
            if (!OlapScalarOperators.isTrue(leftS)) {
                return OlapBooleanEntity.FALSE;
            }
        }
        catch (OlapScalarMissingOperatorException ex) {
            return this.operator.onOperatorSyntaxError(context, leftV, null);
        }
        OlapEntity res = this.doExecuteRight(context, evaluator, leftV);
        return res;
    }

    private OlapEntity doExecuteRight(GFContext context, GFTupleEvaluator cache, OlapEntity lValue) {
        OlapEntity rightV = this.right.execute(context, cache);
        if (rightV.isMdxNull()) {
            return OlapBooleanEntity.FALSE;
        }
        if (!rightV.isToValueApplicable(context, cache)) {
            return this.operator.onOperatorSyntaxError(context, lValue, rightV);
        }
        OlapScalarEntity rightS = rightV.toValue(context, cache);
        if (rightS instanceof OlapStringEntity) {
            return this.operator.onOperatorSyntaxError(context, lValue, rightV);
        }
        if (OlapScalarOperators.isTrue(rightS)) {
            return OlapBooleanEntity.TRUE;
        }
        return OlapBooleanEntity.FALSE;
    }
}

