/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.nodes;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFAxisEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFAxisTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStatementTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.Serializable;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class GFAxisNode
extends GFNode {
    private final OlapAxisInstr instr;
    private final GFNode content;

    public GFAxisNode(boolean markedForValueEvaluation, OlapAxisInstr instr, GFNode content) {
        super(false);
        this.instr = instr;
        this.content = content;
    }

    @Override
    public GFTupleEvaluator getTupleEvaluator(GFContext context) {
        OlapMdxStatementExecutionContext sContext = context.getStatementExecutionContext();
        GFStatementTupleEvaluator tupleEvaluator = sContext.getTupleEvaluator();
        GFAxisTupleEvaluator evaluator = new GFAxisTupleEvaluator(tupleEvaluator);
        return evaluator;
    }

    @Override
    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    @Override
    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.content.getTupleDimensionality();
    }

    @Override
    public void forEachNode(Consumer<GFNode> consumer) {
        super.forEachNode(consumer);
        this.content.forEachNode(consumer);
    }

    @Override
    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        GFAxisEvalContext axisContext = (GFAxisEvalContext)context;
        OlapEntity axis = this.content.execute(axisContext, evaluator);
        if (axis.isMdxNull()) {
            return OlapNullEntity.INSTANCE;
        }
        if (axis.isToSetApplicable(axisContext.getPrepareContext())) {
            OlapTupleSet<? extends OlapTuple> res;
            OlapTupleSet<? extends OlapTuple> asSet = axis.toSet(axisContext.getPrepareContext());
            if (!axisContext.isSubSelect() && asSet.isNeutralElement()) {
                return OlapNullEntity.INSTANCE;
            }
            OlapTupleFilter tupleFilter = axisContext.createDimensionFilterForAxisFiltering();
            if (tupleFilter != null) {
                OlapIterator<OlapTuple> filtered = OlapIteratorFactory.filter(asSet.getIterator(false), tupleFilter.asOlapTupleIteratorFilter());
                res = OlapSetFactory.instance(filtered);
            } else {
                res = asSet;
            }
            if (this.instr.isFromFilterBy()) {
                axisContext.addFilterByInfo(res);
            }
            return res;
        }
        if (axis instanceof OlapDimension) {
            return (OlapEntity)this.onExecutionError(this.createErrorContext(axisContext), OlapErrorCode.FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY, new Serializable[]{ONames.uname4Log((OlapDimension)axis)});
        }
        if (axis instanceof OlapSubCubeEntity && axisContext.isSubSelect()) {
            return axis;
        }
        return (OlapEntity)this.onTypeMismatchError(this.createErrorContext(axisContext), "axis(" + String.valueOf(this.instr.getName()) + ")", axis.getFriendlyTypeName());
    }

    private IOlapEvaluationExceptionContext createErrorContext(GFContext context) {
        return this.instr.createErrorContext(context.getLocale(), context.getNameContext(), context.isDimensionalityCheck());
    }

    @Override
    public String toStringForDebugger() {
        return this.instr.toStringForDebugger();
    }
}

