/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel;

import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaExecutor;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaExecutionContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationController;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;

public class GFParallelLambdaTask
implements IOlapFactsCellEvaluationTask {
    private final GFParallelLambdaContext context;
    private final List<OlapTuple> tuples;
    private final int tuplesOrdinalOffset;

    public GFParallelLambdaTask(GFParallelLambdaContext context, List<OlapTuple> tuples, int tuplesOrdinalOffset) {
        this.context = context;
        this.tuples = tuples;
        this.tuplesOrdinalOffset = tuplesOrdinalOffset;
        if (OlapLoggers.MDX_EVALUATION_LAMBDA.isTraceEnabled()) {
            OlapLoggers.MDX_EVALUATION_LAMBDA.trace((Object)("[mdx] parallel lambda processing batch ( " + tuplesOrdinalOffset + " )"));
        }
    }

    @Override
    public void execute() {
        OlapMdxStatementExecutionContext statementContext = this.context.getStatementExecutionContext();
        OlapSetEvaluationController controller = statementContext.getSetEvaluationController();
        try {
            controller.initForParallelLambdaProcessing(this.context.fork());
            this.safeExecute();
        }
        finally {
            controller.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeExecute() {
        GFParallelLambdaExecutionContext eContext = this.context.borrowExecutionContext();
        try {
            GFApplyLambdaExecutor executor = eContext.getExecutor();
            GFContext context = eContext.getContext();
            GFLambdaTupleEvaluator lambdaTupleEvaluator = eContext.getLambdaTupleEvaluator();
            GFMiniTupleEvaluator miniTupleEvaluator = eContext.getMiniTupleEvaluator();
            OlapTupleSet set = eContext.getSet();
            GFApplyLambdaCallback callback = eContext.getCallback();
            OlapListTupleSet<OlapTuple> batch = OlapSetFactory.instance(this.tuples);
            executor.executeBatch(context, lambdaTupleEvaluator, miniTupleEvaluator, set, batch, this.tuplesOrdinalOffset, callback);
            if (OlapLoggers.MDX_EVALUATION_LAMBDA.isTraceEnabled()) {
                OlapLoggers.MDX_EVALUATION_LAMBDA.trace((Object)("[mdx] parallel lambda processing completed batch ( " + this.tuplesOrdinalOffset + " )"));
            }
        }
        finally {
            this.context.returnExecutionContext(eContext);
        }
    }
}

