/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel;

import crazydev.common.olap.OlapConfiguration;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaExecutor;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaExecutionContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;

public class GFParallelLambdaContext {
    private final OlapStack<OlapSetDeclaration> fork;
    private final GFContext context;
    private final GFTupleEvaluator evaluator;
    private final GFApplyLambdaExecutor executor;
    private final GFApplyLambdaNode lambdaNode;
    private final OlapTupleSet set;
    private final long fastEstimatedSize;
    private final long batchSize;
    private final GFApplyLambdaCallback callback;
    private final OlapStack<GFParallelLambdaExecutionContext> eContexts = new OlapStack();

    public GFParallelLambdaContext(OlapStack<OlapSetDeclaration> fork, GFContext context, GFTupleEvaluator evaluator, GFApplyLambdaExecutor executor, int threadCount, GFApplyLambdaNode lambdaNode, OlapTupleSet set, long fastEstimatedSize, GFApplyLambdaCallback callback) {
        this.fork = fork;
        this.context = context;
        this.evaluator = evaluator;
        this.executor = executor;
        this.lambdaNode = lambdaNode;
        this.set = set;
        this.fastEstimatedSize = fastEstimatedSize;
        this.batchSize = threadCount > 0 && fastEstimatedSize > 0L ? Math.min((long)OlapConfiguration.PARALLEL_LAMBDA_BATCH_SIZE, fastEstimatedSize / (long)threadCount) : (long)OlapConfiguration.PARALLEL_LAMBDA_BATCH_SIZE;
        this.callback = callback;
    }

    public boolean isCancelling() {
        return this.context.isCancelling();
    }

    public IOlapEvaluationExceptionContext getErrorContext() {
        return this.context;
    }

    public OlapMdxStatementExecutionContext getStatementExecutionContext() {
        return this.context.getStatementExecutionContext();
    }

    public String getFunctionName() {
        return this.lambdaNode.getFunctionName();
    }

    public int stopIterationOrdinal() {
        return this.callback.stopIterationOrdinal();
    }

    public OlapTupleSet getIteratedSet() {
        return this.set;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public OlapStack<OlapSetDeclaration> fork() {
        return this.fork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFParallelLambdaExecutionContext borrowExecutionContext() {
        OlapStack<GFParallelLambdaExecutionContext> olapStack = this.eContexts;
        synchronized (olapStack) {
            if (!this.eContexts.isEmpty()) {
                GFParallelLambdaExecutionContext eContext = this.eContexts.pop();
                return eContext;
            }
        }
        if (!this.evaluator.isAcceptingParallelLambdaProcessing()) {
            throw new RuntimeException("internal error: inconsistent parallel lambda evaluation [" + String.valueOf(this.evaluator.getClass()) + "]");
        }
        GFContext contextF = this.context.forkForParallelLambdaProcessing();
        GFLambdaTupleEvaluator lambdaTupleEvaluatorF = this.lambdaNode.createLambdaTupleEvaluator(contextF, this.evaluator, this.fastEstimatedSize);
        GFMiniTupleEvaluator miniTupleEvaluatorF = new GFMiniTupleEvaluator(this.lambdaNode, lambdaTupleEvaluatorF);
        GFParallelLambdaExecutionContext eContext = new GFParallelLambdaExecutionContext(contextF, this.executor, lambdaTupleEvaluatorF, miniTupleEvaluatorF, this.set, this.callback);
        eContext.onRootCalcMemberEvalStarted();
        eContext.onBeforeSetBatchEvaluation();
        return eContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnExecutionContext(GFParallelLambdaExecutionContext eContext) {
        OlapStack<GFParallelLambdaExecutionContext> olapStack = this.eContexts;
        synchronized (olapStack) {
            this.eContexts.push(eContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetEvaluationFinally() {
        OlapStack<GFParallelLambdaExecutionContext> olapStack = this.eContexts;
        synchronized (olapStack) {
            while (!this.eContexts.isEmpty()) {
                GFParallelLambdaExecutionContext eContext = this.eContexts.pop();
                eContext.onRootCalcMemberEvalCompleted();
            }
        }
    }
}

