/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.lambda.OlapFunctionEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFFunctionCallExecutor;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFUnresolvedFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapUnresolvedFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunctionParameter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.io.Serializable;

public class GFUnresolvedFunctionCallExecutor
extends GFFunctionCallExecutor {
    public GFUnresolvedFunctionCallExecutor(GFFunctionArgs funArgs, GFUnresolvedFunctionCallNode functionCallNode) {
        super(funArgs, functionCallNode);
    }

    @Override
    protected OlapEntity doExecute(GFContext context, OlapFunction function, GFFunctionArgs args) {
        OlapUnresolvedFunction unresolvedFunction = (OlapUnresolvedFunction)function;
        OlapDeclaredFunctionParameter param = unresolvedFunction.getParam();
        OlapEntity argument = args.lookupDeclaredFunctionArgument(context, param.getIndex());
        if (argument instanceof OlapFunctionEntity) {
            OlapFunctionEntity entity = (OlapFunctionEntity)argument;
            OlapFunction function_ = entity.getFunction();
            OlapEntity res = function_ instanceof OlapDeclaredFunction ? this.doExecuteForDeclaredFunction(context, unresolvedFunction, (OlapDeclaredFunction)function_, args) : this.doExecuteForRegularFunction(context, unresolvedFunction, function_, args);
            return res;
        }
        String declaredFunctionName = unresolvedFunction.getName();
        String declaredFunctionArgument = param.getName();
        if (argument == null) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, function.getName(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"missing function argument : " + declaredFunctionName + "." + declaredFunctionArgument});
        }
        throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, function.getName(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"type mismatch [" + argument.getFriendlyTypeName() + "] for function argument : " + declaredFunctionName + "." + declaredFunctionArgument});
    }

    private OlapEntity doExecuteForRegularFunction(GFContext context, OlapUnresolvedFunction unresolvedFunction, OlapFunction function, GFFunctionArgs args) {
        OlapEntity res = function.evalForCluster(context, args);
        return res;
    }

    private OlapEntity doExecuteForDeclaredFunction(GFContext context, OlapUnresolvedFunction unresolvedFunction, OlapDeclaredFunction function, GFFunctionArgs args) {
        GFTupleEvaluator evaluator = args.getTupleEvaluator();
        String declaredFunctionName = function.getName();
        OlapEntity[] declaredFunctionArgs = args.size() > 0 ? this.executeDeclaredFunctionArgs(context, evaluator, args) : null;
        Object ref = context.pushFunctionCallFrame(declaredFunctionName, declaredFunctionArgs);
        OlapInstr body = function.getBody();
        IOlapPrepareContext pContext = context.getPrepareContext();
        OlapPreparedInstr pBody = body.prepare(pContext);
        GFNode nBody = pBody.buildGFTree(new GFNodeBuildContext(context.hasInstrExecListener()), false);
        OlapEntity res = nBody.execute(context, evaluator);
        context.popFunctionCallFrame(ref);
        return res;
    }

    protected OlapEntity[] executeDeclaredFunctionArgs(GFContext context, GFTupleEvaluator cache, GFFunctionArgs args) {
        OlapFunction function = this.funArgs.getFunction();
        OlapFunctionArgs argsInfo = function.getArgsInfo();
        if (args.size() < argsInfo.from || argsInfo.to < args.size()) {
            throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)context, function.getName(), OlapErrorCode.FUNCTION_UNEXPECTED_ARGUMENT_COUNT_X, new Serializable[]{function.getName(), Integer.valueOf(args.size()), argsInfo.toString()});
        }
        OlapEntity[] params = new OlapEntity[args.size()];
        for (int idx = 0; idx < params.length; ++idx) {
            OlapEntity olapEntity = this.executeDeclaredFunctionArg(context, this.funArgs, idx);
            params[idx] = olapEntity.asConstant();
        }
        return params;
    }

    protected OlapEntity executeDeclaredFunctionArg(GFContext context, GFFunctionArgs funArgs, int idx) {
        OlapFunction function = funArgs.getFunction();
        GFTupleEvaluator evaluator = funArgs.getTupleEvaluator();
        GFNode arg = funArgs.getArg(idx);
        OlapEntity argEntity = arg.execute(context, evaluator);
        OlapFunctionArgs argsInfo = function.getArgsInfo();
        OlapFunctionArgumentType type = argsInfo.getType(idx);
        if (type != null && type.isValuable()) {
            if (argEntity.isMdxNull()) {
                return OlapEmptyEntity.INSTANCE;
            }
            if (argEntity.isToValueApplicable(context, evaluator)) {
                OlapScalarEntity argValue = argEntity.toValue(context, evaluator);
                return argValue;
            }
            return (OlapEntity)funArgs.onFunctionError(context, idx, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(idx + 1), "value", argEntity.getFriendlyTypeName(), ""});
        }
        return argEntity;
    }
}

