/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.scalar.OlapCellMeasureVectorScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFCellPropertiesHelper;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFCellTask;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellsTupleEvaluator;
import crazydev.iccube.olap.eval.facts.cells.processor.OlapCellMeasureVectorsPositions;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellErrorValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellScalarValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.context.OlapCellEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFRegularCellTask
extends GFCellTask {
    public GFRegularCellTask(OlapCellsEvaluationContext cellsEvalContext, IOlapEvalResult result, IOlapCombinationIterator<OlapTuple> cells, int rowIndex, OlapEvalResultSi cellSi, OlapTuple[] cellTuples) {
        super(cellsEvalContext, result, cells, rowIndex, cellSi, cellTuples);
    }

    @Override
    protected void doExecute(OlapCellEvaluationContext evalContext, int rowIndex, OlapTuple cellTuple, OlapEvalResultSi cellSi, OlapTuple[] cellTuples, IOlapEvalResult result) {
        OlapInstrExecListener instrExecListener = evalContext.getInstrExecListener();
        if (instrExecListener != null) {
            instrExecListener.beginCellValueEval(cellTuple, cellSi, cellTuples);
        }
        GFCellsTupleEvaluator cellsTupleEvaluator = this.cellsEvalContext.getTupleEvaluator();
        GFCellEvalContext context = new GFCellEvalContext(cellsTupleEvaluator, evalContext, cellTuple);
        GFCellTupleEvaluator tupleEvaluator = new GFCellTupleEvaluator(context);
        CellValue cellValue = this.computeCellValue(context, tupleEvaluator, cellTuple);
        OlapSelectStatementExecutionContext sContext = evalContext.getStatementContext();
        boolean hasMeasureVectorEvaluation = sContext.getMeasureVectorsPositions() != null;
        OlapEvalResultCellValue cellRes = hasMeasureVectorEvaluation ? this.computeCellPropertiesForMeasureVectors(context, rowIndex, cellTuple, cellSi, cellTuples, cellValue, result) : this.computeCellProperties(context, rowIndex, cellTuple, cellSi, cellTuples, cellValue, result, -1);
        if (instrExecListener != null) {
            instrExecListener.endCellValueEval(cellSi, cellRes);
        }
    }

    private CellValue computeCellValue(GFCellEvalContext context, GFCellTupleEvaluator evaluator, OlapTuple cellTuple) {
        CellValue value = new CellValue();
        try {
            value.cellValueAsScalar = evaluator.getCellValue(context, cellTuple);
        }
        catch (OlapException err) {
            value.cellValueAsError = err;
        }
        return value;
    }

    @Nullable
    private OlapEvalResultCellValue computeCellPropertiesForMeasureVectors(GFCellEvalContext context, int rowIndex, OlapTuple cellTuple, OlapEvalResultSi cellSi, OlapTuple[] cellTuples, CellValue cellValue, IOlapEvalResult result) {
        OlapScalarEntity cellValueAsScalar = cellValue.cellValueAsScalar;
        OlapException cellValueAsError = cellValue.cellValueAsError;
        if (cellValueAsScalar == null && cellValueAsError == null) {
            throw new RuntimeException("internal error: inconsistent cell evaluation");
        }
        boolean isMeasureVector = cellTuple.isMeasureVector();
        if (isMeasureVector) {
            if (cellValueAsError != null) {
                OlapCellMeasureVectorsPositions measureVectorPositions = context.getStatementExecutionContext().getMeasureVectorsPositions();
                for (int ii = 0; ii < cellTuple.getMeasureVectorSize(); ++ii) {
                    OlapCellMeasureVectorsPositions.CellInfo cellInfo = measureVectorPositions.adjustCellInformation(cellSi, cellTuples, cellTuple, ii);
                    this.computeCellProperties(context, rowIndex, cellInfo.cellTuple, cellInfo.cellSi, cellInfo.cellTuples, new CellValue(cellValueAsError), result, ii);
                }
                return null;
            }
            if (cellValueAsScalar.isMdxNull()) {
                OlapCellMeasureVectorsPositions measureVectorPositions = context.getStatementExecutionContext().getMeasureVectorsPositions();
                for (int ii = 0; ii < cellTuple.getMeasureVectorSize(); ++ii) {
                    OlapCellMeasureVectorsPositions.CellInfo cellInfo = measureVectorPositions.adjustCellInformation(cellSi, cellTuples, cellTuple, ii);
                    this.computeCellProperties(context, rowIndex, cellInfo.cellTuple, cellInfo.cellSi, cellInfo.cellTuples, new CellValue(OlapEmptyEntity.INSTANCE), result, ii);
                }
                return null;
            }
            if (cellValueAsScalar instanceof OlapCellMeasureVectorScalarEntity) {
                OlapCellMeasureVectorsPositions measureVectorPositions = context.getStatementExecutionContext().getMeasureVectorsPositions();
                OlapScalarEntity[] cellValueAsScalars = ((OlapCellMeasureVectorScalarEntity)cellValueAsScalar).getEntities();
                OlapException[] cellValueAsErrors = ((OlapCellMeasureVectorScalarEntity)cellValueAsScalar).getErrors();
                for (int ii = 0; ii < cellValueAsScalars.length; ++ii) {
                    OlapScalarEntity cellValueAsScalar_ = cellValueAsScalars[ii];
                    OlapException cellValueAsError_ = cellValueAsErrors != null ? cellValueAsErrors[ii] : null;
                    OlapCellMeasureVectorsPositions.CellInfo cellInfo = measureVectorPositions.adjustCellInformation(cellSi, cellTuples, cellTuple, ii);
                    this.computeCellProperties(context, rowIndex, cellInfo.cellTuple, cellInfo.cellSi, cellInfo.cellTuples, new CellValue(cellValueAsScalar_, cellValueAsError_), result, ii);
                }
                return null;
            }
            throw new RuntimeException("internal error: inconsistent measures-vector cell evaluation");
        }
        if (!cellTuple.isKO()) {
            OlapCellMeasureVectorsPositions measureVectorPositions = context.getStatementExecutionContext().getMeasureVectorsPositions();
            OlapCellMeasureVectorsPositions.CellInfo cellInfo = measureVectorPositions.adjustCellInformation(cellSi, cellTuples, cellTuple, 0);
            this.computeCellProperties(context, rowIndex, cellInfo.cellTuple, cellInfo.cellSi, cellInfo.cellTuples, new CellValue(cellValueAsScalar, cellValueAsError), result, -1);
            return null;
        }
        this.computeCellProperties(context, rowIndex, cellTuple, cellSi, cellTuples, new CellValue(cellValueAsScalar, cellValueAsError), result, -1);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapEvalResultCellValue computeCellProperties(GFCellEvalContext context, int rowIndex, OlapTuple cellTuple, OlapEvalResultSi cellSi, OlapTuple[] cellTuples, CellValue cellValue, IOlapEvalResult result, int measureVectorPos) {
        context.setupCellMeasureVectorPos(measureVectorPos);
        try {
            OlapEvalResultCellValue cellRes = this.evalCellProperties(context, cellSi, cellValue);
            OlapSelectStatementExecutionContext sContext = context.getStatementContext();
            result.addCellValue(sContext.asExceptionContext(), rowIndex, cellTuples, cellRes);
            OlapEvalResultCellValue olapEvalResultCellValue = cellRes;
            return olapEvalResultCellValue;
        }
        finally {
            context.setupCellMeasureVectorPos(-1);
        }
    }

    private OlapEvalResultCellValue evalCellProperties(GFCellEvalContext context, OlapEvalResultSi cellSi, CellValue cellValue) {
        OlapScalarEntity cellValueAsScalar = cellValue.cellValueAsScalar;
        OlapException cellValueAsError = cellValue.cellValueAsError;
        if (cellValueAsScalar == null && cellValueAsError == null) {
            throw new RuntimeException("internal error: inconsistent cell evaluation");
        }
        OlapEvalResultCellValue resCellValue = cellValueAsScalar != null ? new OlapEvalResultCellScalarValue(cellSi, cellValueAsScalar) : new OlapEvalResultCellErrorValue(cellSi, cellValueAsError);
        if (context.isNonEmptyActive()) {
            if (!resCellValue.isEmpty()) {
                this.evalCellProperties(context, resCellValue);
            }
        } else {
            this.evalCellProperties(context, resCellValue);
        }
        OlapMember cellMeasure = context.getCellMeasure();
        resCellValue.attachCellMeasure(cellMeasure);
        return resCellValue;
    }

    private void evalCellProperties(GFCellEvalContext context, OlapEvalResultCellValue cellValue) {
        List<OlapCellProperty> requestedCellProperties = context.getRequestedCellProperties();
        GFCellPropertyEvalContext propEvalContext = new GFCellPropertyEvalContext(context, requestedCellProperties, cellValue);
        OlapScalarEntity[] pValues = GFCellPropertiesHelper.evalRequestedCellProperties(propEvalContext);
        cellValue.setCellPropertyValues(pValues);
    }

    private static class CellValue {
        @Nullable
        OlapScalarEntity cellValueAsScalar;
        @Nullable
        OlapException cellValueAsError;

        CellValue() {
        }

        CellValue(OlapScalarEntity cellValueAsScalar) {
            this.cellValueAsScalar = cellValueAsScalar;
        }

        CellValue(OlapException cellValueAsError) {
            this.cellValueAsError = cellValueAsError;
        }

        CellValue(@Nullable OlapScalarEntity cellValueAsScalar, @Nullable OlapException cellValueAsError) {
            this.cellValueAsScalar = cellValueAsScalar;
            this.cellValueAsError = cellValueAsError;
        }
    }
}

