/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.OlapCountBoundedSortedVTuples;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFDrilldownBoundedFunctionCallExecutor;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFDrilldownLevelBoundedFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFTupleNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.mdx.set.OlapDrilldownLevelBoundedFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFDrilldownLevelBoundedFunctionCallExecutor
extends GFDrilldownBoundedFunctionCallExecutor {
    public GFDrilldownLevelBoundedFunctionCallExecutor(GFFunctionArgs funArgs, GFDrilldownLevelBoundedFunctionCallNode functionCallNode) {
        super(funArgs, functionCallNode);
    }

    @Override
    public OlapNonScalarEntity execute(GFContext context, GFTupleEvaluator evaluator) {
        OlapLevel level;
        OlapTupleSet<? extends OlapTuple> set = this.funArgs.toSet(context, 0, true);
        if (set == null) {
            return OlapSetFactory.empty();
        }
        int count = this.funArgs.toInteger(context, 1);
        if (count < 0) {
            return (OlapNonScalarEntity)this.funArgs.onFunctionError(context, 1, OlapErrorCode.OUT_OF_RANGE, new Serializable[]{"count", Integer.valueOf(count), ">= 0"});
        }
        if (!this.funArgs.isMissingArg(2)) {
            level = this.funArgs.toLevel(context, 2);
        } else {
            OlapDrilldownLevelBoundedFunction function = (OlapDrilldownLevelBoundedFunction)this.funArgs.getFunction();
            level = function.getLowestLevel(context, set, 0);
        }
        return this.doEvalForLevel(context, evaluator, set, level, count);
    }

    protected OlapNonScalarEntity doEvalForLevel(GFContext context, GFTupleEvaluator cache, OlapTupleSet<? extends OlapTuple> set, @Nullable OlapLevel level, int count) {
        OlapTuple tuple;
        if (level == null) {
            return set;
        }
        int drilldownHierarchyPos = -1;
        ArrayList<OlapTuple> drilldown = new ArrayList<OlapTuple>();
        OlapIterator tuples = set.getIterator(false);
        tuples.reset();
        while ((tuple = (OlapTuple)tuples.next()) != null) {
            if (drilldownHierarchyPos == -1 && (drilldownHierarchyPos = tuple.getMemberPos(level.getHierarchy())) == -1) {
                OlapNameContext nameContext = context.getNameContext();
                return (OlapNonScalarEntity)this.funArgs.onFunctionError(context, OlapErrorCode.DRILLDOWN_INVALID_HIERARCHY, new Serializable[]{level.getHierarchy().getUniqueName(nameContext)});
            }
            drilldown.add(tuple);
            OlapMember member = tuple.getMember(drilldownHierarchyPos);
            if (!member.getLevel().equals(level)) continue;
            OlapTupleSet<? extends OlapTuple> children = tuple.drilldown(context.getMemberFilter(), context.getTupleFilter(), drilldownHierarchyPos);
            this.addChildren(context, cache, drilldown, children, count);
        }
        return drilldown.isEmpty() ? set : OlapSetFactory.instance(drilldown);
    }

    protected void addChildren(GFContext context, GFTupleEvaluator cache, List<OlapTuple> drilldown, OlapTupleSet<? extends OlapTuple> children, int count) {
        GFNode lambda = !this.funArgs.isMissingArg(3) ? this.funArgs.getArg(3) : new GFTupleNode(true, null, OlapBlankTuple.INSTANCE);
        OlapDrilldownLevelBoundedFunction function = (OlapDrilldownLevelBoundedFunction)this.funArgs.getFunction();
        OlapCountBoundedSortedVTuples boundedChildren = function.createSortedTuples(context, context.getSchema().getLocalizedStringComparator(), count);
        this.applyLambda(context, cache, lambda, children, boundedChildren, count);
        boundedChildren.addTo(drilldown);
    }
}

