/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutors;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFOrdinalCellTaskFactory;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFRegularCellTaskFactory;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.select.OlapSelectInstr;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class GFCellsExecutor {
    protected final OlapSelectStatementExecutionContext sContext;
    protected final OlapSelectInstr selectInstr;
    protected final boolean isEvalOrdinalOnly;
    protected final boolean[] hasNonEmpties;
    protected final boolean isNonEmptyActive;
    protected final OlapTupleSet<OlapTuple>[] axesAsSets;
    protected final List<OlapCellProperty> requestedCellProperties;
    private final OlapMdxExecutionPermit permit;

    public GFCellsExecutor(OlapSelectStatementExecutionContext sContext, OlapMdxExecutionPermit permit, OlapSelectInstr selectInstr, boolean isEvalOrdinalOnly, boolean[] hasNonEmpties, OlapTupleSet<OlapTuple>[] axesAsSets, List<OlapCellProperty> requestedCellProperties) {
        this.sContext = sContext;
        this.permit = permit;
        this.selectInstr = selectInstr;
        this.isEvalOrdinalOnly = isEvalOrdinalOnly;
        this.hasNonEmpties = hasNonEmpties;
        this.isNonEmptyActive = this.hasNonEmpty();
        this.axesAsSets = axesAsSets;
        this.requestedCellProperties = requestedCellProperties;
    }

    public void evaluateCellValues(IOlapEvalResult result) {
        IOlapCombinationIterator<OlapTuple> cellTuples = this.setupCellsIterator(result);
        this.sContext.onAxisEnd();
        if (cellTuples != null) {
            this.sContext.onCellsEvaluationStarted(this.isEvalOrdinalOnly);
            try {
                this.evaluateCellValues(cellTuples, result);
            }
            finally {
                this.sContext.onCellsEvaluationDone();
            }
        }
    }

    @Nullable
    protected abstract IOlapCombinationIterator<OlapTuple> setupCellsIterator(IOlapEvalResult var1);

    private void evaluateCellValues(IOlapCombinationIterator<OlapTuple> cells, IOlapEvalResult result) {
        boolean forTidyEvaluation = result.isForTidyEvaluation();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] evaluate cell values [tidy:" + forTidyEvaluation + "]"));
        OlapCellsEvaluationContext cellsEvalContext = new OlapCellsEvaluationContext(this.sContext, this.isNonEmptyActive, this.requestedCellProperties);
        OlapMdxExecutors executors = this.sContext.getMdxExecutors();
        if (this.isEvalOrdinalOnly && !this.isNonEmptyActive) {
            executors.executeForCellsProcessing(this.sContext, new GFOrdinalCellTaskFactory(cellsEvalContext, result, cells), this.permit);
        } else {
            executors.executeForCellsProcessing(this.sContext, new GFRegularCellTaskFactory(cellsEvalContext, result, cells), this.permit);
        }
        result.onEvaluateCellValuesDone(cells.isTidyMaxRowCountReached(), cells.rowIndex());
        cellsEvalContext.onCellValuesProcessed();
    }

    private boolean hasNonEmpty() {
        for (boolean hasNonEmpty : this.hasNonEmpties) {
            if (!hasNonEmpty) continue;
            return true;
        }
        return false;
    }
}

