/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.result.IOlapEvalResult;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.context.OlapCellEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;

public abstract class GFCellTask
implements IOlapFactsCellEvaluationTask {
    protected final OlapCellsEvaluationContext cellsEvalContext;
    private final IOlapEvalResult result;
    private final IOlapCombinationIterator<OlapTuple> cells;
    private final int rowIndex;
    private final OlapEvalResultSi cellSi;
    private final OlapTuple[] cellTuples;

    public GFCellTask(OlapCellsEvaluationContext cellsEvalContext, IOlapEvalResult result, IOlapCombinationIterator<OlapTuple> cells, int rowIndex, OlapEvalResultSi cellSi, OlapTuple[] cellTuples) {
        this.cellsEvalContext = cellsEvalContext;
        this.result = result;
        this.cells = cells;
        this.rowIndex = rowIndex;
        this.cellSi = cellSi;
        this.cellTuples = cellTuples;
    }

    @Override
    public void execute() {
        OlapSelectStatementExecutionContext sContext = this.cellsEvalContext.getStatementContext();
        OlapCellEvaluationContext evalContext = new OlapCellEvaluationContext(this.cellsEvalContext);
        OlapTuple cellTuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)sContext, sContext.getTupleDimensionalityCache(), evalContext.getTupleFilter(), this.cellTuples);
        evalContext.setCellTupleForDrillthrough(cellTuple);
        evalContext.onNewCell(this.cellTuples, this.cellSi.getSi());
        this.doExecute(evalContext, this.rowIndex, cellTuple, this.cellSi, this.cellTuples, this.result);
    }

    protected abstract void doExecute(OlapCellEvaluationContext var1, int var2, OlapTuple var3, OlapEvalResultSi var4, OlapTuple[] var5, IOlapEvalResult var6);
}

