/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFApplyLambdaListener;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.set.parallel.GFParallelLambdaTaskFactory;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import crazydev.iccube.olap.eval.select.context.OlapMdxExtraExecutionLock;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationController;
import crazydev.iccube.olap.eval.select.parallel.OlapExecutableTaskExecutorX;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import org.jetbrains.annotations.Nullable;

public class GFApplyLambdaExecutor {
    private final GFFunctionArgs funArgs;
    private final GFApplyLambdaNode lambdaNode;

    public GFApplyLambdaExecutor(GFFunctionArgs funArgs, GFApplyLambdaNode lambdaNode) {
        this.funArgs = funArgs;
        this.lambdaNode = lambdaNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapEntity execute(GFContext context, GFTupleEvaluator evaluator) {
        GFTupleEvaluationFrame ref = context.pushMiniTupleAsEvaluatedTuple();
        try {
            GFApplyLambdaCallback callback = this.lambdaNode.createCallback(context);
            OlapTupleSet set = this.lambdaNode.getEvaluatedSet(context, this.funArgs);
            long fastEstimatedSize = set.fastEstimatedSize();
            callback.init(context, set, this.lambdaNode, this.funArgs);
            try {
                OlapEntity res;
                OlapMdxStatementExecutionContext sContext;
                OlapMdxExtraExecutionLock mtEvalLock;
                boolean processed = false;
                OlapLambdaCallbackMode mode = callback.processingMode();
                if (OlapLambdaCallbackMode.PARALLEL == mode && context.isLambdaParallelProcessingEnabled(evaluator) && (mtEvalLock = (sContext = context.getStatementExecutionContext()).acquireMdxExtraExecutionLock()) != null) {
                    try {
                        this.doExecuteMT(context, evaluator, mtEvalLock, set, fastEstimatedSize, callback);
                        processed = true;
                    }
                    finally {
                        sContext.releaseMdxExtraExecutionLock(mtEvalLock);
                    }
                }
                if (!processed) {
                    this.doExecuteST(context, evaluator, set, fastEstimatedSize, callback);
                }
                OlapEntity olapEntity = res = callback.onDone(context);
                callback.onFinally(context);
                return olapEntity;
            }
            catch (Throwable throwable) {
                callback.onFinally(context);
                throw throwable;
            }
        }
        finally {
            context.popMiniTupleAsEvaluatedTuple(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteMT(GFContext context, GFTupleEvaluator evaluator, OlapMdxExtraExecutionLock mtEvalLock, OlapTupleSet set, long fastEstimatedSize, GFApplyLambdaCallback callback) {
        callback.initX(context, true, set, this.lambdaNode, this.funArgs);
        OlapExecutableTaskExecutorX executor = mtEvalLock.getParallelExecutorX();
        OlapMdxStatementExecutionContext statementContext = context.getStatementExecutionContext();
        OlapSetEvaluationController controller = statementContext.getSetEvaluationController();
        OlapStack<OlapSetDeclaration> fork = controller.forkForParallelLambdaProcessing();
        GFParallelLambdaContext pContext = new GFParallelLambdaContext(fork, context, evaluator, this, executor.threadCount(), this.lambdaNode, set, fastEstimatedSize, callback);
        try {
            context.getStatementExecutionContext().onParallelLambdaStarted();
            GFParallelLambdaTaskFactory tasks = new GFParallelLambdaTaskFactory(pContext);
            executor.parallelExecution(tasks);
        }
        finally {
            context.getStatementExecutionContext().onParallelLambdaCompleted();
            pContext.onSetEvaluationFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteST(GFContext context, GFTupleEvaluator evaluator, OlapTupleSet set, long setSize, GFApplyLambdaCallback callback) {
        callback.initX(context, false, set, this.lambdaNode, this.funArgs);
        GFLambdaTupleEvaluator lambdaTupleEvaluator = this.lambdaNode.createLambdaTupleEvaluator(context, evaluator, setSize);
        try {
            GFMiniTupleEvaluator miniTupleEvaluator = new GFMiniTupleEvaluator(this.lambdaNode, lambdaTupleEvaluator);
            miniTupleEvaluator.onRootCalcMemberEvalStarted(context);
            try {
                callback.onBeforeSetBatchEvaluation(context, lambdaTupleEvaluator, miniTupleEvaluator);
                this.executeBatch(context, lambdaTupleEvaluator, miniTupleEvaluator, set, null, -1, callback);
            }
            finally {
                miniTupleEvaluator.onRootCalcMemberEvalCompleted(context);
            }
        }
        finally {
            lambdaTupleEvaluator.onFinally(context);
        }
    }

    public void executeBatch(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, OlapTupleSet set, @Nullable OlapTupleSet batch, int batchOrdinalOffset, GFApplyLambdaCallback callback) {
        GFApplyLambdaListener listener = GFApplyLambdaListener.setup(context);
        if (listener != null) {
            this.doExecuteAndListen(listener, context, lambdaTupleEvaluator, miniTupleEvaluator, set, callback);
        } else {
            this.doExecute(null, context, lambdaTupleEvaluator, miniTupleEvaluator, set, batch, batchOrdinalOffset, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteAndListen(GFApplyLambdaListener listener, GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, OlapTupleSet set, GFApplyLambdaCallback callback) {
        listener.listener.beginFactSetIteration();
        try {
            this.doExecute(listener, context, lambdaTupleEvaluator, miniTupleEvaluator, set, null, -1, callback);
        }
        finally {
            listener.listener.endFactSetIteration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(@Nullable GFApplyLambdaListener listener, GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, OlapTupleSet set, @Nullable OlapTupleSet batch, int batchOrdinalOffset, GFApplyLambdaCallback callback) {
        try {
            OlapTuple iTuple;
            OlapIterator iter;
            int iTupleOrdinal;
            int n = iTupleOrdinal = batch != null ? batchOrdinalOffset : 1;
            if (this.canStopIteration(callback, iTupleOrdinal)) {
                return;
            }
            OlapIterator olapIterator = iter = batch != null ? batch.getIterator(false) : set.getIterator(false);
            if (this.canStopIteration(callback, iTupleOrdinal)) {
                return;
            }
            iter.reset();
            while ((iTuple = (OlapTuple)iter.next()) != null) {
                context.assertNotCancelling("execute-lambda");
                if (this.canStopIteration(callback, iTupleOrdinal)) {
                    break;
                }
                if (listener != null) {
                    this.evalLambdaAndListen(listener, context, lambdaTupleEvaluator, miniTupleEvaluator, set.asIdentifiableSet(), callback, iTupleOrdinal, iTuple);
                } else {
                    this.evalLambda(context, lambdaTupleEvaluator, miniTupleEvaluator, null, set.asIdentifiableSet(), callback, iTupleOrdinal, iTuple);
                }
                ++iTupleOrdinal;
            }
        }
        finally {
            if (listener != null) {
                context.setInstrExecListening(true);
            }
        }
    }

    private boolean canStopIteration(GFApplyLambdaCallback callback, int iTupleOrdinal) {
        int stopIterationOrdinal = callback.stopIterationOrdinal();
        return stopIterationOrdinal != -1 && iTupleOrdinal > stopIterationOrdinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalLambdaAndListen(GFApplyLambdaListener listener, GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, @Nullable OlapTupleSet set, GFApplyLambdaCallback callback, int iTupleOrdinal, OlapTuple iTuple) {
        if (listener.countForInstrListening++ >= 25 && context.isInstrExecListening()) {
            context.stopInstrExecListening(null);
        }
        listener.listener.onFactSetTupleIteration(null);
        if (context.isInstrExecListening()) {
            listener.listener.beginFactSetTupleIteration(null, iTuple);
        }
        OlapEntity[] res = new OlapEntity[1];
        try {
            this.evalLambda(context, lambdaTupleEvaluator, miniTupleEvaluator, res, set, callback, iTupleOrdinal, iTuple);
        }
        finally {
            listener.listener.onFactSetTupleIterationCompleted(null);
            if (context.isInstrExecListening()) {
                listener.listener.endFactSetTupleIteration(null, iTuple, res[0]);
            }
        }
    }

    private void evalLambda(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator, @Nullable OlapEntity[] res, @Nullable OlapTupleSet set, GFApplyLambdaCallback callback, int iTupleOrdinal, OlapTuple iTuple) {
        lambdaTupleEvaluator.evaluate(context, miniTupleEvaluator, res, set, iTuple, iTupleOrdinal, callback);
    }
}

