/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.executors;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFApplyLambdaNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.lambda.OlapLambdaCallbackMode;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class GFApplyLambdaCallback<NODE extends GFApplyLambdaNode> {
    private final OlapFunctionCallInstr functionCallInstr;
    private final OlapInstr[] functionCallArgInstrs;
    private final OlapFunction function;
    private final String lambdaArgName;

    public GFApplyLambdaCallback(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, String lambdaArgName) {
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.lambdaArgName = lambdaArgName;
    }

    public abstract OlapLambdaCallbackMode processingMode();

    public void init(GFContext context, OlapTupleSet set, NODE lambdaArg, GFFunctionArgs args) {
    }

    public void initX(GFContext context, boolean parallel, OlapTupleSet set, NODE lambdaArg, GFFunctionArgs args) {
    }

    public void onBeforeSetBatchEvaluation(GFContext context, GFLambdaTupleEvaluator lambdaTupleEvaluator, GFMiniTupleEvaluator miniTupleEvaluator) {
    }

    public int stopIterationOrdinal() {
        return -1;
    }

    public void onBeforeLambdaExecution(GFContext context, OlapTuple iTuple) {
    }

    public void onAfterLambdaExecution(GFContext context) {
    }

    public void onEmptyValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple) {
    }

    public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value) {
    }

    public void onScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapScalarEntity value1, OlapScalarEntity value2) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public void onNonScalarValue(GFContext context, int iTupleOrdinal, OlapTuple iTuple, OlapEntity value) {
        this.onFunctionArgTypeMismatchError(context, "non-scalar", value.getFriendlyTypeName());
    }

    public abstract OlapEntity onDone(GFContext var1);

    public void onFinally(GFContext context) {
    }

    protected <T> T onFunctionArgTypeMismatchError(GFContext context, int argNb, String expectedType, String actualType) {
        return this.onFunctionArgTypeMismatchError(context, argNb, expectedType, actualType, null);
    }

    protected <T> T onFunctionArgTypeMismatchError(GFContext context, int argNb, String expectedType, String actualType, @Nullable String extraInfo) {
        throw new OlapFunctionEvaluationException(this.getErrorContext(context, argNb), this.function.getName(), OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{Integer.valueOf(argNb), expectedType, actualType, extraInfo == null ? "" : extraInfo});
    }

    protected <T> T onFunctionArgTypeMismatchError(GFContext context, String expectedType, String actualType) {
        throw new OlapFunctionEvaluationException(this.getErrorContext(context), this.function.getName(), OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{this.lambdaArgName, expectedType, actualType, null});
    }

    private IOlapEvaluationExceptionContext getErrorContext(GFContext context) {
        return this.functionCallInstr.createErrorContext(context.getLocale(), context.getNameContext(), context.isDimensionalityCheck());
    }

    private IOlapEvaluationExceptionContext getErrorContext(GFContext context, int argNb) {
        if (!this.isMissingArg(argNb)) {
            return this.functionCallArgInstrs[argNb].createErrorContext(context.getLocale(), context.getNameContext(), context.isDimensionalityCheck());
        }
        return this.getErrorContext(context);
    }

    private boolean isMissingArg(int argNb) {
        return argNb < 0 || argNb >= this.functionCallArgInstrs.length || this.functionCallArgInstrs[argNb] == null || this.functionCallArgInstrs[argNb].isMissingFunctionArgument();
    }

    protected int argsSize() {
        return this.functionCallArgInstrs.length;
    }
}

