/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context.impl;

import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheKey;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluatorInitialContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFMiniTupleEvaluationFrame {
    private final Object debug__;
    private final boolean noEmptyEvaluation;
    private final List<OlapMemberOrigin> miniTupleOrigins;
    private final OlapTuple miniTuple;
    @Nullable
    private final OlapMemberOrigin calcMemberOrigin;
    @Nullable
    private final OlapCalculatedMember calcMember;
    private final boolean calcMemberInMiniTuple;
    public boolean computed;

    public GFMiniTupleEvaluationFrame(Object debug__, boolean noEmptyEvaluation, List<OlapMemberOrigin> miniTupleOrigins, OlapTuple miniTuple, @Nullable OlapMemberOrigin calcMemberOrigin, @Nullable OlapCalculatedMember calcMember) {
        this.debug__ = debug__;
        this.noEmptyEvaluation = noEmptyEvaluation;
        this.miniTupleOrigins = miniTupleOrigins;
        this.miniTuple = miniTuple;
        this.calcMemberOrigin = calcMemberOrigin;
        this.calcMember = calcMember;
        boolean calcMemberInTuple = false;
        if (calcMember != null) {
            for (int ii = 0; ii < miniTuple.getMemberCount(); ++ii) {
                if (!OlapMember.equal(miniTuple.getMember(ii), calcMember)) continue;
                calcMemberInTuple = true;
                break;
            }
        }
        this.calcMemberInMiniTuple = calcMemberInTuple;
    }

    public GFCalcTupleCacheKey createCalcTupleCacheKey(GFContext context, GFMiniTupleEvaluatorInitialContext evalTupleI, @Nullable OlapTuple iTuple) {
        OlapHierarchy hierarchy;
        OlapMember member;
        int ii;
        if (this.calcMember == null) {
            throw new RuntimeException("internal error: unexpected missing calc. member : " + String.valueOf(this));
        }
        OlapBitSet miniTupleD = this.calcMemberInMiniTuple ? this.miniTuple.getTupleDimensionality().asBitSet() : new OlapBitSet();
        ArrayList<OlapMember> membersKEY = new ArrayList<OlapMember>();
        int miniTupleS = this.getMemberCount_();
        for (ii = 0; ii < miniTupleS; ++ii) {
            member = this.getMember_(ii);
            hierarchy = member.getHierarchy();
            membersKEY.add(member);
            if (this.calcMemberInMiniTuple) continue;
            miniTupleD.set(hierarchy.getTupleDimensionalityIndex());
        }
        if (iTuple != null) {
            int iTupleS = iTuple.getMemberCount();
            for (ii = 0; ii < iTupleS; ++ii) {
                member = iTuple.getMember(ii);
                hierarchy = member.getHierarchy();
                if (miniTupleD.get(hierarchy.getTupleDimensionalityIndex())) continue;
                membersKEY.add(member);
            }
        }
        OlapTupleDimensionality iTupleD = iTuple != null ? iTuple.getTupleDimensionality() : null;
        GFEvalTuple evalTuple = evalTupleI.getEvalTuple();
        int evalTupleS = evalTuple.getMemberCount();
        for (int ii2 = 0; ii2 < evalTupleS; ++ii2) {
            OlapMember member2 = evalTuple.getMember(ii2);
            OlapHierarchy hierarchy2 = member2.getHierarchy();
            if (miniTupleD.get(hierarchy2.getTupleDimensionalityIndex()) || iTupleD != null && iTupleD.isIn(hierarchy2)) continue;
            membersKEY.add(member2);
        }
        GFEvalTupleVisibility visibility = evalTuple.getVisibility();
        OlapTupleDimensionality overwrittenHierarchies = evalTuple.getOverwrittenHierarchies();
        List<S_RequestSubCubeRef> subCubes = evalTuple.getSubCubes();
        S_VisualTotalsDef visualTotals = evalTuple.getVisualTotals();
        GFCalcTupleCacheKey key = new GFCalcTupleCacheKey(visibility, this.calcMember, membersKEY, overwrittenHierarchies, subCubes, visualTotals);
        return key;
    }

    public boolean noEmptyEvaluation() {
        return this.noEmptyEvaluation;
    }

    public OlapTuple miniTuple() {
        return this.miniTuple;
    }

    @Nullable
    public OlapCalculatedMember calcMember() {
        return this.calcMember;
    }

    public boolean isCalcMember() {
        return this.calcMember != null;
    }

    public GFTupleEvaluationFrame asTupleEvaluationFrame(GFContext context) {
        boolean inCalcMemberEvaluation = context.isInCalcMemberEvaluation(this.calcMember);
        if (this.calcMemberInMiniTuple || this.calcMember == null) {
            return new GFTupleEvaluationFrame(inCalcMemberEvaluation, this.miniTupleOrigins, this.miniTuple, this.calcMember);
        }
        ArrayList<OlapMemberOrigin> origins = new ArrayList<OlapMemberOrigin>();
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        for (int ii = 0; ii < this.miniTuple.getMemberCount(); ++ii) {
            origins.add(this.miniTupleOrigins.get(ii));
            members.add(this.miniTuple.getMember(ii));
        }
        origins.add(this.calcMemberOrigin);
        members.add(this.calcMember);
        OlapTuple tuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)context, context.getTupleDimensionalityCache(), null, members);
        return new GFTupleEvaluationFrame(inCalcMemberEvaluation, origins, tuple, this.calcMember);
    }

    public int getMemberCount_() {
        if (this.calcMemberInMiniTuple || this.calcMember == null) {
            return this.miniTuple.getMemberCount();
        }
        return this.miniTuple.getMemberCount() + 1;
    }

    public OlapMemberOrigin getMemberOrigin_(int pos) {
        if (pos < this.miniTuple.getMemberCount()) {
            return this.miniTupleOrigins.get(pos);
        }
        if (pos != this.miniTuple.getMemberCount()) {
            throw new RuntimeException("internal error: inconsistent pos [" + pos + "] [" + this.miniTuple.getMemberCount() + "]");
        }
        if (this.calcMemberOrigin == null) {
            throw new RuntimeException("internal error: unexpected missing calc. member origin");
        }
        return this.calcMemberOrigin;
    }

    public OlapMember getMember_(int pos) {
        if (pos < this.miniTuple.getMemberCount()) {
            return this.miniTuple.getMember(pos);
        }
        if (pos != this.miniTuple.getMemberCount()) {
            throw new RuntimeException("internal error: inconsistent pos [" + pos + "] [" + this.miniTuple.getMemberCount() + "]");
        }
        if (this.calcMember == null) {
            throw new RuntimeException("internal error: unexpected missing calc. member");
        }
        return this.calcMember;
    }

    @Nullable
    public OlapNonScalarEntity getMembers(OlapHierarchy hierarchy) {
        OlapNonScalarEntity members = this.miniTuple.getMembers(hierarchy);
        if (members == null && this.calcMember != null) {
            members = this.calcMember.getMembers(hierarchy);
        }
        return members;
    }

    public List<OlapMember> getMembersList(OlapHierarchy hierarchy) {
        List<OlapMember> members = this.miniTuple.getMembersList(hierarchy);
        if (members.isEmpty() && this.calcMember != null) {
            members = this.calcMember.getMembersList(hierarchy);
        }
        return members;
    }

    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy) {
        OlapMember member = this.miniTuple.getMember(hierarchy);
        if (member == null && this.calcMember != null) {
            member = this.calcMember.getMember(hierarchy);
        }
        return member;
    }

    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy, int idx) {
        OlapMember member = this.miniTuple.getMember(hierarchy, idx);
        if (member == null && this.calcMember != null) {
            member = this.calcMember.getMember(hierarchy, idx);
        }
        return member;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + String.valueOf(this.debug__) + "] ");
        for (int tt = 0; tt < this.miniTuple.getMemberCount(); ++tt) {
            if (tt > 0) {
                sb.append(", ");
            }
            OlapMember member = this.miniTuple.getMember(tt);
            sb.append(member.getNameX());
        }
        if (this.calcMember != null) {
            sb.append(", [+CM] ").append(this.calcMember.getNameX());
        }
        return sb.toString();
    }
}

