/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context.calccache;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapCalcMemberStackOverflowEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCache;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheKey;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheMode;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCachesAll;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCachesNone;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCachesOnDemand;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public abstract class GFCalcTupleCaches {
    private final int limit;
    private final Map<OlapCalculatedMember, GFCalcTupleCache> caches = new ConcurrentHashMap<OlapCalculatedMember, GFCalcTupleCache>();
    private final AtomicInteger size = new AtomicInteger();

    public GFCalcTupleCaches(int limit) {
        this.limit = limit;
    }

    public static GFCalcTupleCaches create(OlapSelectStatementExecutionContext sContext) {
        OlapProperties properties = sContext.getRequestProperties();
        GFCalcTupleCacheMode mode = properties.getMdxQueryCalcMemberCacheMode();
        int limit = properties.getMdxQueryCalcMemberCacheMax();
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] create calc. member cache [ mode : " + String.valueOf((Object)mode) + " " + limit + " ]"));
        switch (mode) {
            case ALL: {
                return new GFCalcTupleCachesAll(limit);
            }
            case NONE: {
                return new GFCalcTupleCachesNone(limit);
            }
            case ON_DEMAND: {
                return new GFCalcTupleCachesOnDemand(limit);
            }
        }
        throw new RuntimeException("internal error: unexpected calc. member cache mode [" + String.valueOf((Object)mode) + "]");
    }

    public abstract boolean acceptCalcMember(OlapCalculatedMember var1);

    public void onCellValuesProcessed(OlapSelectStatementExecutionContext sContext) {
        OlapMdxStatementEvalStatistics stats = sContext.getEvalStatistics();
        for (GFCalcTupleCache cache : this.caches.values()) {
            stats.onCalcMemberCached(cache.calcMember(), cache.size(), cache.get(), cache.miss());
        }
    }

    public OlapScalarEntity getValue(GFContext context, GFCalcTupleCacheKey tupleKey, Supplier<OlapScalarEntity> supplier) {
        try {
            OlapScalarEntity value = this.unsafeGetValue(context, tupleKey, supplier);
            return value;
        }
        catch (StackOverflowError error) {
            List<OlapCalculatedMember> cycle = context.computeCalcMemberCycleX();
            OlapCalculatedMember calcMember = tupleKey.getCalcMember();
            if (!cycle.contains(calcMember)) {
                cycle.add(calcMember);
            }
            String errMessage = this.createCalcMemberCycleErrorMessage(context, calcMember, cycle);
            throw new OlapCalcMemberStackOverflowEvaluationException((IOlapEvaluationExceptionContext)context, cycle, errMessage);
        }
    }

    protected String createCalcMemberCycleErrorMessage(GFContext context, OlapCalculatedMember calcMember, List<OlapCalculatedMember> cycle) {
        OlapNameContext nameContext = context.getNameContext();
        StringBuilder sb = new StringBuilder("Calculated member " + calcMember.getUniqueName(nameContext) + " stack overflow (see icCube.calcMemberMaxEvaluationFrameStackSize XMLA property) detected at (");
        for (int cc = 0; cc < cycle.size(); ++cc) {
            OlapCalculatedMember calculatedMember = cycle.get(cc);
            if (cc > 0) {
                sb.append(" ");
            }
            sb.append(calculatedMember.getName(nameContext));
        }
        sb.append(")");
        return sb.toString();
    }

    protected OlapScalarEntity unsafeGetValue(GFContext context, GFCalcTupleCacheKey tupleKey, Supplier<OlapScalarEntity> supplier) throws StackOverflowError {
        OlapCalculatedMember calcMember = tupleKey.getCalcMember();
        GFCalcTupleCache cache = this.caches.computeIfAbsent(calcMember, GFCalcTupleCache::new);
        cache.onGetValue();
        OlapScalarEntity value = cache.getValue(context, tupleKey);
        if (value == null) {
            cache.onMissValue();
            value = supplier.get();
            value = value.asConstant();
            if (this.size.get() < this.limit) {
                OlapScalarEntity prevValue = cache.putValueIfAbsent(context, tupleKey, value);
                if (prevValue == null) {
                    this.size.incrementAndGet();
                } else {
                    value = prevValue;
                }
            }
        }
        return value;
    }
}

