/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context.calccache;

import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class GFCalcTupleCache {
    private final OlapCalculatedMember calcMember;
    private final Map<GFCalcTupleCacheKey, OlapScalarEntity> cache = new ConcurrentHashMap<GFCalcTupleCacheKey, OlapScalarEntity>();
    private final AtomicReference<List<OlapCellPropertyValue>> cellProperties = new AtomicReference();
    private final AtomicLong get = new AtomicLong();
    private final AtomicLong miss = new AtomicLong();

    public GFCalcTupleCache(OlapCalculatedMember calcMember) {
        this.calcMember = calcMember;
    }

    public OlapCalculatedMember calcMember() {
        return this.calcMember;
    }

    public long size() {
        return this.cache.size();
    }

    public long get() {
        return this.get.get();
    }

    public long miss() {
        return this.miss.get();
    }

    public void onGetValue() {
        this.get.incrementAndGet();
    }

    public void onMissValue() {
        this.miss.incrementAndGet();
    }

    @Nullable
    public OlapScalarEntity getValue(GFContext context, GFCalcTupleCacheKey tupleKey) {
        List<OlapCellPropertyValue> properties;
        OlapScalarEntity value = this.cache.get(tupleKey);
        if (value != null && (properties = this.cellProperties.get()) != null) {
            context.setCalcMemberCellPropertyValues(properties);
        }
        return value;
    }

    @Nullable
    public OlapScalarEntity putValueIfAbsent(GFContext context, GFCalcTupleCacheKey tupleKey, OlapScalarEntity value) {
        List<OlapCellPropertyValue> properties;
        OlapScalarEntity prevValue = this.cache.putIfAbsent(tupleKey, value);
        if (prevValue == null && this.cellProperties.get() == null && !(properties = context.getCalcMemberCellPropertyValues()).isEmpty()) {
            this.cellProperties.set(properties);
        }
        return prevValue;
    }
}

