/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdSingleItemList;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdMutableInt;
import crazydev.common.utils.CdMutableRef;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultCalcMembers;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleDefaultMembers;
import crazydev.iccube.cluster.master.facts.M_ClusterTupleAggregator;
import crazydev.iccube.cluster.node.context.N_FactPageAggregationHelper;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.exception.OlapFunctionError;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapFactlessCube;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.scalar.OlapAbstractStringEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.catmember.OlapRequestCategoryMemberManager;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapCalcMemberStackOverflowEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapFunctionStackOverflowEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapAsNamedSetPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstrRef;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCalcMemberEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFConstrainedEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFStaticFunctionEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFMiniTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.GFTupleEvaluationFrame;
import crazydev.iccube.olap.eval.execinstr.gf.context.impl.IGFStrToFunctionCallback;
import crazydev.iccube.olap.eval.execinstr.gf.executors.lambda.GFEmptySetEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.executors.lambda.GFRawSetEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.executors.lambda.GFSetEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFStaticDeclaredFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleBuilder;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleBuilderFull;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFMiniTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.facts.aggregation.OlapFactsRollupSolver;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainTupleFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapConstDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsCluster;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.lambda.IOlapLambdaProcessingEnabled;
import crazydev.iccube.olap.eval.method.OlapModuleMethodsRepository;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.select.OlapDeclaredFunctionCallFrame;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapIteratedTuple;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapStaticFunctionEvaluationContext;
import crazydev.iccube.olap.eval.subselect.dimension.OlapCurrentTupleFilter;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapExistHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class GFContext
implements IOlapPrepareContext {
    protected final OlapMdxStatementExecutionContext sContext;
    private final OlapEvaluationContext evalContext;
    private final OlapStack<OlapAsNamedSetPreparedInstr> asNamedSets;
    private final OlapStack<OlapTupleSet> asNamedSets_;
    private final OlapStack<S_RequestSubCubeDef> factsSubCubes;
    private final OlapStack<OlapIteratedTuple> iteratedTuples;
    private final OlapStack<GFTupleEvaluationFrame> tupleEvaluationFrames;
    private final OlapStack<GFFactsEvalTuple> currentTupleForDrillthrough;
    private final OlapStack<OlapDeclaredFunctionCallFrame> declaredFunctionCallFrames;
    private final int tupleEvaluationFrameMaxSize;
    private final int declaredFunctionCallFramesMaxSize;
    private final Map<OlapCellProperty, Map<Integer, OlapCellPropertyValue>> cellPropertyValues;
    private final OlapStack<Integer> cellMeasureVectorPos;
    private final OlapStack<ConstDeclaredSnapshot> constFuncSnapshots;
    private final Map<OlapInstr, OlapPreparedInstrRef> references = new HashMap<OlapInstr, OlapPreparedInstrRef>();
    private OlapRoleDefaultCalcMembers resolvedDefaultsAsCalcMembers;
    private OlapRoleDefaultMembers resolvedDefaults;
    private int currentIteratedTupleUsageValidity;
    private boolean setupAggregationTypeOn;
    @Nullable
    private OlapAggregationType aggregationType;
    @Nullable
    private OlapMember aggregationTypeMember;
    private OlapPreparedInstr currentInstruction;
    private GFNode currentNode;
    private GFMiniTupleEvaluator miniTupleEvaluators;
    private boolean statsFrozen;
    private volatile OlapScalarEntity<?> currentValue;

    public GFContext(OlapEvaluationContext evalContext) {
        this.sContext = evalContext.getStatementExecutionContext();
        this.evalContext = evalContext;
        this.asNamedSets = new OlapStack();
        this.asNamedSets_ = new OlapStack();
        this.factsSubCubes = new OlapStack();
        this.iteratedTuples = new OlapStack();
        this.tupleEvaluationFrameMaxSize = this.sContext.getCalcMemberMaxEvaluationFrameStackSize();
        this.tupleEvaluationFrames = new OlapStack();
        this.miniTupleEvaluators = null;
        this.declaredFunctionCallFramesMaxSize = this.sContext.getFunctionMaxEvaluationFrameStackSize();
        this.declaredFunctionCallFrames = new OlapStack();
        this.cellPropertyValues = new HashMap<OlapCellProperty, Map<Integer, OlapCellPropertyValue>>();
        this.cellMeasureVectorPos = new OlapStack();
        this.currentIteratedTupleUsageValidity = 0;
        this.setupAggregationTypeOn = false;
        this.aggregationType = null;
        this.aggregationTypeMember = null;
        this.constFuncSnapshots = new OlapStack();
        this.currentTupleForDrillthrough = new OlapStack();
    }

    protected GFContext(GFContext decorated) {
        this.sContext = decorated.sContext;
        this.evalContext = decorated.getEvalContext().asCalcMemberContext();
        this.asNamedSets = decorated.asNamedSets;
        this.asNamedSets_ = decorated.asNamedSets_;
        this.factsSubCubes = decorated.factsSubCubes;
        this.iteratedTuples = decorated.iteratedTuples;
        this.tupleEvaluationFrames = decorated.tupleEvaluationFrames;
        this.miniTupleEvaluators = decorated.miniTupleEvaluators;
        this.declaredFunctionCallFrames = decorated.declaredFunctionCallFrames;
        this.tupleEvaluationFrameMaxSize = decorated.tupleEvaluationFrameMaxSize;
        this.declaredFunctionCallFramesMaxSize = decorated.declaredFunctionCallFramesMaxSize;
        this.cellPropertyValues = decorated.cellPropertyValues;
        this.cellMeasureVectorPos = decorated.cellMeasureVectorPos;
        this.currentIteratedTupleUsageValidity = decorated.currentIteratedTupleUsageValidity;
        this.setupAggregationTypeOn = decorated.setupAggregationTypeOn;
        this.aggregationType = decorated.aggregationType;
        this.aggregationTypeMember = decorated.aggregationTypeMember;
        this.constFuncSnapshots = decorated.constFuncSnapshots;
        this.currentTupleForDrillthrough = new OlapStack();
        this.currentNode = decorated.peekCurrentNode();
        this.currentInstruction = decorated.peekCurrentInstruction();
    }

    public OlapMemberPropertyManager getMemberPropertyManager() {
        return this.evalContext.getMemberPropertyManager();
    }

    public final boolean isLambdaParallelProcessingEnabled(GFTupleEvaluator evaluator) {
        if (!evaluator.isAcceptingParallelLambdaProcessing()) {
            return false;
        }
        if (!this.isAcceptingParallelLambdaProcessing()) {
            return false;
        }
        boolean ok = this.sContext.isLambdaParallelProcessingOk();
        return ok;
    }

    protected boolean isAcceptingParallelLambdaProcessing() {
        return false;
    }

    public GFContext forkForParallelLambdaProcessing() {
        OlapEvaluationContext evalContextF = this.evalContext.forkForParallelLambdaProcessing();
        GFContext fork = this.doForkForParallelLambdaProcessing(evalContextF);
        fork.doSetupForParallelLambdaProcessing(this, evalContextF);
        return fork;
    }

    protected GFContext doForkForParallelLambdaProcessing(OlapEvaluationContext evalContextF) {
        throw new RuntimeException("internal error: inconsistent parallel lambda processing ( " + String.valueOf(this.getClass()) + " )");
    }

    protected void doSetupForParallelLambdaProcessing(GFContext from, OlapEvaluationContext evalContextF) {
        if (this.evalContext != evalContextF) {
            throw new RuntimeException("internal error: inconsistent parallel lambda processing setup");
        }
        this.asNamedSets.setupForParallelLambdaProcessing(from.asNamedSets);
        this.asNamedSets_.setupForParallelLambdaProcessing(from.asNamedSets_);
        this.factsSubCubes.setupForParallelLambdaProcessing(from.factsSubCubes);
        this.iteratedTuples.setupForParallelLambdaProcessing(from.iteratedTuples);
        this.tupleEvaluationFrames.setupForParallelLambdaProcessing(from.tupleEvaluationFrames);
        this.declaredFunctionCallFrames.setupForParallelLambdaProcessing(from.declaredFunctionCallFrames);
        this.constFuncSnapshots.setupForParallelLambdaProcessing(from.constFuncSnapshots);
        this.references.putAll(from.references);
        this.resolvedDefaultsAsCalcMembers = from.resolvedDefaultsAsCalcMembers;
        this.resolvedDefaults = from.resolvedDefaults;
        this.currentIteratedTupleUsageValidity = from.currentIteratedTupleUsageValidity;
        this.currentInstruction = from.currentInstruction;
        this.currentNode = from.currentNode;
        this.statsFrozen = from.statsFrozen;
    }

    @Override
    public boolean isCancelling() {
        return this.sContext.isCancelling();
    }

    @Override
    public void assertNotCancelling(String message) {
        this.sContext.assertNotCancelling(message);
    }

    public GFStaticFunctionEvalContext asStaticFunctionContext(final GFStaticDeclaredFunctionCallNode functionNode) {
        OlapCube cube;
        OlapSchema schema = this.sContext.getSchema();
        if (functionNode.isInSelect()) {
            OlapCube currentCube = this.evalContext.getCube();
            cube = currentCube.getUnderlying();
        } else {
            String cubeName = functionNode.getCubeName();
            if (cubeName != null) {
                cube = this.evalContext.lookupCubeByMdxIdentifier(cubeName);
                if (cube == null) {
                    throw new OlapEvaluationException(this.getErrorLocation(), OlapErrorCode.CUBE_UNKNOWN_FUNCTION, new Serializable[]{schema.getName(), cubeName, functionNode.getFunctionName()});
                }
            } else {
                IOlapSchemaPermission perms = this.getSchemaPermissions();
                List<OlapCube> cubes = schema.getCubes(perms);
                if (cubes.size() == 1) {
                    cube = cubes.get(0);
                } else {
                    OlapInstrLocationRange locationRange = functionNode.getLocationRange();
                    String prefix = "static function [" + functionNode.getFunctionName() + "] ";
                    cube = new OlapFactlessCube(this, locationRange, prefix, schema){
                        final /* synthetic */ GFContext this$0;
                        {
                            GFContext gFContext = this$0;
                            Objects.requireNonNull(gFContext);
                            this.this$0 = gFContext;
                            super(locationRange, prefix, schema);
                        }

                        @Override
                        public OlapMeasuresDimension getMeasuresDimension() {
                            throw new OlapEvaluationException(this.this$0.getErrorLocation(), OlapErrorCode.STATIC_FUNCTION_MISSING_CUBE, new Serializable[]{functionNode.getFunctionName()});
                        }
                    };
                }
            }
        }
        OlapMdxStatementWithCubeSelectExecutionContext statementContext = new OlapMdxStatementWithCubeSelectExecutionContext(this.sContext.getRequestContext(), this.sContext.getRequestContext().getOlapEngineProperties(), this.sContext.getAnnotations(), this.sContext.getInstrExecListener(), schema, cube, true);
        statementContext.adoptMdxExtraExecutionLOCK(this.sContext);
        OlapStaticFunctionEvaluationContext eContext = new OlapStaticFunctionEvaluationContext((OlapMdxStatementExecutionContext)statementContext, cube);
        return new GFStaticFunctionEvalContext(eContext);
    }

    public GFContext onConstDeclaredFunctionStarted(OlapConstDeclaredFunction function) {
        this.constFuncSnapshots.push(new ConstDeclaredSnapshot(this, function));
        return this;
    }

    public void onConstDeclaredFunctionCompleted() {
        ConstDeclaredSnapshot snapshot = this.constFuncSnapshots.pop();
        snapshot.restoreTo(this);
    }

    @Override
    public String getUsage() {
        return this.evalContext.getUsage();
    }

    @Override
    public boolean isForAuthExpression() {
        return this.evalContext.isForAuthExpression();
    }

    @Override
    public boolean isForSubSelectExpression() {
        return this.evalContext.isInSubQuery();
    }

    @Override
    public boolean isForCellPropertyExpression() {
        return false;
    }

    @Override
    public int getInternalTupleListCount() {
        if (this.isForAuthExpression()) {
            return Integer.MAX_VALUE;
        }
        return this.sContext.getInternalTupleListCount();
    }

    @Override
    public int getInternalTupleListCountCJ() {
        if (this.isForAuthExpression()) {
            return Integer.MAX_VALUE;
        }
        return this.sContext.getInternalTupleListCountCJ();
    }

    @Nullable
    public ClassLoader getNativeFunctionsClassLoader() {
        return this.sContext.getNativeFunctionsClassLoader();
    }

    public GFEvalTupleVisibility getEvalTupleVisibility() {
        return this.evalContext.getEvalTupleVisibility();
    }

    public boolean hasInstrExecListener() {
        return this.getInstrExecListener() != null;
    }

    @Override
    @Nullable
    public OlapInstrExecListener getInstrExecListener() {
        return this.sContext.getInstrExecListener();
    }

    public void stopInstrExecListening(@Nullable GFNode iterableNode) {
        this.sContext.stopInstrExecListening(iterableNode);
    }

    public boolean isInstrExecListening() {
        return this.sContext.isInstrExecListening();
    }

    public void setInstrExecListening(boolean value) {
        this.sContext.setInstrExecListening(value);
    }

    public GFCalcMemberEvalContext asCalcMemberEvalContext() {
        return new GFCalcMemberEvalContext(this);
    }

    public OlapRoleDefaultCalcMembers getDefaultAsCalcMembersFromPermissions() {
        if (this.resolvedDefaultsAsCalcMembers == null) {
            this.resolvedDefaultsAsCalcMembers = this.sContext.getDefaultAsCalcMembersFromPermissions();
        }
        return this.resolvedDefaultsAsCalcMembers;
    }

    public OlapRoleDefaultMembers getDefaultsFromPermissions(@Nullable IOlapFactMeasureGroupManagerForEval measureGroup) {
        if (measureGroup == null) {
            if (this.resolvedDefaults == null) {
                this.resolvedDefaults = this.sContext.getDefaultsFromPermissions(null);
            }
            return this.resolvedDefaults;
        }
        OlapRoleDefaultMembers defaults = this.sContext.getDefaultsFromPermissions(measureGroup);
        return defaults;
    }

    public void processTupleEvaluationFrames(OlapStack.Processor<GFTupleEvaluationFrame> processor) {
        if (!this.tupleEvaluationFrames.isEmpty()) {
            this.tupleEvaluationFrames.process(processor);
        }
    }

    public OlapEngineRequestContext getRequestContext() {
        return this.evalContext.getRequestContext();
    }

    public IOlapPrepareContext getPrepareContext() {
        return this;
    }

    @Override
    public OlapMemberPropertyEvalContext getMemberPropertyEvalContext() {
        return this.evalContext.getMemberPropertyEvalContext();
    }

    public OlapEvaluationContext getEvalContext() {
        return this.evalContext;
    }

    public OlapMdxStatementExecutionContext getStatementExecutionContext() {
        return this.sContext;
    }

    @Override
    public void assertEntityUsage(OlapEntityIdentifier id, OlapNonScalarEntity entity) {
        this.evalContext.assertEntityUsage(id, entity);
    }

    @Override
    public String getUnderlyingCubeName(OlapNameContext nameContext) {
        return this.evalContext.getUnderlyingCubeName(nameContext);
    }

    @Override
    @Nullable
    public OlapEntity lookupCurrent(String key) {
        return this.evalContext.lookupCurrent(key);
    }

    @Override
    @Nullable
    public Object markAsNamedSet() {
        return this.asNamedSets.mark();
    }

    @Override
    public void pushAsNameSet(OlapAsNamedSetPreparedInstr instr) {
        this.asNamedSets.push(instr);
    }

    @Override
    public void resetAsNamedSetToMark(@Nullable Object mark) {
        this.asNamedSets.resetToMark((OlapAsNamedSetPreparedInstr)mark);
    }

    @Override
    public OlapNonScalarEntity lookupAsNamedSet(String identifier) {
        OlapTupleSet set = this.evalContext.lookupAsNamedSet(identifier);
        if (set != null) {
            return set;
        }
        CdMutableRef ref = new CdMutableRef((Object)OlapNullEntity.INSTANCE);
        this.asNamedSets.process(namedSet -> {
            String setName = namedSet.getName();
            if (identifier.equalsIgnoreCase(setName)) {
                ref.value = namedSet.asEntityForLookup();
                return false;
            }
            return true;
        });
        return (OlapNonScalarEntity)ref.value;
    }

    @Nullable
    public Object markAsNamedSet_() {
        return this.asNamedSets_.mark();
    }

    public void pushAsNameSet_(OlapTupleSet instr) {
        this.asNamedSets_.push(instr);
    }

    public void resetAsNamedSetToMark_(@Nullable Object mark) {
        this.asNamedSets_.resetToMark((OlapTupleSet)mark);
    }

    @Nullable
    public OlapTupleSet lookupAsNamedSet_(String identifier) {
        CdMutableRef ref = new CdMutableRef();
        this.asNamedSets_.process(namedSet -> {
            String setName = namedSet.getName();
            if (identifier.equalsIgnoreCase(setName)) {
                ref.value = namedSet;
                return false;
            }
            return true;
        });
        return (OlapTupleSet)ref.value;
    }

    @Override
    public boolean isDimensionOrHierarchyPrefix(OlapEntityIdentifier id) {
        return this.evalContext.isDimensionOrHierarchyPrefix(id);
    }

    @Override
    @Nullable
    public OlapIntrinsicMemberProperty getIntrinsicProperty(String propertyName) {
        return this.evalContext.getIntrinsicProperty(propertyName);
    }

    @Override
    @Nullable
    public OlapDeclaredFunction lookupDeclaredFunction(String functionName) {
        return this.evalContext.lookupDeclaredFunction(functionName);
    }

    @Override
    @Nullable
    public OlapFunction lookupRegularFunction(String functionName) {
        return this.evalContext.lookupRegularFunction(functionName);
    }

    @Override
    @Nullable
    public OlapInstrLocationRange getErrorLocation() {
        if (this.currentNode != null) {
            OlapInstrLocationRange res = this.currentNode.getLocationRange();
            return res;
        }
        if (this.currentInstruction != null) {
            OlapInstrLocationRange res = this.currentInstruction.getLocationRange();
            return res;
        }
        OlapInstrLocationRange res = this.evalContext.getErrorLocation();
        return res;
    }

    @Override
    public IOlapEvaluationExceptionContext snapshotForError() {
        IOlapEvaluationExceptionContext snapshot = IOlapEvaluationExceptionContext.snapshotForError(this);
        return snapshot;
    }

    @Override
    public boolean isConstrained() {
        if (this.evalContext.isConstrained()) {
            throw new RuntimeException("internal error: inconsistent CONSTRAINED context setup");
        }
        return false;
    }

    @Override
    public <T> T onConstrainedViolation() {
        throw new RuntimeException("internal error: inconsistent CONSTRAINED context setup");
    }

    @Override
    public boolean isDimensionalityCheck() {
        return this.evalContext.isDimensionalityCheck();
    }

    public boolean isOnDemand() {
        return false;
    }

    public boolean isCellEvaluation() {
        return this.evalContext.isCellEvaluation();
    }

    @Override
    public boolean isAcceptingFunctionCall(OlapFunction function) {
        return this.evalContext.isAcceptingFunctionCall(function);
    }

    @Override
    public OlapProperties getRequestProperties() {
        return this.evalContext.getRequestProperties();
    }

    public Locale getOlapEngineLocale() {
        return this.evalContext.getRequestContext().getOlapEngineComponent().getLocale();
    }

    @Override
    public Locale getLocale() {
        return this.evalContext.getLocale();
    }

    public Locale getLocaleForFormattingNumeric(Locale locale) {
        return this.evalContext.getLocaleForFormattingNumeric(locale);
    }

    public String getUserName() {
        return this.evalContext.getUserName();
    }

    @Override
    public OlapNameContext getNameContext() {
        return this.evalContext.getNameContext();
    }

    @Nullable
    public IOlapBigBrotherMgr getBigBrother() {
        return this.evalContext.getServerMonitoring();
    }

    public OlapRequestCategoryMemberManager getRequestCategoryMemberManager() {
        return this.evalContext.getRequestCategoryMemberManager();
    }

    public List<OlapDimension> getAllDimensions() {
        return this.evalContext.getAllDimensions();
    }

    public int getHierarchyCount() {
        return this.evalContext.getHierarchyCount();
    }

    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy() {
        return this.evalContext.getDefaultTimeHierarchy();
    }

    public OlapTupleSet<OlapTuple> getAxis(int number) {
        return this.evalContext.getAxis(number);
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getSubSelectAxis(int number) {
        return this.evalContext.getSubSelectAxis(number);
    }

    @Nullable
    public OlapTupleSet<OlapTuple> getSlicerSet() {
        return this.evalContext.getSlicerSet();
    }

    public OlapSchema getSchema() {
        return this.evalContext.getSchema();
    }

    public OlapCube getCube() {
        return this.evalContext.getCube();
    }

    public String getUnderlyingCubeName() {
        return this.evalContext.getUnderlyingCubeName(this.getNameContext());
    }

    public OlapEvalResultCellValue getCellValue() {
        throw new OlapEvaluationException(this, OlapErrorCode.CURRENT_CELL_VALUE_CONTEXT_ERROR, new Serializable[0]);
    }

    @Override
    public OlapTupleDimensionalityCache getTupleDimensionalityCache() {
        return this.evalContext.getTupleDimensionalityCache();
    }

    public IOlapSchemaPermission getSchemaPermissions() {
        return this.evalContext.getSchemaPermissions();
    }

    public IOlapSchemaPermission getSchemaPermissionsWithoutPerspective() {
        return this.evalContext.getSchemaPermissionsWithoutPerspective();
    }

    @Override
    public IOlapDimensionsPermission getDimensionsPermissions() {
        return this.evalContext.getDimensionsPermissions();
    }

    public IOlapHierarchyPermission getHierarchyPermissions(OlapHierarchy hierarchy) {
        return this.evalContext.getHierarchyPermissions(hierarchy);
    }

    public IOlapHierarchyPermission getHierarchyPermissionsWithoutPerspective(OlapHierarchy hierarchy) {
        return this.evalContext.getHierarchyPermissionsWithoutPerspective(hierarchy);
    }

    public OlapNonScalarEntity lookupHierarchy(int position) {
        return this.evalContext.lookupHierarchy(position);
    }

    @Override
    public OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, int lookup, OlapEntityIdentifier identifier) {
        return this.evalContext.lookupEntityByMdxIdentifier(nameContext, OlapMdxEntityLookupKinds.ALL, identifier);
    }

    public List<OlapUserMeasureMember> lookupUserDefinedMeasures(@Nullable OlapMemberFilter filter) {
        return this.evalContext.lookupUserDefinedMeasures(filter);
    }

    @Nullable
    public OlapFunction lookupFunction(String name) {
        return this.evalContext.lookupFunction(name);
    }

    @Nullable
    public OlapEntity lookupDeclaredFunctionArgument(int index) {
        if (!this.declaredFunctionCallFrames.isEmpty()) {
            OlapDeclaredFunctionCallFrame frame = this.declaredFunctionCallFrames.peek();
            return frame.getDeclaredFunctionArgument(index);
        }
        return null;
    }

    public Object pushFunctionCallFrame(String function, @Nullable OlapEntity[] args) {
        OlapDeclaredFunctionCallFrame frame = new OlapDeclaredFunctionCallFrame(function, args);
        this.declaredFunctionCallFrames.push(frame);
        this.assertNoFunctionCycle(function);
        return frame;
    }

    public void popFunctionCallFrame(Object ref) {
        OlapDeclaredFunctionCallFrame frame = this.declaredFunctionCallFrames.pop();
        if (ref != frame) {
            throw new RuntimeException("internal error: inconsistent declared function evaluation");
        }
    }

    private void assertNoFunctionCycle(String functionName) {
        if (this.declaredFunctionCallFrames.size() >= this.declaredFunctionCallFramesMaxSize) {
            List<String> cycle = this.computeDeclaredFunctionCycle();
            String errMessage = GFContext.createFunctionCycleErrorMessage(functionName, cycle);
            throw new OlapFunctionStackOverflowEvaluationException((IOlapEvaluationExceptionContext)this, cycle, errMessage);
        }
    }

    private List<String> computeDeclaredFunctionCycle() {
        ArrayList<String> cycle = new ArrayList<String>();
        this.declaredFunctionCallFrames.process(frame -> {
            String function = frame.getFunctionName();
            if (cycle.contains(function)) {
                cycle.add(function);
                Collections.reverse(cycle);
                return false;
            }
            cycle.add(function);
            return true;
        });
        return cycle;
    }

    private static String createFunctionCycleErrorMessage(String functionName, List<String> cycle) {
        StringBuilder sb = new StringBuilder("Function '" + functionName + "' stack overflow (see icCube.functionMaxEvaluationFrameStackSize XMLA property) (");
        for (String item : cycle) {
            sb.append(" ").append(item);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    @Nullable
    public OlapMemberFilter getMemberFilter() {
        return this.evalContext.getMemberFilter();
    }

    @Override
    @Nullable
    public OlapTupleFilter getMemberTupleFilter() {
        return this.evalContext.getMemberTupleFilter();
    }

    @Nullable
    public OlapTupleFilter getTupleFilter() {
        return this.evalContext.getTupleFilter();
    }

    @Nullable
    public OlapMemberFilter getSchemaPermissionsMemberFilter() {
        return this.evalContext.getSchemaPermissionsMemberFilter();
    }

    @Nullable
    public OlapSlicerFilter getSlicerTupleFilter() {
        return this.evalContext.getSlicerTupleFilter();
    }

    @Nullable
    public OlapSlicerFilter getSlicerTupleFilterForSetFiltering() {
        return this.evalContext.getSlicerTupleFilterForSetFiltering();
    }

    public List<OlapMember> getAllCalculatedMembers() {
        return this.evalContext.getAllCalculatedMembers();
    }

    @Override
    @Nullable
    public OlapMember getNullableCurrentMember(OlapHierarchy hierarchy) {
        return (OlapMember)this.getNullableCurrentMember(hierarchy, 0);
    }

    @Nullable
    public OlapNonScalarEntity getNullableCurrentMember(OlapHierarchy hierarchy, int idx) {
        return this._getOlapNonScalarEntity(hierarchy, idx, true);
    }

    @Nullable
    public OlapNonScalarEntity getNullableContextMember(OlapHierarchy hierarchy, int idx) {
        if (this.hasVisualSubselect()) {
            List<OlapMember> entities = this.getContextMembersList(hierarchy);
            if (idx == -1) {
                if (entities.size() > 1) {
                    throw new OlapEvaluationException(this, OlapErrorCode.CONTEXT_MEMBER_MULTIPLE_MEMBERS, new Serializable[]{hierarchy.getUniqueName(this.getNameContext())});
                }
                return entities.get(0);
            }
            return (OlapNonScalarEntity)CdCollections.getSafe(entities, (int)idx, null);
        }
        return this._getOlapNonScalarEntity(hierarchy, idx, false);
    }

    private OlapNonScalarEntity _getOlapNonScalarEntity(OlapHierarchy hierarchy, int idx, boolean useAutoExist) {
        OlapNonScalarEntity cEntity = this.getNullableCurrentEntityFromMiniEvaluationStack(hierarchy, idx);
        if (cEntity != null) {
            return cEntity;
        }
        cEntity = this.getNullableCurrentEntityFromEvaluationStack(hierarchy, idx);
        if (cEntity != null) {
            return cEntity;
        }
        OlapResSlicer slicer = this.evalContext.getSlicer();
        OlapMember cMember = this.evalContext.getNullableCurrentMemberFromSlicer(hierarchy, slicer);
        if (cMember != null) {
            return cMember;
        }
        if (useAutoExist && !hierarchy.isBase()) {
            cMember = this.getAutoExistMember(hierarchy);
        }
        if (cMember == null && hierarchy.isAttributeHierarchy() && (cEntity = this._getOlapNonScalarEntity(hierarchy.getDimension().getBaseHierarchy(), idx, false)) instanceof OlapMember) {
            cMember = ((OlapMember)cEntity).getAttributeMember(hierarchy);
        }
        if (cMember == null) {
            cMember = this.getNullableDefaultMember(hierarchy);
        }
        return cMember;
    }

    private OlapMember getNullableDefaultMember(OlapHierarchy hierarchy) {
        return hierarchy.getNullableDefaultMember(this.getMemberFilter());
    }

    private boolean hasVisualSubselect() {
        return this.sContext.getSubSelectCube() != null && this.sContext.getSubSelectCube().isVisual();
    }

    public OlapNonScalarEntity getDeclaredMembers(OlapHierarchy hierarchy) {
        List<OlapMember> members = this._getContextMembers(hierarchy, false);
        return OlapSetFactory.instance(members);
    }

    public OlapNonScalarEntity getContextMembers(OlapHierarchy hierarchy) {
        List<OlapMember> members = this.getContextMembersList(hierarchy);
        return OlapSetFactory.instance(members);
    }

    public List<OlapMember> getContextMembersList(OlapHierarchy hierarchy) {
        return this._getContextMembers(hierarchy, true);
    }

    public List<OlapMember> _getContextMembers(OlapHierarchy hierarchy, boolean withDefaults) {
        GFEvalTupleBuilderFull builder = new GFEvalTupleBuilderFull(this);
        GFEvalTuple evalTuple = builder.build(true);
        CdSingleItemList members = evalTuple.getContextMembers(this.getMemberFilter(), hierarchy);
        return withDefaults && members.isEmpty() ? new CdSingleItemList((Object)this.getNullableDefaultMember(hierarchy)) : members;
    }

    @Nullable
    private OlapNonScalarEntity getNullableCurrentEntityFromMiniEvaluationStack(OlapHierarchy hierarchy, int idx) {
        OlapNonScalarEntity[] cMember = new OlapNonScalarEntity[1];
        this.processMiniTupleEvaluationFrames(item -> {
            OlapNonScalarEntity member;
            OlapNonScalarEntity olapNonScalarEntity = member = idx == -1 ? item.getMembers(hierarchy) : item.getMember(hierarchy, idx);
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        return cMember[0];
    }

    @Nullable
    private OlapNonScalarEntity getNullableCurrentEntityFromEvaluationStack(OlapHierarchy hierarchy, int idx) {
        OlapNonScalarEntity[] cMember = new OlapNonScalarEntity[1];
        this.tupleEvaluationFrames.process(item -> {
            OlapNonScalarEntity member;
            OlapNonScalarEntity olapNonScalarEntity = member = idx == -1 ? item.tuple().getMembers(hierarchy) : item.tuple().getMember(hierarchy, idx);
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        return cMember[0];
    }

    @Nullable
    private OlapMember getAutoExistMember(OlapHierarchy hierarchy) {
        OlapHierarchy baseHierarchy = hierarchy.getDimension().getFactIndexingHierarchy();
        OlapMember baseHierarchyMember = this.getNullableCurrentMemberFromEvaluationStack_autoExist(baseHierarchy);
        if (baseHierarchyMember == null) {
            OlapResSlicer slicer = this.evalContext.getSlicer();
            baseHierarchyMember = this.evalContext.getNullableCurrentMemberFromSlicer(baseHierarchy, slicer);
        }
        if (baseHierarchyMember != null && hierarchy.isAttributeHierarchy()) {
            return baseHierarchyMember.getAttributeMember(hierarchy);
        }
        OlapTuple forExist = this.getNullableCurrentTupleFromEvaluationStack_autoExist(hierarchy.getDimension());
        OlapMember current = OlapExistHelper.autoExists(this.getNameContext(), baseHierarchyMember, hierarchy, forExist);
        return current;
    }

    private void processMiniTupleEvaluationFrames(OlapStack.Processor<GFMiniTupleEvaluationFrame> processor) {
        if (this.miniTupleEvaluators == null) {
            return;
        }
        this.miniTupleEvaluators.processMiniTupleEvaluationFrames(processor);
    }

    @Nullable
    private OlapMember getNullableCurrentMemberFromEvaluationStack_autoExist(OlapHierarchy hierarchy) {
        OlapMember[] cMember = new OlapMember[1];
        this.processMiniTupleEvaluationFrames(item -> {
            OlapMember member = item.getMember(hierarchy);
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        if (cMember[0] != null) {
            return cMember[0];
        }
        this.tupleEvaluationFrames.process(item -> {
            OlapMember member = item.tuple().getMember(hierarchy);
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        return cMember[0];
    }

    @Nullable
    private OlapTuple getNullableCurrentTupleFromEvaluationStack_autoExist(OlapDimension dimension) {
        OlapBitSet dimensionality = new OlapBitSet();
        ArrayList<OlapMember> cMembers = new ArrayList<OlapMember>();
        this.processMiniTupleEvaluationFrames(item -> {
            for (int ii = 0; ii < item.getMemberCount_(); ++ii) {
                OlapHierarchy hierarchy;
                int hierarchyIdx;
                OlapMember member = item.getMember_(ii);
                if (!member.getDimension().equals(dimension) || dimensionality.get(hierarchyIdx = (hierarchy = member.getHierarchy()).getTupleDimensionalityIndex())) continue;
                dimensionality.set(hierarchyIdx);
                cMembers.add(member);
            }
            return true;
        });
        this.tupleEvaluationFrames.process(item -> {
            OlapTuple tuple = item.tuple();
            for (int ii = 0; ii < tuple.getMemberCount(); ++ii) {
                OlapHierarchy hierarchy;
                int hierarchyIdx;
                OlapMember member = tuple.getMember(ii);
                if (!member.getDimension().equals(dimension) || dimensionality.get(hierarchyIdx = (hierarchy = member.getHierarchy()).getTupleDimensionalityIndex())) continue;
                dimensionality.set(hierarchyIdx);
                cMembers.add(member);
            }
            return true;
        });
        if (cMembers.isEmpty()) {
            return null;
        }
        if (cMembers.size() == 1) {
            return (OlapTuple)cMembers.get(0);
        }
        return OlapTupleFactory.instance((IOlapEvaluationExceptionContext)this, this.getTupleDimensionalityCache(), null, cMembers);
    }

    public void assertDimensionality(OlapTuple left, OlapTuple right) {
        OlapTupleDimensionalityHelper.assertDimensionality((IOlapEvaluationExceptionContext)this.evalContext, left, right);
    }

    public void addVisualTotalsCluster(OlapVisualTotalsCluster cluster) {
        this.evalContext.addVisualTotalsCluster(cluster);
    }

    public void doNotUseResultCache() {
        this.evalContext.doNotUseResultCache();
    }

    public void markForDrilldownStop() {
        this.evalContext.markForDrilldownStop();
    }

    public OlapEntityIdentifier compileIdentifier(String name) throws CdMdxScannerException, MdxParserException {
        return this.evalContext.compileIdentifier(name);
    }

    @Nullable(value="if the property cannot be found")
    public @Nullable(value="if the property cannot be found") OlapScalarEntity evalPropertyValue(OlapMember member, String propName, boolean typed) {
        OlapIntrinsicMemberProperty intrinsicProperty = OlapIntrinsicMemberProperties.getIntrinsicProperty(propName);
        if (intrinsicProperty == null) {
            if (member.hasUserDefinedProperty(propName)) {
                OlapMemberFilter memberFilter = this.getMemberFilter();
                OlapScalarEntity res = member.getPropertyValue(memberFilter, propName);
                if (res == null) {
                    return OlapEmptyEntity.INSTANCE;
                }
                return typed ? res : new OlapStringEntity(res.asString());
            }
            return null;
        }
        OlapScalarEntity value = intrinsicProperty.eval(this.evalContext.getMemberPropertyEvalContext(), member);
        if (typed || value instanceof OlapAbstractStringEntity) {
            return value;
        }
        if (value.isMdxNull()) {
            return new OlapStringEntity("");
        }
        return new OlapStringEntity(value.asString());
    }

    public OlapTuple completeTupleForElementValue(OlapTuple tuple) {
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        OlapBitSet membersDim = new OlapBitSet();
        for (int ii = 0; ii < tuple.getMemberCount(); ++ii) {
            OlapMember member = tuple.getMember(ii);
            OlapHierarchy hierarchy = member.getHierarchy();
            members.add(member);
            membersDim.set(hierarchy.getTupleDimensionalityIndex());
        }
        this.processMiniTupleEvaluationFrames(item -> {
            for (int ii = 0; ii < item.getMemberCount_(); ++ii) {
                OlapMember stackMember = item.getMember_(ii);
                OlapHierarchy stackMemberHierarchy = stackMember.getHierarchy();
                this.completeWithStackMember((List<OlapMember>)members, membersDim, (GFMiniTupleEvaluationFrame)item, stackMember, stackMemberHierarchy);
            }
            return true;
        });
        this.tupleEvaluationFrames.process(item -> {
            OlapTuple stackTuple = item.tuple();
            for (int ii = 0; ii < stackTuple.getMemberCount(); ++ii) {
                OlapMember stackMember = stackTuple.getMember(ii);
                OlapHierarchy stackMemberHierarchy = stackMember.getHierarchy();
                this.completeWithStackMember((List<OlapMember>)members, membersDim, stackTuple, stackMember, stackMemberHierarchy);
            }
            return true;
        });
        OlapTuple completed = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)this, this.sContext.getTupleDimensionalityCache(), null, members);
        return completed;
    }

    @Nullable
    public OlapTuple completeTupleForExisting() {
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        OlapBitSet membersDim = new OlapBitSet();
        this.processMiniTupleEvaluationFrames(item -> {
            for (int ii = 0; ii < item.getMemberCount_(); ++ii) {
                OlapMember stackMember = item.getMember_(ii);
                OlapHierarchy stackMemberHierarchy = stackMember.getHierarchy();
                this.completeWithStackMember((List<OlapMember>)members, membersDim, (GFMiniTupleEvaluationFrame)item, stackMember, stackMemberHierarchy);
            }
            return true;
        });
        this.tupleEvaluationFrames.process(item -> {
            OlapTuple stackTuple = item.tuple();
            for (int ii = 0; ii < stackTuple.getMemberCount(); ++ii) {
                OlapMember stackMember = stackTuple.getMember(ii);
                OlapHierarchy stackMemberHierarchy = stackMember.getHierarchy();
                this.completeWithStackMember((List<OlapMember>)members, membersDim, stackTuple, stackMember, stackMemberHierarchy);
            }
            return true;
        });
        OlapTuple completed = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)this, this.sContext.getTupleDimensionalityCache(), null, members);
        return completed;
    }

    public void setCellMeasure(OlapMember cellMeasure) {
    }

    public void setCellPropertyValueForCalcMember(OlapMember member) {
        OlapCellProperties properties = member.getCellProperties();
        if (properties != null) {
            List<OlapCellPropertyValue> propertyValues = properties.getCellPropertyValues();
            this.setCellPropertyValues(propertyValues);
        }
    }

    private void setCellPropertyValues(List<OlapCellPropertyValue> propertyValues) {
        if (propertyValues == null) {
            return;
        }
        for (int idx = 0; idx < propertyValues.size(); ++idx) {
            int pos;
            OlapCellPropertyValue propertyValue = propertyValues.get(idx);
            if (propertyValue.isIgnoredForCalcMemberPropsSetup()) {
                return;
            }
            OlapCellProperty property = propertyValue.getProperty();
            Map values = this.cellPropertyValues.computeIfAbsent(property, k -> new HashMap());
            if (values.containsKey(pos = this.cellMeasureVectorPos())) continue;
            values.put(pos, propertyValue);
        }
    }

    @Nullable
    public OlapCellPropertyValue getCellPropertyValueForCalcMember(OlapCellProperty property, int cellMeasureVectorPos) {
        Map<Integer, OlapCellPropertyValue> values = this.cellPropertyValues.get(property);
        if (values == null) {
            return null;
        }
        OlapCellPropertyValue value = values.get(cellMeasureVectorPos);
        return value;
    }

    public void pushCellMeasureVectorPos(int pos) {
        this.cellMeasureVectorPos.push(pos);
    }

    public void popCellMeasureVectorPos() {
        this.cellMeasureVectorPos.pop();
    }

    private int cellMeasureVectorPos() {
        CdMutableInt pos = new CdMutableInt(-1);
        this.cellMeasureVectorPos.process(item -> {
            if (item != -1) {
                pos.value = item;
                return false;
            }
            return true;
        });
        return pos.value;
    }

    public List<OlapCellPropertyValue> getCalcMemberCellPropertyValues() {
        List<OlapCellPropertyValue> values = null;
        int vectorPos = this.cellMeasureVectorPos();
        Set<OlapCellProperty> props = this.cellPropertyValues.keySet();
        for (OlapCellProperty prop : props) {
            OlapCellPropertyValue value = this.getCellPropertyValueForCalcMember(prop, vectorPos);
            if (value == null) continue;
            if (values == null) {
                values = new ArrayList<OlapCellPropertyValue>();
            }
            values.add(value);
        }
        return values != null ? values : Collections.emptyList();
    }

    public void setCalcMemberCellPropertyValues(List<OlapCellPropertyValue> propertyValues) {
        this.setCellPropertyValues(propertyValues);
    }

    @Nullable
    public Mark mark() {
        OlapAsNamedSetPreparedInstr asNamedSetsMark = this.asNamedSets.mark();
        OlapTupleSet asNamedSetsMark_ = this.asNamedSets_.mark();
        OlapIteratedTuple iteratedTuplesMark = this.iteratedTuples.mark();
        GFTupleEvaluationFrame tupleEvaluationFramesMark = this.tupleEvaluationFrames.mark();
        GFMiniTupleEvaluator miniTupleEvaluatorsMark = this.miniTupleEvaluators;
        GFMiniTupleEvaluationFrame miniTupleEvaluatorsMark_ = miniTupleEvaluatorsMark != null ? miniTupleEvaluatorsMark.mark() : null;
        OlapDeclaredFunctionCallFrame declaredFunctionCallFramesMark = this.declaredFunctionCallFrames.mark();
        if (asNamedSetsMark == null && asNamedSetsMark_ == null && iteratedTuplesMark == null && tupleEvaluationFramesMark == null && miniTupleEvaluatorsMark == null && miniTupleEvaluatorsMark_ == null && declaredFunctionCallFramesMark == null) {
            return null;
        }
        return new Mark(asNamedSetsMark, asNamedSetsMark_, iteratedTuplesMark, tupleEvaluationFramesMark, miniTupleEvaluatorsMark, miniTupleEvaluatorsMark_, declaredFunctionCallFramesMark);
    }

    public void resetToMark(@Nullable Mark mark) {
        if (mark != null) {
            this.asNamedSets.resetToMark(mark.asNamedSetsMark);
            this.asNamedSets_.resetToMark(mark.asNamedSetsMark_);
            this.iteratedTuples.resetToMark(mark.iteratedTuplesMark);
            this.tupleEvaluationFrames.resetToMark(mark.tupleEvaluationFramesMark);
            this.miniTupleEvaluators = mark.miniTupleEvaluatorsMark;
            if (this.miniTupleEvaluators != null) {
                GFMiniTupleEvaluator miniTupleEvaluator = this.miniTupleEvaluators;
                miniTupleEvaluator.resetToMark(mark.miniTupleEvaluatorsMark_);
            }
            this.declaredFunctionCallFrames.resetToMark(mark.declaredFunctionCallFramesMark);
        }
    }

    public void addStatementCachedObject(Object key, Object formatter) {
        this.evalContext.addStatementCachedObject(key, formatter);
    }

    @Nullable
    public Object getStatementCachedObject(Object key) {
        return this.evalContext.getStatementCachedObject(key);
    }

    public void setupAggregationTypeOn() {
        this.setupAggregationTypeOn = true;
        this.aggregationType = null;
        this.aggregationTypeMember = null;
    }

    public boolean isSetupAggregationTypeOn() {
        return this.setupAggregationTypeOn;
    }

    public void setupAggregationType(@Nullable OlapMember member) {
        if (!this.setupAggregationTypeOn) {
            throw new RuntimeException("internal error: inconsistent setup of the aggregation type!");
        }
        if (member != null && this.aggregationType == null) {
            this.aggregationType = member.getHierarchyAggregationType();
            this.aggregationTypeMember = member;
        }
    }

    @Nullable
    public OlapAggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Nullable
    public OlapMember getAggregationTypeMember() {
        return this.aggregationTypeMember;
    }

    public final OlapEntity executeNameToSetMdxExpression(GFTupleEvaluator evaluator, GFFunctionArgs args, OlapFunction function, int argumentIndex, String mdx, String mdxHash) throws OlapEvaluationException {
        OlapEntity res = this.doExecuteMdxExpression(this, evaluator, args, function, argumentIndex, mdx, mdxHash);
        return res;
    }

    public final <T> T executeStrToMdxExpression(GFTupleEvaluator evaluator, boolean constrained, GFFunctionArgs args, OlapFunction function, int argumentIndex, String mdx, String mdxHash, IGFStrToFunctionCallback<T> callback) throws OlapEvaluationException {
        GFContext cContext = constrained ? this.createConstrainedContext(function) : this;
        OlapEntity res = cContext.doExecuteMdxExpression(this, evaluator, args, function, argumentIndex, mdx, mdxHash);
        if (res.isMdxNull()) {
            return callback.onEntityNull();
        }
        return callback.onEntity(this, evaluator, cContext, res);
    }

    public GFConstrainedEvalContext createConstrainedContext(OlapFunction function) {
        return new GFConstrainedEvalContext(this, function);
    }

    private OlapEntity doExecuteMdxExpression(GFContext funContext, GFTupleEvaluator funEvaluator, GFFunctionArgs args, OlapFunction function, int argumentIndex, String mdx, String mdxHash) {
        try {
            OlapEntity res = this.doExecuteMdxExpressionX(funContext, funEvaluator, function, argumentIndex, mdx, mdxHash);
            return res;
        }
        catch (OlapException ex) {
            OlapInstrLocationRange argRange = args.getFunctionArgumentRange(0);
            if (argRange != null) {
                int from = argRange.from();
                int to = argRange.from() + (argRange.to() - argRange.from());
                ex.updateLocationRange(from, to);
            }
            throw ex;
        }
    }

    private OlapEntity doExecuteMdxExpressionX(GFContext funContext, GFTupleEvaluator funEvaluator, OlapFunction function, int argumentIndex, String mdx, String mdxHash) {
        try {
            if (mdx == null || mdx.trim().isEmpty()) {
                throw new RuntimeException("internal error: " + function.getName() + " - inconsistent empty MDX support");
            }
            OlapEngineComponent olapEngine = this.getRequestContext().getOlapEngineComponent();
            OlapModuleMethodsRepository moduleMethodsRepository = olapEngine.getModuleMethodsRepository();
            OlapCompilationContext ccontext = new OlapCompilationContext(this.sContext.getXmlaCaller(), this.getRequestContext().getMdxDefaultRequestedCellProperties(), this.getRequestProperties(), olapEngine.getFunctionRepository(), moduleMethodsRepository);
            OlapInstr instr = this.compileMdxExpression(ccontext, mdx, mdxHash);
            if (instr.isConstrainedEnabled() && this.isConstrained()) {
                this.onConstrainedViolation();
            }
            OlapPreparedInstr prepared = instr.prepare(this.getPrepareContext());
            GFNode tree = prepared.buildGFTree(new GFNodeBuildContext(this.hasInstrExecListener()), false);
            OlapEntity entity = tree.execute(this, funEvaluator);
            return entity;
        }
        catch (CdMdxException scanError) {
            return this.onMdxError(funContext, function, scanError);
        }
        catch (IOException ex) {
            throw new RuntimeException("internal error: could not read the MDX statement", ex);
        }
    }

    protected OlapInstr compileMdxExpression(OlapCompilationContext ccontext, String mdx, String mdxHash) throws IOException, CdMdxScannerException, MdxParserException {
        MdxParsingContext pcontext = new MdxParsingContext(ccontext.getProperties(), ccontext.getFunctionRepository(), this.getSchema().getFunctionRepositorySnapshot());
        MdxExpression expr = MdxParser.parseValueExpression(pcontext, mdx, mdxHash);
        return ccontext.compile(expr);
    }

    protected OlapEntity onMdxError(IOlapEvaluationExceptionContext funContext, OlapFunction function, CdMdxException scanError) {
        CdError error = scanError.getError();
        CdErrorCode code = scanError.getErrorCode();
        CdErrorLocation location = scanError.getLocation();
        OlapInstrLocationRange functionLocation = funContext.getErrorLocation();
        OlapFunctionError<OlapInstrLocationRange, CdErrorCode> functionError = new OlapFunctionError<OlapInstrLocationRange, CdErrorCode>(functionLocation, function.getName(), code, error.getParams());
        throw new OlapFunctionEvaluationException(functionError);
    }

    public Object pushIteratedTuple(OlapTupleSet namedSet, OlapTuple tuple, int ordinal) {
        OlapIteratedTuple item = new OlapIteratedTuple(namedSet, tuple, ordinal);
        this.iteratedTuples.push(item);
        return item;
    }

    public void popIteratedTuple(Object ref) {
        OlapIteratedTuple prev = this.iteratedTuples.pop();
        if (ref != prev) {
            throw new RuntimeException("internal error: inconsistent iterated tuple evaluation");
        }
    }

    public OlapTuple getIteratedTuple(OlapTupleSet set) {
        if (this.currentIteratedTupleUsageValidity != 0) {
            throw new OlapEvaluationException(this, OlapErrorCode.CURRENT_ITERATED_TUPLE_USAGE, new Serializable[]{set.getName()});
        }
        CdMutableRef tuple = new CdMutableRef();
        this.iteratedTuples.process(iTuple -> {
            OlapTupleSet iteratedTupleSet = iTuple.getSet();
            if (iteratedTupleSet == set) {
                tuple.value = iTuple;
                return false;
            }
            return true;
        });
        if (tuple.value != null) {
            return ((OlapIteratedTuple)tuple.value).getTuple();
        }
        if (this.constFuncSnapshots.isEmpty()) {
            throw new OlapEvaluationException(this, OlapErrorCode.NAMED_SET_NOT_IN_SCOPE, new Serializable[]{set.getName()});
        }
        ConstDeclaredSnapshot snapshot = this.constFuncSnapshots.peek();
        throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)this, snapshot.getFunction(), OlapErrorCode.CONST_FUNCTION_AS_NAMED_SET_USAGE, new Serializable[]{set.getName()});
    }

    public <T> T errorForMissingAsNamedSet(String name) {
        if (this.constFuncSnapshots.isEmpty()) {
            throw new OlapEvaluationException(this, OlapErrorCode.NAMED_SET_NOT_IN_SCOPE, new Serializable[]{name});
        }
        ConstDeclaredSnapshot snapshot = this.constFuncSnapshots.peek();
        throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)this, snapshot.getFunction(), OlapErrorCode.CONST_FUNCTION_AS_NAMED_SET_USAGE, new Serializable[]{name});
    }

    public OlapNumericEntity getIteratedTupleOrdinal(OlapTupleSet set) {
        if (this.currentIteratedTupleUsageValidity != 0) {
            throw new OlapEvaluationException(this, OlapErrorCode.CURRENT_ITERATED_TUPLE_USAGE, new Serializable[]{set.getName()});
        }
        CdMutableRef tuple = new CdMutableRef();
        this.iteratedTuples.process(iTuple -> {
            OlapTupleSet iteratedTupleSet = iTuple.getSet();
            if (iteratedTupleSet == set) {
                tuple.value = iTuple;
                return false;
            }
            return true;
        });
        if (tuple.value != null) {
            return ((OlapIteratedTuple)tuple.value).getOrdinal();
        }
        throw new OlapEvaluationException(this, OlapErrorCode.NAMED_SET_NOT_IN_SCOPE, new Serializable[]{set.getName()});
    }

    public void invalidateCurrentIteratedTupleUsage() {
        ++this.currentIteratedTupleUsageValidity;
    }

    public void validateCurrentIteratedTupleUsage() {
        --this.currentIteratedTupleUsageValidity;
    }

    public GFTupleEvaluationFrame pushEvaluatedTuple(List<OlapMemberOrigin> origins, OlapTuple tuple) {
        GFTupleEvaluationFrame res = this.pushEvaluatedTuple(origins, tuple, null);
        return res;
    }

    public GFTupleEvaluationFrame pushEvaluatedTuple(List<OlapMemberOrigin> origins, OlapTuple tuple, @Nullable OlapCalculatedMember calcMember) {
        boolean inCalcMemberEvaluation = this.isInCalcMemberEvaluation(calcMember);
        GFTupleEvaluationFrame frame = new GFTupleEvaluationFrame(inCalcMemberEvaluation, origins, tuple, calcMember);
        return this.pushEvaluatedTuple(frame);
    }

    private GFTupleEvaluationFrame pushEvaluatedTuple(GFTupleEvaluationFrame frame) {
        this.tupleEvaluationFrames.push(frame);
        OlapCalculatedMember calcMember = frame.calcMember();
        if (calcMember != null) {
            this.assertNoCalcMemberCycle(calcMember);
        }
        return frame;
    }

    public void popEvaluatedTuple(GFTupleEvaluationFrame ref) {
        GFTupleEvaluationFrame frame = this.tupleEvaluationFrames.pop();
        if (ref != frame) {
            throw new RuntimeException("internal error: inconsistent tuple evaluation");
        }
    }

    public boolean isInCalcMemberEvaluation() {
        return this.isInCalcMemberEvaluation(null);
    }

    public boolean isInCalcMemberEvaluation(@Nullable OlapCalculatedMember calcMember) {
        if (calcMember != null) {
            return true;
        }
        if (this.miniTupleEvaluators != null && this.miniTupleEvaluators.isInCalcMemberEvaluation()) {
            return true;
        }
        if (!this.tupleEvaluationFrames.isEmpty()) {
            GFTupleEvaluationFrame frame = this.tupleEvaluationFrames.peek();
            return frame.isInCalcMemberEvaluation();
        }
        return false;
    }

    public GFMiniTupleEvaluator pushMiniTupleEvaluator(GFMiniTupleEvaluator evaluator) {
        GFMiniTupleEvaluator prev = this.miniTupleEvaluators;
        this.miniTupleEvaluators = evaluator;
        return prev;
    }

    public void popMiniTupleEvaluator(GFMiniTupleEvaluator evaluator) {
        this.miniTupleEvaluators = evaluator;
    }

    @Nullable
    public GFTupleEvaluationFrame pushMiniTupleAsEvaluatedTuple() {
        if (this.miniTupleEvaluators == null) {
            return null;
        }
        GFMiniTupleEvaluationFrame miniFrame = this.miniTupleEvaluators.peekMiniTupleFrame();
        if (miniFrame == null) {
            return null;
        }
        GFTupleEvaluationFrame frame = miniFrame.asTupleEvaluationFrame(this);
        return this.pushEvaluatedTuple(frame);
    }

    public void popMiniTupleAsEvaluatedTuple(@Nullable GFTupleEvaluationFrame ref) {
        if (ref == null) {
            return;
        }
        this.tupleEvaluationFrames.pop();
    }

    public void assertNoCalcMemberCycleX(OlapCalculatedMember cmember) {
        if (this.miniTupleEvaluators == null) {
            return;
        }
        int size = this.miniTupleEvaluators.miniTupleStackSizeR();
        if (size >= this.tupleEvaluationFrameMaxSize) {
            List<OlapCalculatedMember> cycle = this.computeCalcMemberCycleX();
            String errMessage = this.createCalcMemberCycleErrorMessage(cmember, cycle);
            throw new OlapCalcMemberStackOverflowEvaluationException((IOlapEvaluationExceptionContext)this, cycle, errMessage);
        }
    }

    public List<OlapCalculatedMember> computeCalcMemberCycleX() {
        ArrayList<OlapCalculatedMember> cycle = new ArrayList<OlapCalculatedMember>();
        if (this.miniTupleEvaluators != null) {
            this.miniTupleEvaluators.computeCalcMemberCycleR(cycle);
        }
        return cycle;
    }

    private void assertNoCalcMemberCycle(OlapCalculatedMember cmember) {
        if (this.tupleEvaluationFrames.size() >= this.tupleEvaluationFrameMaxSize) {
            List<OlapCalculatedMember> cycle = this.computeCalcMemberCycle();
            String errMessage = this.createCalcMemberCycleErrorMessage(cmember, cycle);
            throw new OlapCalcMemberStackOverflowEvaluationException((IOlapEvaluationExceptionContext)this, cycle, errMessage);
        }
    }

    private List<OlapCalculatedMember> computeCalcMemberCycle() {
        ArrayList<OlapCalculatedMember> cycle = new ArrayList<OlapCalculatedMember>();
        this.tupleEvaluationFrames.process(frame -> {
            if (frame.calcMember() != null) {
                if (cycle.contains(frame.calcMember())) {
                    cycle.add(frame.calcMember());
                    return false;
                }
                cycle.add(frame.calcMember());
            }
            return true;
        });
        return cycle;
    }

    private String createCalcMemberCycleErrorMessage(OlapCalculatedMember cmember, List<OlapCalculatedMember> cycle) {
        OlapNameContext nameContext = this.getNameContext();
        StringBuilder sb = new StringBuilder("Calculated member " + cmember.getUniqueName(nameContext) + " stack overflow (see icCube.calcMemberMaxEvaluationFrameStackSize XMLA property) detected at (");
        for (int cc = 0; cc < cycle.size(); ++cc) {
            OlapCalculatedMember calculatedMember = cycle.get(cc);
            if (cc > 0) {
                sb.append(" ");
            }
            sb.append(calculatedMember.getName(nameContext));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isDrillthroughActive() {
        return this.evalContext.isDrillthroughActive();
    }

    @Nullable
    public OlapTuple getCellTupleForDrillthrough() {
        return this.evalContext.getCellTupleForDrillthrough();
    }

    @Nullable
    public OlapCalculatedMember getCurrentCalcMemberForDrillthrough() {
        OlapCalculatedMember[] cMember = new OlapCalculatedMember[1];
        this.processMiniTupleEvaluationFrames(item -> {
            OlapCalculatedMember member = item.calcMember();
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        if (cMember[0] != null) {
            return cMember[0];
        }
        this.tupleEvaluationFrames.process(item -> {
            OlapCalculatedMember cm = item.calcMember();
            if (cm != null) {
                cMember[0] = cm;
                return false;
            }
            return true;
        });
        return cMember[0];
    }

    public void pushCurrentTupleForDrillthrough(GFFactsEvalTuple tuple) {
        this.currentTupleForDrillthrough.push(tuple);
    }

    public GFFactsEvalTuple popCurrentTupleForDrillthrough() {
        return this.currentTupleForDrillthrough.pop();
    }

    @Nullable
    private GFFactsEvalTuple peekCurrentTupleForDrillthrough() {
        if (this.currentTupleForDrillthrough.isEmpty()) {
            return null;
        }
        return this.currentTupleForDrillthrough.peek();
    }

    @Nullable
    public GFFactsEvalTuple getCurrentCalcMemberTupleForDrillthrough() {
        GFFactsEvalTuple tuple = this.peekCurrentTupleForDrillthrough();
        return tuple;
    }

    @Nullable
    public GFNode getCurrentCalcMemberInstrForDrillthrough() {
        if (this.getCurrentCalcMemberForDrillthrough() != null) {
            GFNode node = this.peekCurrentNode();
            return node;
        }
        return null;
    }

    public GFSetEvaluator createSetEvaluator(GFLambdaTupleEvaluator evaluator, OlapTuple lambdaTuple, OlapTuple iTuple, boolean noEmptyEvaluation) {
        this.assertWithTupleEvaluation();
        OlapTuple lambdaTupleI = this.completeLambdaTupleWithIteratedTuple(lambdaTuple, iTuple);
        GFEvalTuple evalTuple = this.setupEvalTuple(noEmptyEvaluation, false, lambdaTupleI);
        if (evalTuple.isFilteredOut()) {
            return new GFEmptySetEvaluator(this, evaluator);
        }
        OlapCalculatedMember calcMember = evalTuple.getHighestPriorityMember();
        if (calcMember != null) {
            throw new RuntimeException("internal error: unexpected calculated (complete) tuple " + String.valueOf(lambdaTuple));
        }
        if (iTuple.isMeasure() && !lambdaTuple.isMeasure()) {
            return new GFRawSetEvaluator(this, evaluator, lambdaTuple, noEmptyEvaluation);
        }
        GFFactsEvalTuple evalTupleF = (GFFactsEvalTuple)evalTuple;
        OlapMeasureMember measure = evalTupleF.getMeasure();
        OlapAggregationType aggrType = measure.getHierarchyAggregationType();
        if (aggrType.isRollupHierarchyRequired()) {
            return new GFRawSetEvaluator(this, evaluator, lambdaTuple, noEmptyEvaluation);
        }
        if (this.isSetupAggregationTypeOn()) {
            this.setupAggregationType(measure);
        }
        GFFactsEvalTuple tuple = this.createSetEvaluatorTuple(evalTupleF, lambdaTuple, iTuple);
        OlapBitSet tupleD = this.createSetEvaluatorTupleD(lambdaTuple, iTuple);
        GFSetEvaluator evaluatorS = M_ClusterTupleAggregator.createSetEvaluator(this, evaluator, lambdaTuple, tuple, tupleD);
        return evaluatorS;
    }

    private GFFactsEvalTuple createSetEvaluatorTuple(GFFactsEvalTuple evalTuple, OlapTuple lambdaTuple, IOlapMembers iTuple) {
        OlapTupleDimensionality lambdaTupleDimensionality = lambdaTuple.getTupleDimensionality();
        int count = iTuple.getMemberCount();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember iMember = iTuple.getMember(ii);
            OlapHierarchy iHierarchy = iMember.getHierarchy();
            if (iHierarchy.isMeasures() || lambdaTupleDimensionality.isIn(iHierarchy)) continue;
            evalTuple = evalTuple.replaceMemberForSetEvaluation(iMember, iHierarchy.getAllMember4Facts());
        }
        return evalTuple;
    }

    public OlapBitSet createSetEvaluatorTupleD(OlapTuple lambdaTuple, IOlapMembers iTuple) {
        OlapBitSet hierarchies = new OlapBitSet();
        OlapTupleDimensionality lambdaTupleDimensionality = lambdaTuple.getTupleDimensionality();
        int count = iTuple.getMemberCount();
        for (int ii = 0; ii < count; ++ii) {
            OlapMember iMember = iTuple.getMember(ii);
            OlapHierarchy iHierarchy = iMember.getHierarchy();
            if (iHierarchy.isMeasures() || lambdaTupleDimensionality.isIn(iHierarchy)) continue;
            hierarchies.set(iHierarchy.getTupleDimensionalityIndex());
        }
        return hierarchies;
    }

    public OlapScalarEntity toValue(GFTupleEvaluator evaluator, OlapEntity entity) {
        if (!entity.isToValueApplicable(this, evaluator)) {
            throw new OlapEvaluationException(this, OlapErrorCode.SCALAR_ENTITY_TYPE_MISMATCH, new Serializable[]{entity.getFriendlyTypeName()});
        }
        OlapScalarEntity res = entity.toValue(this, evaluator);
        return res;
    }

    public OlapScalarEntity isEmptyValue(GFTupleEvaluator evaluator, OlapTuple tuple) {
        if (tuple.isFilteredOut()) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapScalarEntity isEmpty = evaluator.getValueForNonEmpty(this, tuple);
        return isEmpty;
    }

    public OlapTuple completeLambdaTupleWithIteratedTuple(OlapTuple lambdaTuple, IOlapMembers iTuple) {
        OlapHierarchy hierarchy;
        OlapMember member;
        int ii;
        OlapTupleDimensionality lambdaTupleDimensionality = lambdaTuple.getTupleDimensionality();
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        OlapBitSet hierarchies = new OlapBitSet();
        int count = lambdaTuple.getMemberCount();
        for (ii = 0; ii < count; ++ii) {
            member = lambdaTuple.getMember(ii);
            hierarchy = member.getHierarchy();
            members.add(member);
            hierarchies.set(hierarchy.getTupleDimensionalityIndex());
        }
        count = iTuple.getMemberCount();
        for (ii = 0; ii < count; ++ii) {
            member = iTuple.getMember(ii);
            hierarchy = member.getHierarchy();
            if (lambdaTupleDimensionality.isIn(hierarchy)) continue;
            members.add(member);
            hierarchies.set(hierarchy.getTupleDimensionalityIndex());
        }
        OlapTuple tuple_ = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)this, this.sContext.getTupleDimensionalityCache(), null, members);
        return tuple_;
    }

    public OlapScalarEntity computeCurrentTuple(GFTupleEvaluator evaluator) {
        if (this.tupleEvaluationFrames.isEmpty()) {
            OlapScalarEntity res = evaluator.getValue(this, OlapBlankTuple.INSTANCE, false);
            return res;
        }
        OlapCalculatedMember calcMember = this.getCurrentCalcMember();
        if (calcMember == null) {
            OlapScalarEntity res = evaluator.getValue(this, OlapBlankTuple.INSTANCE, false);
            return res;
        }
        GFEvalTuple evalTuple = this.setupEvalTuple(false, false, OlapBlankTuple.INSTANCE);
        if (evalTuple.isFilteredOut()) {
            return OlapEmptyEntity.INSTANCE;
        }
        ArrayList<OlapMember> ctMembers = new ArrayList<OlapMember>();
        for (int ii = 0; ii < evalTuple.getMemberCount(); ++ii) {
            OlapMember member = evalTuple.getMember(ii);
            OlapHierarchy hierarchy = member.getHierarchy();
            OlapMember cMember = this.getNullableCurrentMember(hierarchy);
            if ((OlapMember.equal(cMember, calcMember) || cMember == null) && (cMember = this.getNullableDefaultMember(hierarchy)) == null) {
                throw new OlapEvaluationException(this, OlapErrorCode.HIERARCHY_MISSING_DEFAULT_MEMBER, new Serializable[]{hierarchy.getUniqueName(this.getNameContext())});
            }
            ctMembers.add(cMember);
        }
        OlapTuple cTuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)this, this.getTupleDimensionalityCache(), null, ctMembers);
        OlapScalarEntity res = evaluator.getValue(this, cTuple, false);
        return res;
    }

    private OlapCalculatedMember getCurrentCalcMember() {
        OlapCalculatedMember[] cMember = new OlapCalculatedMember[1];
        this.processMiniTupleEvaluationFrames(item -> {
            OlapCalculatedMember member = item.calcMember();
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        if (cMember[0] != null) {
            return cMember[0];
        }
        this.tupleEvaluationFrames.process(item -> {
            OlapCalculatedMember member = item.calcMember();
            if (member != null) {
                cMember[0] = member;
                return false;
            }
            return true;
        });
        return cMember[0];
    }

    public void assertWithTupleEvaluation() {
        if (!this.sContext.isWithEval()) {
            throw new OlapEvaluationException(this, OlapErrorCode.FACTLESS_CUBE_EVAL_TUPLE_EX, new Serializable[]{this.sContext.getUsage()});
        }
        OlapCube cube = this.sContext.getCube().getUnderlying();
        if (cube.isFactless()) {
            throw new OlapEvaluationException(this, OlapErrorCode.FACTLESS_CUBE_EVAL_TUPLE_EX, new Serializable[]{this.sContext.getUsage()});
        }
    }

    public OlapScalarEntity computeFactsTupleFromFacts(GFFactsEvalTuple evalTuple) {
        OlapScalarEntity res = OlapFactsRollupSolver.evalTuple(this, evalTuple);
        return res;
    }

    public void setupContextForMeasure(GFFactsEvalTuple evalTuple) {
        OlapMeasureMember measure = evalTuple.getMeasure();
        if (evalTuple.isFromAxis()) {
            this.setCellMeasure(measure);
        } else {
            this.setCellPropertyValueForCalcMember(measure);
        }
        if (this.isSetupAggregationTypeOn()) {
            this.setupAggregationType(measure);
        }
    }

    protected boolean isCalcMemberContext() {
        return false;
    }

    private void completeWithStackMember(List<OlapMember> members, OlapBitSet membersDim, GFMiniTupleEvaluationFrame stackTuple, OlapMember stackMember, OlapHierarchy stackMemberHierarchy) {
        if (!membersDim.get(stackMemberHierarchy.getTupleDimensionalityIndex())) {
            OlapNonScalarEntity stackMembers = stackTuple.getMembers(stackMemberHierarchy);
            if (stackMembers instanceof OlapListTupleSet) {
                OlapListTupleSet stackMembers_ = (OlapListTupleSet)stackMembers;
                for (int kk = 0; kk < stackMembers_.size(); ++kk) {
                    Object stackTuple_ = stackMembers_.getItem(kk);
                    if (((OlapTuple)stackTuple_).getMemberCount() != 1) {
                        throw new RuntimeException("internal error: inconsistent tuple: " + String.valueOf(stackTuple));
                    }
                    members.add(((OlapTuple)stackTuple_).getMember(0));
                }
            } else if (stackMembers instanceof OlapMember) {
                members.add(stackMember);
            } else {
                throw new RuntimeException("internal error: inconsistent tuple: " + String.valueOf(stackTuple));
            }
            membersDim.set(stackMemberHierarchy.getTupleDimensionalityIndex());
        }
    }

    private void completeWithStackMember(List<OlapMember> members, OlapBitSet membersDim, OlapTuple stackTuple, OlapMember stackMember, OlapHierarchy stackMemberHierarchy) {
        if (!membersDim.get(stackMemberHierarchy.getTupleDimensionalityIndex())) {
            OlapNonScalarEntity stackMembers = stackTuple.getMembers(stackMemberHierarchy);
            if (stackMembers instanceof OlapListTupleSet) {
                OlapListTupleSet stackMembers_ = (OlapListTupleSet)stackMembers;
                for (int kk = 0; kk < stackMembers_.size(); ++kk) {
                    Object stackTuple_ = stackMembers_.getItem(kk);
                    if (((OlapTuple)stackTuple_).getMemberCount() != 1) {
                        throw new RuntimeException("internal error: inconsistent tuple: " + String.valueOf(stackTuple));
                    }
                    members.add(((OlapTuple)stackTuple_).getMember(0));
                }
            } else if (stackMembers instanceof OlapMember) {
                members.add(stackMember);
            } else {
                throw new RuntimeException("internal error: inconsistent tuple: " + String.valueOf(stackTuple));
            }
            membersDim.set(stackMemberHierarchy.getTupleDimensionalityIndex());
        }
    }

    public GFEvalTuple setupEvalTuple(boolean noEmptyEvaluation, boolean fromAxis, OlapTuple tuple) {
        OlapMemberOrigin[] tupleOrigins = null;
        OlapMemberOrigin tupleOrigin = fromAxis ? OlapMemberOrigin.AXIS : (this.isCalcMemberContext() ? OlapMemberOrigin.CALC_MEMBER : OlapMemberOrigin.OTHER);
        GFEvalTupleBuilder builder = new GFEvalTupleBuilder(this, noEmptyEvaluation, tupleOrigin, tupleOrigins, tuple);
        GFEvalTuple eTuple = builder.build(false);
        return eTuple;
    }

    @Nullable
    public OlapChainTupleFilter createChainTupleFilterForExisting() {
        OlapTuple tuple = this.completeTupleForExisting();
        OlapCurrentTupleFilter currentTupleFilterForExisting = tuple == null ? null : new OlapCurrentTupleFilter(this.getStatementExecutionContext().getTupleDimensionalityCache(), tuple);
        return this.evalContext.createChainTupleFilterForExisting(currentTupleFilterForExisting);
    }

    public S_RequestSubCubeDef getOrCreateFactsSubCube(OlapSubCubeEntity entity) {
        S_RequestSubCubeDef subCubeDef = this.sContext.getOrCreateFactsSubCube(entity);
        return subCubeDef;
    }

    public void pushFactsSubCube(S_RequestSubCubeDef factsSubCube) {
        this.factsSubCubes.push(factsSubCube);
    }

    public void popFactsSubCube(S_RequestSubCubeDef factsSubCube) {
        if (factsSubCube != this.factsSubCubes.pop()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    @Nullable
    public List<S_RequestSubCubeRef> getFactsSubCubes() {
        if (this.factsSubCubes.isEmpty()) {
            return null;
        }
        ArrayList<S_RequestSubCubeRef> subCubeRefs = new ArrayList<S_RequestSubCubeRef>(this.factsSubCubes.size());
        this.factsSubCubes.process(subCube -> {
            S_RequestSubCubeRef subCubeRef = subCube.getRef();
            subCubeRefs.add(subCubeRef);
            return true;
        });
        return subCubeRefs;
    }

    protected void clearCurrentInstruction() {
        this.currentInstruction = null;
    }

    public OlapPreparedInstr pushCurrentInstruction(@Nullable OlapPreparedInstr instr) {
        OlapPreparedInstr prev = this.currentInstruction;
        this.currentInstruction = instr;
        return prev;
    }

    public void popCurrentInstruction(OlapPreparedInstr instr) {
        this.currentInstruction = instr;
    }

    @Nullable
    public OlapPreparedInstr peekCurrentInstruction() {
        return this.currentInstruction;
    }

    protected void clearCurrentNode() {
        this.currentNode = null;
    }

    @Nullable
    public GFNode pushCurrentNode(@Nullable GFNode node) {
        GFNode prev = this.currentNode;
        this.currentNode = node;
        return prev;
    }

    public void popCurrentNode(@Nullable GFNode node) {
        this.currentNode = node;
    }

    @Nullable
    public GFNode peekCurrentNode() {
        return this.currentNode;
    }

    public N_FactPageAggregationHelper factPageAggregationHelper() {
        N_FactPageAggregationHelper dtContext = this.sContext.factPageAggregationHelper(this);
        return dtContext;
    }

    @Override
    public void clearReferences() {
        this.references.clear();
    }

    @Override
    public OlapPreparedInstrRef getReference(OlapInstr body) {
        OlapPreparedInstrRef ref = this.references.get(body);
        return ref;
    }

    @Override
    public OlapPreparedInstrRef setReference(OlapInstr body) {
        OlapPreparedInstrRef ref = new OlapPreparedInstrRef();
        if (this.references.put(body, ref) != null) {
            throw new RuntimeException("internal error: duplicated referenced instr.");
        }
        return ref;
    }

    public void freezeStats() {
        this.statsFrozen = true;
    }

    public void unfreezeStats() {
        this.statsFrozen = false;
    }

    public boolean isStatsFrozen() {
        return this.statsFrozen;
    }

    public boolean isJavaMdxNativesActivated() {
        OlapEngineRequestContext context = this.getRequestContext();
        return context.isJavaMdxNativesActivated();
    }

    public List<OlapMember> getSliceSubselectDefinedMembers(OlapHierarchy hierarchy) {
        List<OlapMember> members;
        OlapSlicerFilter slicerTupleFilter = this.getSlicerTupleFilter();
        if (slicerTupleFilter != null && !(members = slicerTupleFilter.getDefinedMembers(hierarchy)).isEmpty()) {
            return members;
        }
        OlapSubSelectTupleFilter subSelectTupleFilter = this.evalContext.getSubSelectTupleFilter();
        if (subSelectTupleFilter != null) {
            return subSelectTupleFilter.getDefinedMembers(hierarchy);
        }
        return Collections.emptyList();
    }

    public S_NonEmptyBehaviorFactoryContext createNonEmptyBehaviorContext(OlapTupleDimensionality dimensionality) {
        return this.sContext.createNonEmptyBehaviorContext(dimensionality);
    }

    public void pushCurrentValue(OlapScalarEntity<?> value) {
        this.currentValue = value.asConstant();
    }

    public void popCurrentValue() {
        this.currentValue = null;
    }

    public OlapScalarEntity<?> getCurrentValue() {
        return this.currentValue;
    }

    @Nullable
    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(OlapTuple tuple, OlapMeasureMember measure) {
        IOlapFactMeasureGroupManagerForEval facts = measure.getFactManager();
        return facts.getFastNonEmptyFilter(this, tuple);
    }

    private static class ConstDeclaredSnapshot
    implements IOlapLambdaProcessingEnabled<ConstDeclaredSnapshot> {
        private final OlapConstDeclaredFunction function;
        private final OlapStack<OlapAsNamedSetPreparedInstr> asNamedSets;
        private final OlapStack<OlapTupleSet> asNamedSets_;
        private final OlapStack<S_RequestSubCubeDef> factsSubCubes;
        private final OlapStack<OlapIteratedTuple> iteratedTuples;
        private final OlapStack<GFTupleEvaluationFrame> tupleEvaluationFrames;
        private final GFMiniTupleEvaluator miniTupleEvaluators;
        private final OlapStack<OlapDeclaredFunctionCallFrame> declaredFunctionCallFrames;

        public ConstDeclaredSnapshot(GFContext context, OlapConstDeclaredFunction function) {
            this.function = function;
            this.asNamedSets = context.asNamedSets.saveEx();
            context.asNamedSets.clear();
            this.asNamedSets_ = context.asNamedSets_.saveEx();
            context.asNamedSets_.clear();
            this.factsSubCubes = context.factsSubCubes.saveEx();
            context.factsSubCubes.clear();
            this.iteratedTuples = context.iteratedTuples.saveEx();
            context.iteratedTuples.clear();
            this.tupleEvaluationFrames = context.tupleEvaluationFrames.saveEx();
            context.tupleEvaluationFrames.clear();
            this.miniTupleEvaluators = context.miniTupleEvaluators;
            context.miniTupleEvaluators = null;
            this.declaredFunctionCallFrames = context.declaredFunctionCallFrames.saveEx();
            context.declaredFunctionCallFrames.clear();
        }

        private ConstDeclaredSnapshot(OlapConstDeclaredFunction function, OlapStack<OlapAsNamedSetPreparedInstr> asNamedSets, OlapStack<OlapTupleSet> asNamedSets_) {
            this.function = function;
            this.asNamedSets = asNamedSets;
            this.asNamedSets_ = asNamedSets_;
            this.factsSubCubes = null;
            this.iteratedTuples = null;
            this.tupleEvaluationFrames = null;
            this.miniTupleEvaluators = null;
            this.declaredFunctionCallFrames = null;
        }

        @Override
        public ConstDeclaredSnapshot forkForParallelLambdaProcessing() {
            OlapStack<OlapAsNamedSetPreparedInstr> asNamedSetsF = new OlapStack<OlapAsNamedSetPreparedInstr>();
            OlapStack<OlapTupleSet> asNamedSetsF_ = new OlapStack<OlapTupleSet>();
            asNamedSetsF.setupForParallelLambdaProcessing(this.asNamedSets);
            asNamedSetsF_.setupForParallelLambdaProcessing(this.asNamedSets_);
            return new ConstDeclaredSnapshot(this.function, asNamedSetsF, asNamedSetsF_);
        }

        public void restoreTo(GFContext context) {
            context.asNamedSets.restore(this.asNamedSets);
            context.asNamedSets_.restore(this.asNamedSets_);
            context.factsSubCubes.restore(this.factsSubCubes);
            context.iteratedTuples.restore(this.iteratedTuples);
            context.tupleEvaluationFrames.restore(this.tupleEvaluationFrames);
            context.miniTupleEvaluators = this.miniTupleEvaluators;
            context.declaredFunctionCallFrames.restore(this.declaredFunctionCallFrames);
        }

        public String getFunction() {
            return this.function.getName();
        }
    }

    public static class Mark {
        @Nullable
        private final OlapAsNamedSetPreparedInstr asNamedSetsMark;
        @Nullable
        private final OlapTupleSet asNamedSetsMark_;
        @Nullable
        private final OlapIteratedTuple iteratedTuplesMark;
        @Nullable
        private final GFTupleEvaluationFrame tupleEvaluationFramesMark;
        @Nullable
        private final GFMiniTupleEvaluator miniTupleEvaluatorsMark;
        @Nullable
        private final GFMiniTupleEvaluationFrame miniTupleEvaluatorsMark_;
        @Nullable
        private final OlapDeclaredFunctionCallFrame declaredFunctionCallFramesMark;

        public Mark(@Nullable OlapAsNamedSetPreparedInstr asNamedSetsMark, @Nullable OlapTupleSet asNamedSetsMark_, @Nullable OlapIteratedTuple iteratedTuplesMark, @Nullable GFTupleEvaluationFrame tupleEvaluationFramesMark, @Nullable GFMiniTupleEvaluator miniTupleEvaluatorsMark, @Nullable GFMiniTupleEvaluationFrame miniTupleEvaluatorsMark_, @Nullable OlapDeclaredFunctionCallFrame declaredFunctionCallFramesMark) {
            this.asNamedSetsMark = asNamedSetsMark;
            this.asNamedSetsMark_ = asNamedSetsMark_;
            this.iteratedTuplesMark = iteratedTuplesMark;
            this.tupleEvaluationFramesMark = tupleEvaluationFramesMark;
            this.miniTupleEvaluatorsMark = miniTupleEvaluatorsMark;
            this.miniTupleEvaluatorsMark_ = miniTupleEvaluatorsMark_;
            this.declaredFunctionCallFramesMark = declaredFunctionCallFramesMark;
        }
    }
}

