/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context;

import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapAsNamedSetPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsCluster;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GFConstrainedEvalContext
extends GFContext {
    private final GFContext decorated;
    private final OlapFunction function;

    public GFConstrainedEvalContext(GFContext decorated, OlapFunction function) {
        super(decorated.getEvalContext().createConstrainedExecutionContext(function));
        this.decorated = decorated;
        this.function = function;
    }

    @Override
    public boolean isConstrained() {
        return true;
    }

    @Override
    public <T> T onConstrainedViolation() {
        throw new OlapFunctionEvaluationException((IOlapEvaluationExceptionContext)this.decorated, this.function.getName(), OlapErrorCode.CONSTRAINED_VIOLATED, new Serializable[0]);
    }

    @Override
    public GFConstrainedEvalContext createConstrainedContext(OlapFunction function) {
        throw new RuntimeException("internal error: inconsistent CONSTRAINED context usage for function (" + function.getName() + ")");
    }

    @Override
    public String getUserName() {
        return (String)this.onConstrainedViolation();
    }

    @Override
    public OlapEntityIdentifier compileIdentifier(String name) throws CdMdxScannerException, MdxParserException {
        return (OlapEntityIdentifier)this.onConstrainedViolation();
    }

    @Override
    public OlapMemberPropertyEvalContext getMemberPropertyEvalContext() {
        return (OlapMemberPropertyEvalContext)this.onConstrainedViolation();
    }

    @Override
    public int getHierarchyCount() {
        return (Integer)this.onConstrainedViolation();
    }

    @Override
    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy() {
        return (OlapHierarchy)this.onConstrainedViolation();
    }

    @Override
    public List<OlapDimension> getAllDimensions() {
        return (List)this.onConstrainedViolation();
    }

    @Override
    public OlapNonScalarEntity lookupHierarchy(int position) {
        return (OlapNonScalarEntity)this.onConstrainedViolation();
    }

    @Override
    @Nullable
    public OlapEntity lookupDeclaredFunctionArgument(int index) {
        return OlapNullEntity.INSTANCE;
    }

    @Override
    public List<OlapMember> getAllCalculatedMembers() {
        return (List)this.onConstrainedViolation();
    }

    @Override
    @Nullable
    public OlapNonScalarEntity getNullableCurrentMember(OlapHierarchy hierarchy, int idx) {
        return (OlapNonScalarEntity)this.onConstrainedViolation();
    }

    @Override
    @Nullable
    public OlapNonScalarEntity getNullableContextMember(OlapHierarchy hierarchy, int idx) {
        return (OlapNonScalarEntity)this.onConstrainedViolation();
    }

    @Override
    @Nullable
    public OlapNonScalarEntity getContextMembers(OlapHierarchy hierarchy) {
        return (OlapNonScalarEntity)this.onConstrainedViolation();
    }

    @Override
    public OlapTupleSet<OlapTuple> getAxis(int number) {
        return (OlapTupleSet)this.onConstrainedViolation();
    }

    @Override
    public void addVisualTotalsCluster(OlapVisualTotalsCluster cluster) {
        this.onConstrainedViolation();
    }

    @Override
    public void pushAsNameSet(OlapAsNamedSetPreparedInstr instr) {
    }

    @Override
    public Object pushFunctionCallFrame(String function, @Nullable OlapEntity[] args) {
        return this.onConstrainedViolation();
    }

    @Override
    public void popFunctionCallFrame(Object ref) {
        this.onConstrainedViolation();
    }

    @Override
    @Nullable
    public GFContext.Mark mark() {
        return null;
    }
}

