/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr.gf.context;

import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringSyntax;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapMdxCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapLanguageIdentifierNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapMemberOrigin;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellPropertiesTupleEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStatementTupleEvaluator;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class GFCellPropertyEvalContext
extends GFContext {
    private final GFCellEvalContext context;
    private final List<OlapCellProperty> requestedCellProperties;
    private final OlapTuple cellTuple;
    private final OlapEvalResultCellValue cellValue;
    @Nullable
    private final OlapMember cellMeasure;
    private final int cellMeasureVectorPos;

    public GFCellPropertyEvalContext(GFCellEvalContext context, List<OlapCellProperty> requestedCellProperties, OlapEvalResultCellValue cellValue) {
        super(context.getEvalContext());
        this.context = context;
        this.requestedCellProperties = requestedCellProperties;
        this.cellTuple = context.getCellTuple();
        this.cellValue = cellValue;
        this.cellMeasure = context.getCellMeasure();
        this.cellMeasureVectorPos = context.getCellMeasureVectorPos();
        int count = this.cellTuple.getMemberCount();
        ArrayList<OlapMemberOrigin> origins = new ArrayList<OlapMemberOrigin>(count);
        for (int ii = 0; ii < count; ++ii) {
            origins.add(OlapMemberOrigin.AXIS);
        }
        this.pushEvaluatedTuple(origins, this.cellTuple);
    }

    @Override
    public boolean isForCellPropertyExpression() {
        return true;
    }

    public List<OlapCellProperty> getRequestedCellProperties() {
        return this.requestedCellProperties;
    }

    public OlapFormatStringSyntax getDefaultFormatStringSyntax() {
        OlapProperties requestProperties = this.context.getRequestProperties();
        OlapFormatStringSyntax res = requestProperties.getDefaultFormatStringSyntax();
        return res;
    }

    @Nullable
    public OlapCellPropertyValue getCellPropertyValue(OlapCellProperty property) {
        if (this.cellMeasure == null) {
            return null;
        }
        OlapCellPropertyValue value = this.cellMeasure.getCellPropertyValue(property);
        if (value != null) {
            return value;
        }
        OlapCellPropertyValue res = this.context.getCellPropertyValueForCalcMember(property, this.cellMeasureVectorPos);
        return res;
    }

    public Locale getFormattedValueLocale(@Nullable OlapScalarEntity cellValue) {
        Locale locale = this.doGetFormattedValueLocale(cellValue);
        if (cellValue != null && cellValue.isFormattingNumeric()) {
            locale = this.context.getLocaleForFormattingNumeric(locale);
        }
        return locale;
    }

    private Locale doGetFormattedValueLocale(@Nullable OlapScalarEntity cellValue) {
        OlapCellPropertyValue value = this.getCellPropertyValue(OlapIntrinsicCellProperties.LANGUAGE);
        OlapMdxStatementExecutionContext sContext = this.getStatementExecutionContext();
        if (value == null) {
            return sContext.getLocale();
        }
        OlapScalarEntity languageValue = value.eval(this, cellValue);
        if (languageValue == null) {
            return sContext.getLocale();
        }
        if (languageValue.isMdxNull()) {
            return sContext.getLocale();
        }
        if (!(languageValue instanceof OlapLanguageIdentifierNumericEntity)) {
            throw new OlapEvaluationException(this, OlapErrorCode.LANGUAGE_TYPE_MISMATCH, new Serializable[]{languageValue.getFriendlyTypeName()});
        }
        CdLanguageIdentifier language = ((OlapLanguageIdentifierNumericEntity)languageValue).getId();
        if (language == CdLanguageIdentifier.Neutral) {
            return sContext.getLocale();
        }
        Locale olapEngineLocale = this.getOlapEngineLocale();
        Locale locale = CdLanguageIdentifierHelper.toJavaLocale((Locale)olapEngineLocale, (CdLanguageIdentifier)language);
        if (locale == null) {
            return sContext.getLocale();
        }
        return locale;
    }

    public int getCellOrdinal() {
        return -1;
    }

    @Nullable
    public OlapScalarEntity getCellValueAsScalar() {
        return this.cellValue.getScalarValue();
    }

    public OlapTuple getCellTuple() {
        return this.cellTuple;
    }

    @Override
    public OlapEvalResultCellValue getCellValue() {
        return this.cellValue;
    }

    public OlapEntity evalProperty(OlapMdxCellPropertyValue property, GFNode expr) {
        GFStatementTupleEvaluator tupleEvaluator = this.sContext.getTupleEvaluator();
        OlapEntity res = expr.execute(this, new GFCellPropertiesTupleEvaluator(tupleEvaluator));
        return res;
    }
}

