/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstrTypeContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.Locale;

public abstract class OlapPreparedInstr<T extends OlapInstr> {
    protected final T instr;

    public OlapPreparedInstr(T instr) {
        this.instr = instr;
    }

    protected OlapPreparedInstr(OlapPreparedInstr<T> other) {
        this.instr = other.instr;
    }

    public OlapInstrLocationRange getLocationRange() {
        return ((OlapInstr)this.instr).getLocationRange();
    }

    public IOlapEvaluationExceptionContext createErrorContext() {
        return ((OlapInstr)this.instr).createErrorContext(Locale.ENGLISH, OlapNameContext.DEFAULT_VALUES, false);
    }

    public String typeForError() {
        return ((OlapInstr)this.instr).typeForError();
    }

    protected boolean isDebugged() {
        return false;
    }

    public boolean isNullLiteral() {
        return false;
    }

    public boolean isTupleOrLiteral() {
        return this.isTuple() || this.isLiteral();
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isScalar(OlapPreparedInstrTypeContext ctxt) {
        return this.isTupleOrLiteral();
    }

    public OlapEntity eval(GFContext context, boolean markedForValueEvaluation) {
        OlapInstrExecListener listener = context.getInstrExecListener();
        if (listener != null && this.isDebugged()) {
            return this.doEvalAndListen(context, markedForValueEvaluation, listener);
        }
        return this.doEval(context, markedForValueEvaluation);
    }

    private OlapEntity doEvalAndListen(GFContext context, boolean markedForValueEvaluation, OlapInstrExecListener listener) {
        listener.beginPreparedInstrExecute(this);
        try {
            OlapEntity entity = this.doEval(context, markedForValueEvaluation);
            listener.endPreparedInstrExecute(this, entity);
            return entity;
        }
        catch (RuntimeException ex) {
            listener.endPreparedInstrExecuteOnError(this, ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapEntity doEval(GFContext context, boolean markedForValueEvaluation) {
        OlapPreparedInstr prev = context.pushCurrentInstruction(this);
        try {
            OlapEntity res;
            GFNode tree = this.buildGFTree(new GFNodeBuildContext(context.hasInstrExecListener()), markedForValueEvaluation);
            GFTupleEvaluator evaluator = tree.getTupleEvaluator(context);
            OlapEntity olapEntity = res = tree.execute(context, evaluator);
            return olapEntity;
        }
        finally {
            context.popCurrentInstruction(prev);
        }
    }

    public abstract GFNode buildGFTree(GFNodeBuildContext var1, boolean var2);

    public boolean isQuickToMemberApplicable(IOlapPrepareContext context) {
        return false;
    }

    public OlapMember toQuickNullableMember(IOlapPrepareContext context) {
        throw new CdDoNotCallMeProgrammingException();
    }

    public boolean isQuickToTupleApplicable(IOlapPrepareContext context) {
        return false;
    }

    public OlapTuple toQuickTuple(IOlapPrepareContext context) {
        throw new CdDoNotCallMeProgrammingException();
    }

    public boolean isQuickToListSetApplicable(IOlapPrepareContext context) {
        return false;
    }

    public OlapListTupleSet toQuickListSet(IOlapPrepareContext context) {
        throw new CdDoNotCallMeProgrammingException();
    }

    public String toStringForDebugger() {
        return "(P) " + ((OlapInstr)this.instr).toStringForDebugger();
    }
}

