/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFLiteralNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.literal.OlapLiteralInstr;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import crazydev.iccube.olap.eval.operator.unary.OlapUnaryOperator;
import org.jetbrains.annotations.Nullable;

public class OlapLiteralPreparedInstr
extends OlapPreparedInstr<OlapLiteralInstr> {
    @Nullable
    private final OlapEntity valueAsNull;
    @Nullable
    private final OlapScalarEntity value;

    public OlapLiteralPreparedInstr(OlapLiteralInstr instr, OlapEntity value) {
        super(instr);
        if (value.isMdxNull()) {
            this.valueAsNull = value.asConstant();
            this.value = null;
        } else if (value instanceof OlapScalarEntity) {
            this.valueAsNull = null;
            this.value = ((OlapScalarEntity)value).asConstant();
        } else {
            throw new RuntimeException("internal error: inconsistent literal setup [" + value.getFriendlyTypeName() + "]");
        }
    }

    private OlapLiteralPreparedInstr(OlapLiteralPreparedInstr other, OlapEntity value) {
        super(other);
        if (value.isMdxNull()) {
            this.valueAsNull = value.asConstant();
            this.value = null;
        } else if (value instanceof OlapScalarEntity) {
            this.valueAsNull = null;
            this.value = ((OlapScalarEntity)value).asConstant();
        } else {
            throw new RuntimeException("internal error: inconsistent literal setup [" + value.getFriendlyTypeName() + "]");
        }
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isNullLiteral() {
        return this.valueAsNull instanceof OlapNullEntity;
    }

    public boolean isNumeric() {
        return this.valueAsNull != null || this.value instanceof OlapNumericEntity;
    }

    public OlapPreparedInstr asUnaryOperation(OlapUnaryOperator operator) {
        if (!this.isNumeric()) {
            throw new RuntimeException("internal error: inconsistent non-numeric literal usage");
        }
        switch (operator.getName()) {
            case UNARY_PLUS: {
                return this;
            }
            case UNARY_MINUS: {
                if (this.valueAsNull != null) {
                    return this;
                }
                return new OlapLiteralPreparedInstr(this, (OlapEntity)OlapScalarOperators.unaryMinus(this.value));
            }
            case NOT: {
                if (this.valueAsNull != null) {
                    return new OlapLiteralPreparedInstr(this, (OlapEntity)OlapBooleanEntity.TRUE);
                }
                boolean res = !OlapScalarOperators.isTrue(this.value);
                return new OlapLiteralPreparedInstr(this, (OlapEntity)OlapBooleanEntity.value(res));
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        if (this.valueAsNull != null) {
            return new GFLiteralNode(markedForValueEvaluation, this.instr, this.valueAsNull);
        }
        return new GFLiteralNode(markedForValueEvaluation, this.instr, this.value);
    }
}

