/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.iccube.olap.eval.execinstr.OlapConditionalPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstrTypeContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIifNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.scase.OlapIifInstr;

public class OlapIifPreparedInstr
extends OlapConditionalPreparedInstr<OlapIifInstr> {
    private final OlapPreparedInstr condition;
    private final OlapPreparedInstr then;
    private final OlapPreparedInstr otherwise;

    public OlapIifPreparedInstr(OlapIifInstr instr, OlapPreparedInstr condition, OlapPreparedInstr then, OlapPreparedInstr otherwise) {
        super(instr);
        this.condition = condition;
        this.then = then;
        this.otherwise = otherwise;
    }

    @Override
    public boolean isScalar(OlapPreparedInstrTypeContext ctxt) {
        boolean isThenToValue = this.then.isScalar(ctxt);
        boolean isOtherwiseToValue = this.otherwise.isScalar(ctxt);
        return isThenToValue && isOtherwiseToValue;
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        GFNode conditionGF = this.condition.buildGFTree(context, true);
        GFNode thenGF = this.then.buildGFTree(context, markedForValueEvaluation);
        GFNode otherwiseGF = this.otherwise.buildGFTree(context, markedForValueEvaluation);
        return new GFIifNode(markedForValueEvaluation, this.instr, conditionGF, thenGF, otherwiseGF);
    }
}

