/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstrTypeContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFFunctionCallNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import org.jetbrains.annotations.NotNull;

public class OlapFunctionCallPreparedInstr
extends OlapPreparedInstr {
    protected final OlapFunctionCallInstr functionCallInstr;
    protected final OlapInstr[] functionCallArgInstrs;
    protected final OlapFunction function;
    protected final OlapPreparedInstr[] args;

    public OlapFunctionCallPreparedInstr(OlapFunctionCallInstr functionCallInstr, OlapInstr[] functionCallArgInstrs, OlapFunction function, OlapPreparedInstr[] args) {
        super(functionCallInstr);
        this.functionCallInstr = functionCallInstr;
        this.functionCallArgInstrs = functionCallArgInstrs;
        this.function = function;
        this.args = args;
    }

    @Override
    public boolean isScalar(OlapPreparedInstrTypeContext ctxt) {
        return this.function.isScalar();
    }

    @NotNull
    protected GFNode[] createArgsGFTree(GFNodeBuildContext context) {
        OlapFunctionArgs argsInfo = this.function.getArgsInfo();
        GFNode[] nArgs = new GFNode[this.args.length];
        for (int ii = 0; ii < nArgs.length; ++ii) {
            GFNode nArg;
            OlapFunctionArgumentType argType = argsInfo.getType(ii);
            OlapPreparedInstr arg = this.args[ii];
            nArgs[ii] = nArg = this.createArgGFTree(context, ii, argType, arg);
        }
        return nArgs;
    }

    protected GFNode createArgGFTree(GFNodeBuildContext context, int argNb, OlapFunctionArgumentType argType, OlapPreparedInstr arg) {
        return arg.buildGFTree(context, argType != null && argType.isValuable());
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        GFNode[] nArgs = this.createArgsGFTree(context);
        return new GFFunctionCallNode<OlapFunction>(markedForValueEvaluation, this.functionCallInstr, this.functionCallArgInstrs, this.function, nArgs);
    }
}

