/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.execinstr;

import crazydev.iccube.olap.entity.OlapCubeEntity;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.set.OlapAsNamedSetReference;
import crazydev.iccube.olap.entity.set.OlapIteratorTupleSet;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapNeutralTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFCubeEntityNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFDimensionNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFEmptyEntityNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFHierarchyNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFIteratorTupleSetNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFLevelNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFListTupleSetNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFMeasureGroupNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNeutralTupleSetNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNodeBuildContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNullEntityNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFStringNode;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import org.jetbrains.annotations.Nullable;

public class OlapEntityPreparedInstr
extends OlapPreparedInstr<OlapIdentifierInstr> {
    private final OlapIdentifierInstr idInstr;
    private final OlapEntity entity;

    public OlapEntityPreparedInstr(OlapIdentifierInstr instr, OlapEntity entity) {
        super(instr);
        this.idInstr = instr;
        this.entity = entity;
    }

    @Override
    public boolean isQuickToMemberApplicable(IOlapPrepareContext context) {
        return this.entity.isToMemberApplicable(context);
    }

    @Override
    @Nullable
    public OlapMember toQuickNullableMember(IOlapPrepareContext context) {
        return this.entity.toNullableMember(context);
    }

    @Override
    public boolean isQuickToTupleApplicable(IOlapPrepareContext context) {
        return this.entity.isToTupleApplicable(context);
    }

    @Override
    public OlapTuple toQuickTuple(IOlapPrepareContext context) {
        return this.entity.toTuple(context);
    }

    @Override
    public boolean isQuickToListSetApplicable(IOlapPrepareContext context) {
        if (this.entity instanceof OlapTuple || this.entity instanceof OlapHierarchy || this.entity instanceof OlapDimension) {
            OlapTupleSet<? extends OlapTuple> set = this.entity.toSet(context);
            return set instanceof OlapListTupleSet;
        }
        return this.entity.isMdxNull();
    }

    @Override
    public OlapListTupleSet toQuickListSet(IOlapPrepareContext context) {
        OlapTupleSet<? extends OlapTuple> set;
        if ((this.entity instanceof OlapTuple || this.entity instanceof OlapHierarchy || this.entity instanceof OlapDimension) && (set = this.entity.toSet(context)) instanceof OlapListTupleSet) {
            return (OlapListTupleSet)set;
        }
        if (this.entity.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        throw new RuntimeException("internal error: inconsistent entity-quick-set conversion");
    }

    @Override
    public GFNode buildGFTree(GFNodeBuildContext context, boolean markedForValueEvaluation) {
        if (this.entity instanceof OlapNullEntity) {
            return new GFNullEntityNode(markedForValueEvaluation, this.idInstr);
        }
        if (this.entity instanceof OlapEmptyEntity) {
            return new GFEmptyEntityNode(markedForValueEvaluation, this.idInstr);
        }
        if (this.entity instanceof OlapAsNamedSetReference) {
            return ((OlapAsNamedSetReference)this.entity).getGFTreeReference();
        }
        if (this.entity instanceof OlapDimension) {
            return new GFDimensionNode(markedForValueEvaluation, this.idInstr, (OlapDimension)this.entity);
        }
        if (this.entity instanceof OlapHierarchy) {
            return new GFHierarchyNode(markedForValueEvaluation, this.idInstr, (OlapHierarchy)this.entity);
        }
        if (this.entity instanceof OlapLevel) {
            return new GFLevelNode(markedForValueEvaluation, this.idInstr, (OlapLevel)this.entity);
        }
        if (this.entity instanceof OlapMeasureGroup) {
            return new GFMeasureGroupNode(markedForValueEvaluation, this.idInstr, (OlapMeasureGroup)this.entity);
        }
        if (this.entity instanceof OlapCubeEntity) {
            return new GFCubeEntityNode(markedForValueEvaluation, this.idInstr, (OlapCubeEntity)this.entity);
        }
        if (this.entity instanceof OlapListTupleSet) {
            return new GFListTupleSetNode(markedForValueEvaluation, this.idInstr, (OlapListTupleSet)this.entity);
        }
        if (this.entity instanceof OlapIteratorTupleSet) {
            return new GFIteratorTupleSetNode(markedForValueEvaluation, this.idInstr, (OlapIteratorTupleSet)this.entity);
        }
        if (this.entity instanceof OlapStringEntity) {
            return new GFStringNode(markedForValueEvaluation, this.idInstr, (OlapStringEntity)this.entity);
        }
        if (this.entity instanceof OlapNeutralTupleSet) {
            return new GFNeutralTupleSetNode(markedForValueEvaluation, this.idInstr);
        }
        throw new RuntimeException("internal error: " + this.entity.getClass().getSimpleName() + " not supported");
    }
}

