/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.evaluator.monitoring;

import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileMonitoringMode;
import crazydev.iccube.olap.eval.extra.OlapMdxExtraExecutor;
import crazydev.iccube.olap.eval.facts.cells.OlapMdxCellExecutor;
import crazydev.iccube.pub.principal.OlapPrincipal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapMdxExecutorMonitoring {
    @Nullable
    public static Factory factory;
    private final Map<String, Set<Integer>> profileCellExecutors = new HashMap<String, Set<Integer>>();
    private final Map<String, Set<Integer>> profileExtraExecutors = new HashMap<String, Set<Integer>>();

    protected OlapMdxExecutorMonitoring() {
    }

    public static OlapMdxExecutorMonitoring create(OlapEngineMdxEvalProfileMonitoringMode mode) {
        OlapMdxExecutorMonitoring monitoring;
        if (mode == OlapEngineMdxEvalProfileMonitoringMode.TEST && factory != null && (monitoring = factory.create()) != null) {
            return monitoring;
        }
        return new OlapMdxExecutorMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreateCellExecutor(OlapEngineMdxEvalProfile profile, OlapMdxCellExecutor executor) {
        Map<String, Set<Integer>> map = this.profileCellExecutors;
        synchronized (map) {
            String name = profile.getName();
            Set executors = this.profileCellExecutors.computeIfAbsent(name, k -> new HashSet());
            executors.add(executor.getUid());
        }
    }

    public void onDeleteCellExecutor(OlapMdxCellExecutor executor) {
    }

    public void onBeforeCellProcessing(OlapPrincipal user, OlapEngineMdxEvalProfile profile, OlapMdxCellExecutor executor) {
    }

    public void onAfterCellProcessing(OlapPrincipal user, OlapEngineMdxEvalProfile profile, OlapMdxCellExecutor executor) {
    }

    public int getCreatedCellExecutorCount() {
        return OlapMdxCellExecutor.getCurrentUid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreateExtraExecutor(OlapEngineMdxEvalProfile profile, OlapMdxExtraExecutor executor) {
        Map<String, Set<Integer>> map = this.profileExtraExecutors;
        synchronized (map) {
            String name = profile.getName();
            Set executors = this.profileExtraExecutors.computeIfAbsent(name, k -> new HashSet());
            executors.add(executor.getUid());
        }
    }

    public void onDeleteExtraExecutor(OlapMdxExtraExecutor executor) {
    }

    public void onBeforeExtraProcessing(OlapPrincipal user, OlapEngineMdxEvalProfile profile, OlapMdxExtraExecutor executor) {
    }

    public void onAfterExtraProcessing(OlapPrincipal user, OlapEngineMdxEvalProfile profile, OlapMdxExtraExecutor executor) {
    }

    public int getCreatedExtraExecutorCount() {
        return OlapMdxExtraExecutor.getCurrentUid();
    }

    @Nullable
    public Integer getMaxRequestCount(String profile) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getProfileCellExecutorCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Map<String, Set<Integer>> map = this.profileCellExecutors;
        synchronized (map) {
            for (Map.Entry<String, Set<Integer>> entry : this.profileCellExecutors.entrySet()) {
                String name = entry.getKey();
                Set<Integer> executors = entry.getValue();
                counts.put(name, executors.size());
            }
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getProfileExtraExecutorCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Map<String, Set<Integer>> map = this.profileExtraExecutors;
        synchronized (map) {
            for (Map.Entry<String, Set<Integer>> entry : this.profileExtraExecutors.entrySet()) {
                String name = entry.getKey();
                Set<Integer> executors = entry.getValue();
                counts.put(name, executors.size());
            }
        }
        return counts;
    }

    public static interface Factory {
        public OlapMdxExecutorMonitoring create();
    }
}

