/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.evaluator;

import crazydev.iccube.configuration.component.OlapEngineMdxEvalConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileForkMode;
import crazydev.iccube.olap.eval.evaluator.OlapMdxCellExecutorReference;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorReference;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsPool;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExtraExecutorReference;
import crazydev.iccube.olap.eval.evaluator.monitoring.OlapMdxExecutorMonitoring;
import crazydev.iccube.olap.eval.extra.OlapMdxExtraExecutor;
import crazydev.iccube.olap.eval.facts.cells.OlapMdxCellExecutor;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapMdxExecutorsContainer {
    private final OlapMdxExecutorMonitoring monitoring;
    private final Map<String, OlapMdxCellExecutorReference> cellExecutors = new HashMap<String, OlapMdxCellExecutorReference>();
    private final Map<String, OlapMdxExtraExecutorReference> extraExecutors = new HashMap<String, OlapMdxExtraExecutorReference>();
    private final OlapMdxExecutorsPool pool;
    @Nullable
    private final String keyForServerDefault;

    public OlapMdxExecutorsContainer(OlapEngineMdxEvalConfiguration configuration, OlapMdxExecutorMonitoring monitoring) {
        this.monitoring = monitoring;
        this.pool = new OlapMdxExecutorsPool(monitoring);
        String defaultServerKey = null;
        List<OlapEngineMdxEvalProfile> profiles = configuration.getProfiles();
        for (OlapEngineMdxEvalProfile profile : profiles) {
            if (!profile.isDefault() || profile.getForkMode() != OlapEngineMdxEvalProfileForkMode.SERVER) continue;
            defaultServerKey = "server:" + profile.getName();
            break;
        }
        this.keyForServerDefault = defaultServerKey;
    }

    public OlapMdxExecutorMonitoring getMonitoring() {
        return this.monitoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        Object executor;
        Map<String, OlapMdxExecutorReference> map = this.cellExecutors;
        synchronized (map) {
            for (OlapMdxCellExecutorReference olapMdxCellExecutorReference : this.cellExecutors.values()) {
                executor = (OlapMdxCellExecutor)olapMdxCellExecutorReference.getExecutor();
                ((OlapMdxCellExecutor)executor).shutdownNow();
            }
            this.pool.shutdownNowCellExecutors();
        }
        map = this.extraExecutors;
        synchronized (map) {
            for (OlapMdxExtraExecutorReference olapMdxExtraExecutorReference : this.extraExecutors.values()) {
                executor = (OlapMdxExtraExecutor)olapMdxExtraExecutorReference.getExecutor();
                ((OlapMdxExtraExecutor)executor).shutdownNow();
            }
            this.pool.shutdownNowExtraExecutors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQueuedTaskCountForServerDefaultProfile() {
        if (this.keyForServerDefault == null) {
            return 0L;
        }
        Map<String, OlapMdxCellExecutorReference> map = this.cellExecutors;
        synchronized (map) {
            OlapMdxCellExecutorReference executorREF = this.cellExecutors.get(this.keyForServerDefault);
            if (executorREF != null) {
                OlapMdxCellExecutor executor = (OlapMdxCellExecutor)executorREF.getExecutor();
                return executor.getQueuedTaskCount();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapMdxCellExecutorReference getOrCreateCellExecutor(OlapPrincipal principal, OlapEngineMdxEvalProfile profile) {
        String key = OlapMdxExecutorsContainer.createExecutorKey(principal, profile);
        Map<String, OlapMdxCellExecutorReference> map = this.cellExecutors;
        synchronized (map) {
            OlapMdxCellExecutorReference executorREF = this.cellExecutors.get(key);
            if (executorREF == null) {
                OlapMdxCellExecutor executor = this.pool.getOrCreateCellExecutor(profile);
                executorREF = new OlapMdxCellExecutorReference(key, executor);
                this.cellExecutors.put(key, executorREF);
            }
            executorREF.increment();
            return executorREF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCellExecutor(OlapMdxCellExecutorReference executor) {
        Map<String, OlapMdxCellExecutorReference> map = this.cellExecutors;
        synchronized (map) {
            if (executor.decrement() <= 0) {
                this.cellExecutors.remove(executor.getKey());
                this.pool.releaseCellExecutor((OlapMdxCellExecutor)executor.getExecutor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapMdxExtraExecutorReference getOrCreateExtraExecutor(OlapPrincipal principal, OlapEngineMdxEvalProfile profile) {
        String key = OlapMdxExecutorsContainer.createExecutorKey(principal, profile);
        Map<String, OlapMdxExtraExecutorReference> map = this.extraExecutors;
        synchronized (map) {
            OlapMdxExtraExecutorReference executorREF = this.extraExecutors.get(key);
            if (executorREF == null) {
                OlapMdxExtraExecutor executor = this.pool.getOrCreateExtraExecutor(profile);
                executorREF = new OlapMdxExtraExecutorReference(key, executor);
                this.extraExecutors.put(key, executorREF);
            }
            executorREF.increment();
            return executorREF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExtraExecutor(OlapMdxExtraExecutorReference executor) {
        Map<String, OlapMdxExtraExecutorReference> map = this.extraExecutors;
        synchronized (map) {
            if (executor.decrement() <= 0) {
                this.extraExecutors.remove(executor.getKey());
                this.pool.releaseExtraExecutor((OlapMdxExtraExecutor)executor.getExecutor());
            }
        }
    }

    private static String createExecutorKey(OlapPrincipal principal, OlapEngineMdxEvalProfile profile) {
        OlapEngineMdxEvalProfileForkMode forkMode = profile.getForkMode();
        switch (forkMode) {
            case SERVER: {
                return "server:" + profile.getName();
            }
            case ROLE: {
                return "role:" + principal.getRoleNameForMdxExecutionProfile();
            }
            case TENANT: {
                OlapTenant tenant = principal.getTenant();
                if (tenant == null) {
                    throw new RuntimeException("mdxEvalConfiguration (icCube.xml) : profile ( name : " + profile.getName() + " / forkMode : " + forkMode.name() + " ) - user (" + principal.getName() + ") has no tenant.");
                }
                return "tenant:" + tenant.getName();
            }
            case USER: {
                return "user:" + principal.getName();
            }
        }
        throw new RuntimeException("internal error: unexpected MDX profile fork mode");
    }
}

