/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.evaluator;

import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorTaskFactory;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.eval.evaluator.OlapMdxCellExecutorReference;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermitCancelled;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermitRegular;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExtraExecutorReference;
import crazydev.iccube.olap.eval.evaluator.monitoring.OlapMdxExecutorMonitoring;
import crazydev.iccube.olap.eval.exception.OlapMdxEvaluationCancelled;
import crazydev.iccube.olap.eval.extra.OlapMdxExtraExecutor;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellEvaluationTaskFactory;
import crazydev.iccube.olap.eval.facts.cells.OlapMdxCellExecutor;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestTracker;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import org.jetbrains.annotations.Nullable;

public class OlapMdxExecutors {
    private final OlapMdxExecutorsManager manager;
    private final OlapMdxExecutorMonitoring monitoring;
    private final OlapEngineMdxEvalProfile profile;
    private final boolean extraProcessingActivated;

    public OlapMdxExecutors(OlapMdxExecutorsManager manager, OlapEngineMdxEvalProfile profile) {
        this.manager = manager;
        this.monitoring = manager.getMonitoring();
        this.profile = profile;
        this.extraProcessingActivated = manager.isExtraProcessingActivated(profile);
    }

    public int cellThreadCount() {
        return this.profile.getCellThreadCount();
    }

    public int extraThreadCount() {
        return this.profile.getExtraThreadCount();
    }

    public int getCellCountMax(@Nullable Integer cellCountMax) {
        int profileCellCountMax;
        int requestCellCountMax = OlapMdxExecutors.fixRequestProperty(cellCountMax);
        int max = Math.min(requestCellCountMax, profileCellCountMax = OlapMdxExecutors.fixRequestProperty(this.profile.getCellCount()));
        if (max == Integer.MAX_VALUE) {
            return -1;
        }
        return max;
    }

    public int getTimeoutS(@Nullable Integer timeoutS) {
        int profileTimeoutS;
        int requestTimeoutS = OlapMdxExecutors.fixRequestProperty(timeoutS);
        int max = Math.min(requestTimeoutS, profileTimeoutS = OlapMdxExecutors.fixRequestProperty(this.profile.getTimeoutS()));
        if (max == Integer.MAX_VALUE) {
            return -1;
        }
        return max;
    }

    public int getMaterializedSetTupleCountMax(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getMaterializedSetTupleCount()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getTidyMaterializedAxisTupleCountMax(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getTidyMaterializedAxisTupleCount()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getInternalTupleListCount(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getInternalTupleListCount()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getInternalTupleListCountCJ(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getInternalTupleListCountCJ()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getTidyRowCountMax(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getTidyRowCount()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getTidyColumnCountMax(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getTidyColumnCount()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getTidyCellCountMax(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getTidyCellCount()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getTidyCellCountMaxNE(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getTidyCellCountNE()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getNeCjIndexCacheLimit(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getNeCjIndexCacheLimit()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getNeCjThreadCount(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestPropertyTC(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestPropertyTC(this.profile.getNeCjThreadCount()));
        if (max == -1) {
            return CdSystemUtils.availableProcessors();
        }
        return max;
    }

    public int getNeCjMaxPreCalculated(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getNeCjMaxPreCalculated()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public int getNeCjMaxPreCalculatedTuples(@Nullable Integer count) {
        int profileMax;
        int requestMax = OlapMdxExecutors.fixRequestProperty(count);
        int max = Math.min(requestMax, profileMax = OlapMdxExecutors.fixRequestProperty(this.profile.getNeCjMaxPreCalculatedTuples()));
        if (max == -1) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    public boolean isNeCjAsyncActivated() {
        return this.profile.isNeCjAsyncActivated();
    }

    public boolean isNeCjParallelActivated() {
        return this.profile.isNeCjParallelActivated();
    }

    private static int fixRequestProperty(@Nullable Integer value) {
        if (value == null) {
            value = -1;
        }
        if (value == -1) {
            value = Integer.MAX_VALUE;
        }
        return value;
    }

    private static int fixRequestPropertyTC(@Nullable Integer value) {
        if (value == null) {
            value = -1;
        }
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public boolean isExtraProcessingActivated() {
        return this.extraProcessingActivated;
    }

    public OlapMdxExecutionPermit acquireExecutionPermit(OlapMdxStatementExecutionContext sContext) {
        boolean withProfilePermit;
        OlapRequestTracker.onMdxRequestProfileSelected(sContext, this.profile);
        OlapEngineRequestContext requestContext = sContext.getRequestContext();
        IcCubeRequestStatusManager requestStatusManager = requestContext.getRequestStatusManager();
        int timeoutS = sContext.getMdxTimeoutS();
        if (requestStatusManager.setRequestTimeout(requestContext.getRequestClientUUID(), timeoutS)) {
            OlapRequestTracker.onRequestWithTimeout(sContext, timeoutS);
        }
        try {
            this.manager.acquireGlobalMdxRequestPermit(sContext);
        }
        catch (InterruptedException ex) {
            return new OlapMdxExecutionPermitCancelled(this);
        }
        try {
            withProfilePermit = this.manager.acquireProfileMdxRequestPermit(sContext, this.profile);
        }
        catch (InterruptedException ex) {
            this.manager.releaseGlobalMdxRequestPermit(sContext);
            return new OlapMdxExecutionPermitCancelled(this);
        }
        OlapMdxExecutionPermitRegular permit = new OlapMdxExecutionPermitRegular(this, withProfilePermit);
        return permit;
    }

    public void releaseExecutionPermit(OlapMdxStatementExecutionContext context, OlapMdxExecutionPermit permit) {
        if (permit.getExecutors() != this) {
            throw new RuntimeException("internal error: inconsistent MDX execution permit");
        }
        if (permit.isWithProfilePermit()) {
            this.manager.releaseProfileMdxRequestPermit(context, this.profile);
        }
        this.manager.releaseGlobalMdxRequestPermit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeForCellsProcessing(OlapMdxStatementExecutionContext context, OlapFactsCellEvaluationTaskFactory tasks, OlapMdxExecutionPermit permit) throws OlapMdxEvaluationCancelled {
        if (permit.getExecutors() != this) {
            throw new RuntimeException("internal error: inconsistent MDX execution permit");
        }
        if (permit.isCancelled()) {
            return;
        }
        OlapPrincipal user = context.getUser();
        OlapMdxCellExecutorReference cellExecutorREF = this.manager.getOrCreateCellExecutor(user, this.profile);
        try {
            OlapMdxCellExecutor cellExecutor = (OlapMdxCellExecutor)cellExecutorREF.getExecutor();
            this.monitoring.onBeforeCellProcessing(user, this.profile, cellExecutor);
            cellExecutor.execute(context, tasks);
            this.monitoring.onAfterCellProcessing(user, this.profile, cellExecutor);
        }
        finally {
            this.manager.releaseCellExecutor(cellExecutorREF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeForExtraProcessing(OlapMdxStatementExecutionContext context, IOlapThreadPoolExecutorTaskFactory tasks, OlapMdxExecutionPermit permit) throws OlapMdxEvaluationCancelled {
        if (permit.getExecutors() != this) {
            throw new RuntimeException("internal error: inconsistent MDX execution permit");
        }
        OlapPrincipal user = context.getUser();
        OlapMdxExtraExecutorReference extraExecutorREF = this.manager.getOrCreateExtraExecutor(context.getUser(), this.profile);
        try {
            OlapMdxExtraExecutor extraExecutor = (OlapMdxExtraExecutor)extraExecutorREF.getExecutor();
            this.monitoring.onBeforeExtraProcessing(user, this.profile, extraExecutor);
            extraExecutor.execute(context, tasks);
            this.monitoring.onAfterExtraProcessing(user, this.profile, extraExecutor);
        }
        finally {
            this.manager.releaseExtraExecutor(extraExecutorREF);
        }
    }
}

