/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.define;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.OlapResCreateCalcMemberBlankStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResDefineDefaultMemberBlankStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapDefineDefaultMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapDefineDefaultMemberStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDefineDefaultMemberStatementInstr
extends OlapCreateStatementInstr<OlapDefineDefaultMemberStatementExecutionContext> {
    private final OlapEntityIdentifier id;

    public OlapDefineDefaultMemberStatementInstr(OlapInstrLocationRange range, OlapEntityIdentifier id) {
        super(range);
        this.id = id;
    }

    @Override
    public String typeForError() {
        return "DEFINE DEFAULT MEMBER";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
    }

    @Override
    protected OlapDefineDefaultMemberStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDefineDefaultMemberStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDefineDefaultMemberStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        OlapSchema schema = context.getSchema();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateCalcMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapDefineDefaultMemberEvaluationContext eContext = new OlapDefineDefaultMemberEvaluationContext(this.getLocationRange(), context);
        OlapNonScalarEntity entity = eContext.lookupEntityByMdxIdentifier(context.getNameContext(), OlapMdxEntityLookupKinds.ALL_BUT_SET, this.id);
        if (!(entity instanceof OlapMember)) {
            throw new OlapEvaluationException(context, OlapErrorCode.DEFINE_DEFAULT_MEMBER_TYPE_MISMATCH, new Serializable[]{this.id.asString(), entity.getFriendlyTypeName()});
        }
        OlapMember member = (OlapMember)entity;
        OlapHierarchy hierarchy = member.getHierarchy();
        hierarchy.setDefaultMember(member);
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResDefineDefaultMemberBlankStatementDataSet(schema.getName(), "?", member.getUniqueName(context.getNameContext()));
    }

    public OlapEntityIdentifier getId() {
        return this.id;
    }

    @Override
    public String toStringForDebugger() {
        return "DEFINE DEFAULT MEMBER : " + this.id.asString();
    }
}

