/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.command;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResExecCommandBlankStatementDataSet;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.command.OlapExecCommandStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapExecCommandStatementExecutionContext;
import java.io.Serializable;

public class OlapResultCacheExecCommandStatementInstr
extends OlapExecCommandStatementInstr {
    public OlapResultCacheExecCommandStatementInstr(OlapInstrLocationRange range) {
        super(range);
    }

    @Override
    public String typeForError() {
        return super.typeForError() + " result_cache clear";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapEntity doExecute(OlapExecCommandStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isMonitoringRequestsEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.monitoring / app.monitoring.requests"});
        }
        OlapCacheManager cacheManager = context.getCacheManager();
        cacheManager.clearResultCache(context.getRequestContext());
        return new OlapResExecCommandBlankStatementDataSet(context.getSchemaName(), "?", "clear result cache");
    }

    @Override
    public String toStringForDebugger() {
        return super.toStringForDebugger() + " result_cache clear";
    }
}

