/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.eval.catmember.OlapBaseCategoryMemberManager;
import crazydev.iccube.olap.eval.catmember.OlapSessionCategoryMemberManager;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapRequestCategoryMemberManager
extends OlapBaseCategoryMemberManager {
    private final OlapSessionCategoryMemberManager sessionManager;
    private OlapEngineRequestContext request;

    public OlapRequestCategoryMemberManager(OlapEngineRequestContext request, OlapSessionCategoryMemberManager sessionManager) {
        this.request = request;
        this.sessionManager = sessionManager;
    }

    @Override
    public OlapHierarchyScope getScope() {
        return OlapHierarchyScope.REQUEST;
    }

    @Override
    @Nullable
    public OlapEngineSessionContext getSessionContext() {
        return null;
    }

    @Override
    @Nullable
    public OlapEngineRequestContext getRequestContext() {
        return this.request;
    }

    public void deleteAll() {
        for (OlapBaseCategoryMemberManager.SchemaInformation schemaInformation : this.schemaInfos.values()) {
            schemaInformation.deleteCategoryHierarchyBitmaps();
        }
        this.schemaInfos.clear();
    }

    @Override
    protected OlapBaseCategoryMemberManager.SchemaInformation createSchemaInformation(OlapSchema schema) {
        OlapBaseCategoryMemberManager.SchemaInformation sessionInfo = this.sessionManager.getSchemaInfo(schema);
        return new RequestSchemaInformation(this, sessionInfo, schema);
    }

    public int getNextHierarchyIndexOffset(OlapSchema schema) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.getSchemaInfo(schema);
        if (info == null) {
            return -1;
        }
        return info.getNextHierarchyIndexOffset();
    }

    @Nullable
    public List<OlapHierarchy> getAllSessionCategoryMemberHierarchies(OlapSchema schema) {
        OlapBaseCategoryMemberManager.SchemaInformation info = this.sessionManager.getSchemaInfo(schema);
        if (info == null) {
            return null;
        }
        return info.getAllCategoryMemberHierarchies();
    }

    class RequestSchemaInformation
    extends OlapBaseCategoryMemberManager.SchemaInformation {
        @Nullable
        private final OlapBaseCategoryMemberManager.SchemaInformation sessionInfo;

        RequestSchemaInformation(@Nullable OlapRequestCategoryMemberManager this$0, OlapBaseCategoryMemberManager.SchemaInformation sessionInfo, OlapSchema schema) {
            Objects.requireNonNull(this$0);
            super(this$0, schema);
            this.sessionInfo = sessionInfo;
        }

        @Override
        int getNextHierarchyIndexOffset() {
            return (this.sessionInfo != null ? this.sessionInfo.getNextHierarchyIndexOffset() : 0) + super.getNextHierarchyIndexOffset();
        }

        @Override
        int getAndIncrementNextHierarchyIndexOffset() {
            return (this.sessionInfo != null ? this.sessionInfo.getNextHierarchyIndexOffset() : 0) + super.getAndIncrementNextHierarchyIndexOffset();
        }
    }
}

