/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapFactlessCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.result.OlapResDropCategoryHierarchyBlankStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.catmember.OlapSessionCategoryMemberManager;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropCategoryHierarchyStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapLookupCategoryMemberAnchorEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropCategoryHierarchyStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropCategoryHierarchyStatementExecutionContext> {
    private final boolean sessionScoped;
    private final List<OlapEntityIdentifier> ids;

    public OlapDropCategoryHierarchyStatementInstr(OlapInstrLocationRange range, boolean sessionScoped, List<OlapEntityIdentifier> ids) {
        super(range);
        this.sessionScoped = sessionScoped;
        this.ids = ids;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP CATEGORY HIERARCHY";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropCategoryHierarchyStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropCategoryHierarchyStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropCategoryHierarchyStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapEntity executeForGlobalScope(OlapDropCategoryHierarchyStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropCategoryHierarchyBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        boolean hasDeletedSomething = false;
        for (OlapEntityIdentifier id : this.ids) {
            OlapHierarchy hierarchy = this.lookupCategoryHierarchy(context, schema, id);
            if (hierarchy == null) continue;
            if (!hierarchy.isSchemaBased()) {
                throw new OlapEvaluationException(context, OlapErrorCode.CAT_HIERARCHY_DELETE_SCOPE_MISMATCH, new Serializable[]{id.asString(), OlapHierarchyScope.SCHEMA, hierarchy.getScope()});
            }
            if (hierarchy.deleteAllCategoryMembers()) {
                hasDeletedSomething = true;
            }
            if (schema.deleteAllCategoryCalculatedMembers(hierarchy)) {
                hasDeletedSomething = true;
            }
            if (!hierarchy.removeCategory()) continue;
            hasDeletedSomething = true;
        }
        if (hasDeletedSomething) {
            this.onScriptStatementApplied(context, schema, true);
        }
        return new OlapResDropCategoryHierarchyBlankStatementDataSet(schema.getName(), "?", this.getNames());
    }

    private OlapEntity executeForSessionScope(OlapDropCategoryHierarchyStatementExecutionContext context) {
        OlapSchema schema = context.getSchema();
        boolean hasDeletedSomething = false;
        for (OlapEntityIdentifier id : this.ids) {
            OlapHierarchy hierarchy = this.lookupCategoryHierarchy(context, schema, id);
            if (hierarchy == null) continue;
            if (!hierarchy.isSessionBased()) {
                throw new OlapEvaluationException(context, OlapErrorCode.CAT_HIERARCHY_DELETE_SCOPE_MISMATCH, new Serializable[]{id.asString(), OlapHierarchyScope.SESSION, hierarchy.getScope()});
            }
            OlapSessionCategoryMemberManager manager = context.getSessionCategoryMemberManager();
            if (!manager.dropCategoryMemberHierarchy(context.getNameContext(), hierarchy)) continue;
            hasDeletedSomething = true;
        }
        if (hasDeletedSomething) {
            this.onScriptStatementApplied(context, schema, false);
        }
        return new OlapResDropCategoryHierarchyBlankStatementDataSet(schema.getName(), "?", this.getNames());
    }

    @Nullable
    private OlapHierarchy lookupCategoryHierarchy(OlapDropCategoryHierarchyStatementExecutionContext context, OlapSchema schema, OlapEntityIdentifier id) {
        OlapHierarchy hierarchy;
        OlapFactlessCube cube = new OlapFactlessCube(this.getLocationRange(), "drop-category-hierarchy-", context.getSchema());
        OlapLookupCategoryMemberAnchorEvaluationContext evalContext = new OlapLookupCategoryMemberAnchorEvaluationContext(new OlapMdxStatementWithCubeSelectExecutionContext(context.getRequestContext(), context.getRequestProperties(), context.getAnnotations(), context.getInstrExecListener(), context.getSchema(), cube, true));
        OlapNonScalarEntity entity = evalContext.lookupEntityByMdxIdentifier(evalContext.getNameContext(), OlapMdxEntityLookupKinds.ALL_BUT_SET, id);
        if (entity instanceof OlapHierarchy && (hierarchy = (OlapHierarchy)entity).acceptCategoryMembers()) {
            return hierarchy;
        }
        return null;
    }

    private String getNames() {
        StringBuilder sb = new StringBuilder();
        for (OlapEntityIdentifier id : this.ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(id.asString());
        }
        return sb.toString();
    }

    @Override
    public String toStringForDebugger() {
        return "DROP CATEGORY HIERARCHY : " + this.ids.toString();
    }
}

