/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapCalcCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.result.OlapResCreateCalcMemberBlankStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResCreateCategoryMemberBlankStatementDataSet;
import crazydev.iccube.olap.eval.calcmember.OlapCreateCalcMemberStatementInstrHelper;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryMemberStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCreateCategoryMemberStatementInstr
extends OlapCreateStatementInstr<OlapCreateCategoryMemberStatementExecutionContext> {
    private final OlapInstrLocationRange idRange;
    private final boolean sessionScoped;
    private final MdxIdentifierExpression parseId;
    private final OlapEntityIdentifier id;
    private final boolean dynamicEvaluation;
    private final boolean calculated;
    private final OlapInstr formula;
    private final OlapCategoryMemberProperties properties;

    public OlapCreateCategoryMemberStatementInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, boolean sessionScoped, MdxIdentifierExpression parseId, OlapEntityIdentifier id, boolean dynamicEvaluation, boolean calculated, OlapInstr formula, OlapCategoryMemberProperties properties) {
        super(range);
        this.idRange = idRange;
        this.sessionScoped = sessionScoped;
        this.parseId = parseId;
        this.id = id;
        this.dynamicEvaluation = dynamicEvaluation;
        this.calculated = calculated;
        this.formula = formula;
        this.formula.setParent(this);
        this.properties = properties;
    }

    @Override
    public String typeForError() {
        return "CREATE CATEGORY MEMBER";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    public boolean requiresFacts() {
        return true;
    }

    @Override
    protected OlapCreateCategoryMemberStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapCreateCategoryMemberStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapCreateCategoryMemberStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapEntity executeForGlobalScope(OlapCreateCategoryMemberStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        OlapSchema schema = context.getSchema();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateCalcMemberBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        if (this.calculated) {
            // empty if block
        }
        OlapAbstractCategoryMember categoryMember = !this.calculated ? this.createCategoryMember(context, OlapHierarchyScope.SCHEMA, this.id, this.dynamicEvaluation, this.formula, this.properties) : this.createCalcCategoryMemberForGlobalScope(context);
        this.onScriptStatementApplied(context, schema, true);
        OlapNameContext nameContext = context.getNameContext();
        return new OlapResCreateCategoryMemberBlankStatementDataSet(schema.getName(), "?", categoryMember.getUniqueName(nameContext));
    }

    private OlapAbstractCategoryMember createCalcCategoryMemberForGlobalScope(OlapCreateCategoryMemberStatementExecutionContext context) {
        OlapNameContext nameContext = context.getNameContext();
        OlapCreateCalcMemberStatementExecutionContext cmContext = new OlapCreateCalcMemberStatementExecutionContext(context.getRequestContext(), context.getRequestProperties(), context.getInstrExecListener(), context.getSchema());
        OlapCreateCalcMemberStatementInstrHelper helper = new OlapCreateCalcMemberStatementInstrHelper(cmContext, nameContext, this.idRange, this.parseId, this.id, this.formula, new OlapCellProperties());
        OlapMember fakeCalcMember = helper.createCalcMember(true);
        OlapMember parent = fakeCalcMember.getParent();
        String name = fakeCalcMember.getName(OlapNameContext.DEFAULT_VALUES);
        OlapCalcCategoryMember categoryMember = new OlapCalcCategoryMember((OlapMdxStatementExecutionContext)context, (OlapInstr)this, OlapHierarchyScope.SCHEMA, this.id, this.dynamicEvaluation, this.formula, this.properties, parent, name);
        helper.registerCalcMember(categoryMember);
        return categoryMember;
    }

    private OlapEntity executeForSessionScope(OlapCreateCategoryMemberStatementExecutionContext context) {
        if (context.isSessionLess()) {
            throw new OlapEvaluationException(context, OlapErrorCode.MDX_SESSION_MISMATCH, new Serializable[]{"category-member"});
        }
        OlapAbstractCategoryMember categoryMember = this.createCategoryMember(context, OlapHierarchyScope.SESSION, this.id, this.dynamicEvaluation, this.formula, this.properties);
        OlapSchema schema = context.getSchema();
        OlapNameContext nameContext = context.getNameContext();
        this.onScriptStatementApplied(context, schema, false);
        return new OlapResCreateCategoryMemberBlankStatementDataSet(schema.getName(), "?", categoryMember.getUniqueName(nameContext));
    }

    public OlapEntityIdentifier getId() {
        return this.id;
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE CATEGORY MEMBER : " + this.id.asString();
    }
}

