/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.catmember.OlapCategoryHierarchyProperties;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.result.OlapResCreateCategoryHierarchyBlankStatementDataSet;
import crazydev.iccube.olap.eval.catmember.OlapSchemaCategoryMemberManager;
import crazydev.iccube.olap.eval.catmember.OlapSessionCategoryMemberManager;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryHierarchyStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCreateCategoryHierarchyStatementInstr
extends OlapCreateStatementInstr<OlapCreateCategoryHierarchyStatementExecutionContext> {
    private final OlapInstrLocationRange idRange;
    private final boolean sessionScoped;
    private final OlapEntityIdentifier id;
    private final OlapCategoryHierarchyProperties properties;

    public OlapCreateCategoryHierarchyStatementInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, boolean sessionScoped, OlapEntityIdentifier id, OlapCategoryHierarchyProperties properties) {
        super(range);
        this.idRange = idRange;
        this.sessionScoped = sessionScoped;
        this.id = id;
        this.properties = properties;
    }

    @Override
    public String typeForError() {
        return "CREATE CATEGORY HIERARCHY";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            // empty if block
        }
    }

    @Override
    protected OlapCreateCategoryHierarchyStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapCreateCategoryHierarchyStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapCreateCategoryHierarchyStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapEntity executeForGlobalScope(OlapCreateCategoryHierarchyStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        OlapSchema schema = context.getSchema();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateCategoryHierarchyBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapDimension schemaDimension = this.lookupCategoryDimension(context, this.id);
        String hierarchyName = this.getCategoryHierarchyName(context, this.id);
        OlapSchemaCategoryMemberManager manager = schema.getCategoryMemberManager();
        manager.createCategoryMemberHierarchy(context, context.getNameContext(), schemaDimension, hierarchyName, this.properties);
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResCreateCategoryHierarchyBlankStatementDataSet(schema.getName(), "?", this.id.asString());
    }

    private OlapEntity executeForSessionScope(OlapCreateCategoryHierarchyStatementExecutionContext context) {
        if (context.isSessionLess()) {
            throw new OlapEvaluationException(context, OlapErrorCode.MDX_SESSION_MISMATCH, new Serializable[]{"category-hierarchy"});
        }
        OlapSchema schema = context.getSchema();
        OlapDimension schemaDimension = this.lookupCategoryDimension(context, this.id);
        String hierarchyName = this.getCategoryHierarchyName(context, this.id);
        OlapSessionCategoryMemberManager manager = context.getSessionCategoryMemberManager();
        manager.createCategoryMemberHierarchy(context, context.getNameContext(), schemaDimension, hierarchyName, this.properties);
        this.onScriptStatementApplied(context, schema, false);
        return new OlapResCreateCategoryHierarchyBlankStatementDataSet(schema.getName(), "?", this.id.asString());
    }

    public OlapEntityIdentifier getId() {
        return this.id;
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE CATEGORY HIERARCHY : " + this.id.asString();
    }
}

