/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.catmember;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.catmember.OlapCategoryHierarchyProperties;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.catmember.IOlapBaseCategoryMemberManager;
import crazydev.iccube.olap.eval.catmember.OlapCreateCategoryHierarchyHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBaseCategoryMemberManager
implements IOlapBaseCategoryMemberManager {
    protected final ConcurrentHashMap<OlapSchema, SchemaInformation> schemaInfos = new ConcurrentHashMap();

    public OlapHierarchy createCategoryMemberHierarchy(IOlapEvaluationExceptionContext errorContext, OlapNameContext nameContext, OlapDimension schemaDimension, String hierarchyName, OlapCategoryHierarchyProperties properties) {
        OlapSchema schema = schemaDimension.getSchema();
        SchemaInformation info = this.getOrCreateSchemaInfo(schema);
        return info.createCategoryMemberHierarchy(errorContext, nameContext, schemaDimension, hierarchyName, properties);
    }

    public boolean dropCategoryMemberHierarchy(OlapNameContext nameContext, OlapHierarchy hierarchy) {
        OlapDimension dimension = hierarchy.getDimension();
        OlapSchema schema = dimension.getSchema();
        SchemaInformation info = this.getOrCreateSchemaInfo(schema);
        return info.dropCategoryMemberHierarchy(nameContext, hierarchy);
    }

    @Nullable
    public List<OlapHierarchy> getAllCategoryMemberHierarchies(OlapSchema schema) {
        SchemaInformation info = this.getOrCreateSchemaInfo(schema);
        return info.getAllCategoryMemberHierarchies();
    }

    public boolean hasCategoryHierarchy(OlapSchema schema) {
        SchemaInformation info = this.getOrCreateSchemaInfo(schema);
        return info.hasCategoryHierarchy();
    }

    @Nullable
    protected SchemaInformation getSchemaInfo(OlapSchema schema) {
        SchemaInformation info = this.schemaInfos.get(schema);
        if (info != null && schema != info.schema) {
            throw new RuntimeException("internal error : inconsistent category hierarchy schema information (" + String.valueOf((Object)this.getScope()) + ") : " + schema.getName() + " / " + info.schema.getName());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaInformation getOrCreateSchemaInfo(OlapSchema schema) {
        ConcurrentHashMap<OlapSchema, SchemaInformation> concurrentHashMap = this.schemaInfos;
        synchronized (concurrentHashMap) {
            SchemaInformation info = this.schemaInfos.get(schema);
            if (info == null) {
                info = this.createSchemaInformation(schema);
                this.schemaInfos.put(schema, info);
            }
            return info;
        }
    }

    protected abstract SchemaInformation createSchemaInformation(OlapSchema var1);

    protected abstract class SchemaInformation {
        private final OlapSchema schema;
        private final Map<OlapDimension, List<OlapHierarchy>> categoryMemberHierarchies;
        private final List<OlapHierarchy> flatCategoryMemberHierarchies;
        private int nextHierarchyIndexOffset;
        final /* synthetic */ OlapBaseCategoryMemberManager this$0;

        SchemaInformation(OlapBaseCategoryMemberManager this$0, OlapSchema schema) {
            OlapBaseCategoryMemberManager olapBaseCategoryMemberManager = this$0;
            Objects.requireNonNull(olapBaseCategoryMemberManager);
            this.this$0 = olapBaseCategoryMemberManager;
            this.categoryMemberHierarchies = new HashMap<OlapDimension, List<OlapHierarchy>>();
            this.flatCategoryMemberHierarchies = new ArrayList<OlapHierarchy>();
            this.schema = schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onSessionDestroyed() {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                for (OlapHierarchy hierarchy : this.flatCategoryMemberHierarchies) {
                    hierarchy.deleteAllCategoryMembers();
                }
            }
        }

        void onSchemaPartitionsUnloaded(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onSchemaPartitionsLoaded(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onSchemaPartitionsLoadError() {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onSchemaIncrLoaded(OlapSchemaIncrLoadInfo incrLoadInfo) {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onSchemaIncrLoadedOnError() {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onScriptStatementApplied(OlapScriptInformation information) {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onSecurityPermissionsRemoved() {
            this.deleteCategoryHierarchyBitmaps();
        }

        void onSecurityPermissionsSwitched(@Nullable IOlapSchemaPermission permissions) {
            this.deleteCategoryHierarchyBitmaps();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteCategoryHierarchyBitmaps() {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                for (OlapHierarchy hierarchy : this.flatCategoryMemberHierarchies) {
                    hierarchy.resetCategoryMembers();
                    this.schema.deleteCategoryHierarchyBitmaps(hierarchy);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean dropCategoryMemberHierarchy(OlapNameContext nameContext, OlapHierarchy hierarchy) {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                OlapDimension schemaDimension = hierarchy.getDimension();
                List<OlapHierarchy> hierarchies = this.categoryMemberHierarchies.get(schemaDimension);
                if (hierarchies != null && hierarchies.remove(hierarchy)) {
                    this.flatCategoryMemberHierarchies.remove(hierarchy);
                    hierarchy.deleteAllCategoryMembers();
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OlapHierarchy createCategoryMemberHierarchy(IOlapEvaluationExceptionContext errorContext, OlapNameContext nameContext, OlapDimension schemaDimension, String hierarchyName, OlapCategoryHierarchyProperties properties) {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                OlapHierarchy hierarchy;
                List<OlapHierarchy> hierarchies = this.categoryMemberHierarchies.get(schemaDimension);
                if (hierarchies == null) {
                    hierarchies = new ArrayList<OlapHierarchy>();
                    this.categoryMemberHierarchies.put(schemaDimension, hierarchies);
                }
                if ((hierarchy = this.lookupCategoryMemberHierarchy(nameContext, hierarchies, hierarchyName)) != null) {
                    throw new OlapEvaluationException(errorContext, OlapErrorCode.CAT_HIERARCHY_DUPLICATED, new Serializable[]{this.this$0.getScope(), hierarchyName});
                }
                int hierarchyIndexOffset = this.getAndIncrementNextHierarchyIndexOffset();
                hierarchy = OlapCreateCategoryHierarchyHelper.createCategoryHierarchy(this.this$0.getScope(), hierarchyIndexOffset, schemaDimension, hierarchyName, properties);
                if (this.this$0.getScope() != OlapHierarchyScope.SCHEMA) {
                    schemaDimension.assertMissingHierarchy(hierarchy);
                }
                hierarchies.add(hierarchy);
                this.flatCategoryMemberHierarchies.add(hierarchy);
                return hierarchy;
            }
        }

        int getNextHierarchyIndexOffset() {
            return this.nextHierarchyIndexOffset;
        }

        int getAndIncrementNextHierarchyIndexOffset() {
            return this.nextHierarchyIndexOffset++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        OlapHierarchy lookupCategoryMemberHierarchy(OlapNameContext nameContext, List<OlapHierarchy> hierarchies, String name) {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                int size = hierarchies.size();
                for (int ii = 0; ii < size; ++ii) {
                    OlapHierarchy hierarchy = hierarchies.get(ii);
                    if (!OlapCaseInsensitiveName.equals(hierarchy.getName(nameContext), name)) continue;
                    return hierarchy;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasCategoryHierarchy() {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                if (!this.flatCategoryMemberHierarchies.isEmpty()) {
                    for (OlapHierarchy hierarchy : this.flatCategoryMemberHierarchies) {
                        OlapDimension dimension = hierarchy.getDimension();
                        if (!dimension.getSchema().equals(this.schema)) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<OlapHierarchy> getAllCategoryMemberHierarchies() {
            OlapSchema olapSchema = this.schema;
            synchronized (olapSchema) {
                return Collections.unmodifiableList(this.flatCategoryMemberHierarchies);
            }
        }
    }
}

